/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;

public class PGProcedureColumnsMetadatSourceFromQuery
extends PGResultSet
implements IMetadataSource {
    private int m_paramsnumbers = 0;
    private int m_paramsIndex = -1;
    private String[] m_paramsOids;
    private String[] m_paramsNames;

    public PGProcedureColumnsMetadatSourceFromQuery(PGMessagingContext contexts, int batchIndex, ILogger logger) {
        super(contexts, logger);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag columnTag, long offset, long maxSize, DataWrapper data) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{columnTag, offset, maxSize});
        switch (columnTag) {
            case CATALOG_NAME: {
                return super.getData(0, offset, maxSize, data);
            }
            case SCHEMA_NAME: {
                return super.getData(1, offset, maxSize, data);
            }
            case PROCEDURE_NAME: {
                return super.getData(2, offset, maxSize, data);
            }
            case COLUMN_NAME: {
                if (0 == this.m_paramsIndex) {
                    return super.getData(3, offset, maxSize, data);
                }
                if (this.m_paramsnumbers > 1) {
                    if (0 == this.m_paramsNames.length) {
                        data.setVarChar("$" + Integer.toString(this.m_paramsIndex));
                    } else {
                        data.setVarChar(this.m_paramsNames[this.m_paramsIndex - 1]);
                    }
                    return false;
                }
            }
            case PROCEDURE_COLUMN_TYPE: {
                if (0 == this.m_paramsIndex) {
                    return super.getData(4, offset, maxSize, data);
                }
                if (this.m_paramsnumbers > 1) {
                    data.setSmallInt(1);
                    return false;
                }
            }
            case DATA_TYPE: {
                if (0 == this.m_paramsIndex) {
                    super.getData(5, offset, maxSize, data);
                    try {
                        data.setSmallInt(PGDataTypeUtilities.oidToSQLType(data.getBigInt().intValue()));
                    }
                    catch (IncorrectTypeException e) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNCTION_ERR.name(), e, ExceptionType.DATA);
                    }
                    return false;
                }
                if (this.m_paramsnumbers > 1) {
                    data.setSmallInt(PGDataTypeUtilities.oidToSQLType(Integer.parseInt(this.m_paramsOids[this.m_paramsIndex - 1])));
                    return false;
                }
            }
            case DATA_TYPE_NAME: {
                if (0 == this.m_paramsIndex) {
                    super.getData(5, offset, maxSize, data);
                    try {
                        int type = PGDataTypeUtilities.oidToSQLType(data.getBigInt().intValue());
                        data.setVarChar(PGDataTypeUtilities.sqlTypeToString((short)type));
                    }
                    catch (IncorrectTypeException e) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNCTION_ERR.name(), e, ExceptionType.DATA);
                    }
                    return false;
                }
                if (this.m_paramsnumbers > 1) {
                    int type = PGDataTypeUtilities.oidToSQLType(Integer.parseInt(this.m_paramsOids[this.m_paramsIndex - 1]));
                    data.setVarChar(PGDataTypeUtilities.sqlTypeToString((short)type));
                    return false;
                }
            }
            case COLUMN_SIZE: {
                return super.getData(6, offset, maxSize, data);
            }
            case BUFFER_LENGTH: {
                return super.getData(7, offset, maxSize, data);
            }
            case DECIMAL_DIGITS: {
                return super.getData(8, offset, maxSize, data);
            }
            case NUM_PREC_RADIX: {
                return super.getData(9, offset, maxSize, data);
            }
            case NULLABLE: {
                return super.getData(10, offset, maxSize, data);
            }
            case REMARKS: {
                return super.getData(11, offset, maxSize, data);
            }
            case COLUMN_DEF: {
                return super.getData(12, offset, maxSize, data);
            }
            case SQL_DATA_TYPE: {
                return super.getData(13, offset, maxSize, data);
            }
            case SQL_DATETIME_SUB: {
                return super.getData(14, offset, maxSize, data);
            }
            case CHAR_OCTET_LENGTH: {
                return super.getData(15, offset, maxSize, data);
            }
            case ORDINAL_POSITION: {
                data.setInteger(this.m_paramsIndex);
                return false;
            }
            case IS_NULLABLE: {
                return super.getData(17, offset, maxSize, data);
            }
            case SPECIFIC_NAME: {
                return super.getData(18, offset, maxSize, data);
            }
            case IS_RESULT_SET: {
                data.setBoolean(false);
                return false;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
    }

    @Override
    public boolean moveToNextRow() {
        boolean result = false;
        try {
            if (this.m_paramsIndex == this.m_paramsnumbers - 1) {
                this.m_paramsIndex = 0;
                this.m_paramsnumbers = 1;
                this.m_paramsOids = new String[0];
                this.m_paramsNames = new String[0];
                result = super.moveToNextRow();
                DataWrapper wrapper = new DataWrapper();
                super.getData(19, 0L, -1L, wrapper);
                String proargTypesValue = wrapper.getVarChar();
                if (null != proargTypesValue && !proargTypesValue.equals("")) {
                    this.m_paramsOids = proargTypesValue.split(" ");
                    this.m_paramsnumbers = this.m_paramsOids.length + 1;
                    this.m_paramsIndex = 0;
                    wrapper = new DataWrapper();
                    super.getData(20, 0L, -1L, wrapper);
                    PGArray proargNames = (PGArray)wrapper.getArray();
                    if (null != proargNames) {
                        String proargNamesValue = proargNames.getStringRepresentation();
                        proargNamesValue = proargNamesValue.substring(1, proargNamesValue.length() - 1);
                        this.m_paramsNames = proargNamesValue.split(",");
                    }
                }
            } else {
                ++this.m_paramsIndex;
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

