/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnsIsNullResultSet
extends PGResultSet {
    Map<String, List<String>> isColumnNullableMap;

    public ColumnsIsNullResultSet(PGMessagingContext contexts, ILogger logger) throws ErrorException {
        super(contexts, logger);
        this.buildIsNullableMap();
    }

    @Override
    public ArrayList<ColumnMetadata> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.getSelectColumns(false);
    }

    public boolean isNullable(String tableOID, String columnIndex) throws ErrorException {
        List<String> colIndexes = this.isColumnNullableMap.get(tableOID);
        if (null != colIndexes) {
            for (String str : colIndexes) {
                if (!str.equals(columnIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildIsNullableMap() throws ErrorException {
        block11: {
            if (null == this.isColumnNullableMap) {
                this.isColumnNullableMap = new HashMap<String, List<String>>();
                block7: while (true) {
                    try {
                        while (this.moveToNextRow()) {
                            DataWrapper isNullableWrapper = new DataWrapper();
                            super.getData(2, 0L, 0L, isNullableWrapper);
                            try {
                                if (isNullableWrapper.getVarChar() != "false") continue block7;
                                DataWrapper tableOIDWrapper = new DataWrapper();
                                DataWrapper colIndexWrapper = new DataWrapper();
                                super.getData(0, 0L, 0L, tableOIDWrapper);
                                super.getData(1, 0L, 0L, colIndexWrapper);
                                String tableOID = tableOIDWrapper.getBigInt().toString();
                                List<String> colIndexes = this.isColumnNullableMap.get(tableOID);
                                if (null == colIndexes) {
                                    colIndexes = new ArrayList<String>();
                                    colIndexes.add(colIndexWrapper.getSmallInt().toString());
                                    this.isColumnNullableMap.put(tableOID, colIndexes);
                                    continue block7;
                                }
                                colIndexes.add(colIndexWrapper.getSmallInt().toString());
                                continue block7;
                            }
                            catch (IncorrectTypeException e) {
                                LogUtilities.logError("In the table pg_catalog.pg_attribute", this.m_log);
                                LogUtilities.logError(e, this.m_log);
                            }
                        }
                        break block11;
                    }
                    catch (ErrorException e) {
                        LogUtilities.logError("There was a problem building the null column map", this.m_log);
                        LogUtilities.logError(e, this.m_log);
                        throw e;
                    }
                }
                finally {
                    this.close();
                }
            }
        }
    }
}

