/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PGScalarFunctionParser {
    public static final String CHAR = "&f%n&char";
    public static final String UCASE = "&f%n&ucase";
    public static final String LCASE = "&f%n&lcase";
    public static final String IFNULL = "&f%n&ifnull";
    public static final String NOW = "&f%n&now";
    public static final String MONTHNAME = "&f%n&monthname";
    public static final String QUARTER = "&f%n&quarter";
    public static final String DAYOFMONTH = "&f%n&dayofmonth";
    public static final String DAYOFYEAR = "&f%n&dayofyear";
    public static final String DAYOFWEEK = "&f%n&dayofweek";
    public static final String DAYNAME = "&f%n&dayname";
    public static final String WEEK = "&f%n&week";
    public static final String DAY = "&f%n&day";
    public static final String HOUR = "&f%n&hour";
    public static final String MINUTE = "&f%n&minute";
    public static final String SECOND = "&f%n&second";
    public static final String RAND = "&f%n&rand";
    public static final String LOG10 = "&f%n&log10";
    public static final String USER = "&f%n&user";
    public static final String CURDATE = "&f%n&curdate";
    public static final String CURTIME = "&f%n&curtime";
    public static final String LOG = "&f%n&log";
    public static final String TRUNCATE = "&f%n&truncate";
    public static final String DATABASE = "&f%n&database";
    public static final String SPACE = "&f%n&space";
    public static final String MONTH = "&f%n&month";
    public static final String YEAR = "&f%n&year";
    private static final String LOCATE = "&f%n&locate";
    private static final String INSERT = "&f%n&insert";
    private static final char QUOTE_CHAR = '\'';
    private static final ArrayList<String> ORDERED_FUNCTION_LIST;
    private static final Map<String, String> SCALAR_FUNCTION_MAP;

    public static String scalarFunctionParse(String input) {
        String modifiedResult = "";
        try {
            modifiedResult = PGScalarFunctionParser.parseFunctionBracket(input);
            modifiedResult = PGScalarFunctionParser.primaryFunctionParser(modifiedResult);
            if (PGScalarFunctionParser.hasLocateOrInsertFunction(modifiedResult, LOCATE)) {
                modifiedResult = PGScalarFunctionParser.handleLocateOrInsertScalarFunction(modifiedResult, LOCATE);
            }
            if (PGScalarFunctionParser.hasLocateOrInsertFunction(modifiedResult, INSERT)) {
                modifiedResult = PGScalarFunctionParser.handleLocateOrInsertScalarFunction(modifiedResult, INSERT);
            }
            modifiedResult = modifiedResult.replaceAll("&f%n&", " ");
        }
        catch (Exception e) {
            return input;
        }
        return modifiedResult;
    }

    private static void splitToList(String inputQuery, ArrayList<String> queryVectors) {
        ArrayList<String> splitWithComma = new ArrayList<String>();
        int commaPosition = inputQuery.indexOf(44);
        int currentPosition = 0;
        while (-1 != commaPosition) {
            splitWithComma.add(inputQuery.substring(currentPosition, commaPosition + 1));
            currentPosition = commaPosition + 1;
            commaPosition = inputQuery.indexOf(44, currentPosition);
        }
        splitWithComma.add(inputQuery.substring(currentPosition));
        for (int listIndex = 0; listIndex < splitWithComma.size(); ++listIndex) {
            String intermediateResult = (String)splitWithComma.get(listIndex);
            ArrayList<String> results = new ArrayList<String>();
            int index = 0;
            int preindex = 0;
            while (-1 != (index = intermediateResult.indexOf(32, index))) {
                results.add(intermediateResult.substring(preindex, index));
                preindex = index++;
            }
            results.add(intermediateResult.substring(preindex));
            for (int i = 0; i < results.size(); ++i) {
                String result = (String)results.get(i);
                if (result.equals("") || result.equals(" ")) continue;
                queryVectors.add(result.toLowerCase().trim());
            }
        }
    }

    private static String FunctionReplace(String inputQuery, String functionName) {
        ArrayList<String> components = new ArrayList<String>();
        PGScalarFunctionParser.splitToList(inputQuery, components);
        boolean replaced = false;
        for (int partSelector = 0; partSelector < components.size(); ++partSelector) {
            String currentTarget = components.get(partSelector).toLowerCase();
            if (-1 == currentTarget.indexOf(functionName)) continue;
            if (currentTarget.trim().length() != functionName.length()) {
                if (partSelector - 1 < 0 || "table".equals(components.get(partSelector - 1))) continue;
                if (functionName == YEAR || functionName == QUARTER || functionName == MONTH || functionName == WEEK || functionName == DAY || functionName == HOUR || functionName == MINUTE || functionName == SECOND) {
                    components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length() + 1));
                } else if (functionName == USER || functionName == CURTIME || functionName == CURDATE) {
                    if (partSelector + 1 < components.size()) {
                        if (components.get(partSelector + 1).charAt(0) == ')') {
                            components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length() + 1));
                            components.set(partSelector + 1, components.get(partSelector + 1).substring(1));
                        } else {
                            components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length() + 2));
                        }
                    } else {
                        components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length() + 2));
                    }
                } else if (functionName == DAYOFMONTH || functionName == DAYOFYEAR || functionName == DAYOFWEEK || functionName == MONTHNAME || functionName == SPACE || functionName == DAYNAME) {
                    components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length() + 1));
                } else {
                    components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length()));
                }
                replaced = true;
                continue;
            }
            if (partSelector + 1 >= components.size() || components.get(partSelector + 1).charAt(0) != '(' || partSelector - 1 < 0 || components.get(partSelector - 1).equals("table")) continue;
            if (functionName == YEAR || functionName == QUARTER || functionName == MONTH || functionName == WEEK || functionName == DAY || functionName == HOUR || functionName == MINUTE || functionName == SECOND) {
                components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName));
                components.set(partSelector + 1, components.get(partSelector + 1).substring(1));
            } else if (functionName == USER || functionName == CURTIME || functionName == CURDATE) {
                if (components.get(partSelector + 1).startsWith("()")) {
                    components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName));
                    components.set(partSelector + 1, components.get(partSelector + 1).substring(2));
                } else if (partSelector + 2 < components.size()) {
                    String oneAway = components.get(partSelector + 1);
                    String twoAway = components.get(partSelector + 2);
                    if (oneAway.startsWith("(") && twoAway.startsWith(")")) {
                        components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName));
                        components.set(partSelector + 1, "");
                        components.set(partSelector + 2, twoAway.substring(1));
                    }
                }
            } else if (functionName == DAYOFMONTH || functionName == DAYOFYEAR || functionName == DAYOFWEEK || functionName == MONTHNAME || functionName == SPACE || functionName == DAYNAME) {
                components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName));
                components.set(partSelector + 1, components.get(partSelector + 1).substring(1));
            } else {
                components.set(partSelector, SCALAR_FUNCTION_MAP.get(functionName) + currentTarget.substring(functionName.length()));
            }
            replaced = true;
        }
        StringBuilder builder = new StringBuilder();
        if (replaced) {
            for (String a : components) {
                if (a.equals("") && a.equals(" ")) continue;
                builder.append(a);
                builder.append(" ");
            }
            return builder.toString();
        }
        return inputQuery;
    }

    private static int getIndexOfNextNot(String inputQuery, int begin, char character) {
        if (begin < 0 || inputQuery == null) {
            return -1;
        }
        for (int i = begin; i < inputQuery.length(); ++i) {
            if (inputQuery.charAt(i) == character) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasLocateOrInsertFunction(String inputQuery, String functionName) {
        String temp = inputQuery;
        temp = temp.toLowerCase();
        int quoteOne = -2;
        int quoteTwo = -2;
        quoteOne = temp.indexOf(39);
        if (-1 == quoteOne) {
            return false;
        }
        while (-1 != quoteOne) {
            String remaining = temp.substring(quoteOne + 1);
            quoteTwo = remaining.indexOf(39);
            String beforeQuote = temp.substring(0, quoteOne);
            String afterQuote = temp.substring(quoteOne + quoteTwo + 2);
            ArrayList<String> elementList = new ArrayList<String>();
            temp = afterQuote;
            quoteOne = temp.indexOf(39);
            PGScalarFunctionParser.splitToList(beforeQuote, elementList);
            for (int i = 0; i < elementList.size(); ++i) {
                String inputWithBracket = functionName + "(";
                if (!(elementList.get(i).equals(inputWithBracket) ? i - 1 >= 0 && elementList.get(i - 1) != "table" : elementList.get(i).equals(functionName) && i - 1 < elementList.size() && elementList.get(i + 1).equals("("))) continue;
                return true;
            }
        }
        return false;
    }

    private static String handleLocateOrInsertScalarFunction(String inputQuery, String functionName) {
        String replaceName;
        if (functionName == LOCATE) {
            replaceName = "strpos";
        } else if (functionName == INSERT) {
            replaceName = "substring";
        } else {
            return inputQuery;
        }
        String tempQuery = inputQuery;
        String tempLowerCaseQuery = tempQuery.toLowerCase();
        StringBuilder modifiedString = new StringBuilder();
        String afterBracket = "";
        if (-1 != tempLowerCaseQuery.indexOf(functionName)) {
            int functionNamePosition;
            while (-1 != (functionNamePosition = tempLowerCaseQuery.indexOf(functionName))) {
                int pos;
                int startBracket = PGScalarFunctionParser.getIndexOfNextNot(tempQuery, functionNamePosition + functionName.length(), ' ');
                String afterStartBracket = tempQuery.substring(startBracket);
                if ('(' != afterStartBracket.charAt(0)) {
                    return inputQuery;
                }
                int endBracket = tempQuery.indexOf(41);
                String betweenBracket = tempQuery.substring(startBracket + 1, endBracket);
                String beforeBracket = tempQuery.substring(0, functionNamePosition) + replaceName + "(";
                afterBracket = tempQuery.substring(endBracket);
                int prev = 0;
                ArrayList<String> wordList = new ArrayList<String>();
                while (-1 != (pos = betweenBracket.indexOf(44, prev))) {
                    if (pos > prev) {
                        wordList.add(betweenBracket.substring(prev, pos));
                    }
                    prev = pos + 1;
                }
                if (prev < betweenBracket.length()) {
                    wordList.add(betweenBracket.substring(prev));
                }
                if (LOCATE == functionName) {
                    if (wordList.size() == 2) {
                        modifiedString.append(beforeBracket);
                        modifiedString.append((String)wordList.get(1));
                        modifiedString.append("," + (String)wordList.get(0));
                    }
                    if (3 == wordList.size()) {
                        modifiedString.append(beforeBracket);
                        modifiedString.append("substring(");
                        modifiedString.append((String)wordList.get(1));
                        modifiedString.append(" from ");
                        modifiedString.append((String)wordList.get(2));
                        modifiedString.append("),");
                        modifiedString.append((String)wordList.get(0));
                        modifiedString.append(") +");
                        modifiedString.append((String)wordList.get(2));
                        modifiedString.append("-1");
                        afterBracket = afterBracket.substring(1);
                    }
                } else if (INSERT == functionName) {
                    modifiedString.append(beforeBracket);
                    modifiedString.append((String)wordList.get(0));
                    modifiedString.append(" from ");
                    modifiedString.append((String)wordList.get(2));
                    modifiedString.append(" for ");
                    modifiedString.append((String)wordList.get(1));
                    modifiedString.append("-");
                    modifiedString.append((String)wordList.get(2));
                    modifiedString.append(") || ");
                    modifiedString.append((String)wordList.get(3));
                    modifiedString.append(" || substring ( ");
                    modifiedString.append((String)wordList.get(0));
                    modifiedString.append(" from ");
                    modifiedString.append((String)wordList.get(1));
                    modifiedString.append("+");
                    modifiedString.append((String)wordList.get(2));
                }
                tempQuery = afterBracket;
                tempLowerCaseQuery = tempQuery.toLowerCase();
            }
        }
        modifiedString.append(afterBracket);
        if (0 != modifiedString.length()) {
            return modifiedString.toString();
        }
        return inputQuery;
    }

    private static String searchForFunctionNameAndReplace(String inputQuery) {
        String modifiedInput = inputQuery;
        String lowerCaseCopy = modifiedInput.toLowerCase();
        for (String element : ORDERED_FUNCTION_LIST) {
            int indexOfExpectedBracket;
            int indexOfElement = lowerCaseCopy.indexOf(element);
            if (-1 == indexOfElement || modifiedInput.charAt(indexOfExpectedBracket = PGScalarFunctionParser.getIndexOfNextNot(modifiedInput, indexOfElement + element.length(), ' ')) != '(') continue;
            modifiedInput = PGScalarFunctionParser.FunctionReplace(modifiedInput, element);
            lowerCaseCopy = modifiedInput.toLowerCase();
        }
        return modifiedInput;
    }

    private static String primaryFunctionParser(String inputQuery) {
        StringBuilder parsed = new StringBuilder(inputQuery.length());
        boolean hasToChar = false;
        boolean hasExtractDow = false;
        boolean isDayOfWeek = false;
        int start = 0;
        while (inputQuery.length() > start) {
            int nextQuote = inputQuery.indexOf(39, start + 1);
            if (0 > nextQuote) {
                nextQuote = inputQuery.length();
            }
            String beforeQuote = inputQuery.substring(start, nextQuote);
            String replacedBeforeQuote = PGScalarFunctionParser.searchForFunctionNameAndReplace(beforeQuote);
            if (isDayOfWeek) {
                int indexOfClosingParen = replacedBeforeQuote.indexOf(41);
                if (0 <= indexOfClosingParen) {
                    parsed.append(replacedBeforeQuote, 0, indexOfClosingParen);
                    parsed.append(")+1");
                    parsed.append(replacedBeforeQuote, indexOfClosingParen + 1, replacedBeforeQuote.length());
                } else {
                    parsed.append(replacedBeforeQuote);
                }
                isDayOfWeek = false;
            } else {
                parsed.append(replacedBeforeQuote);
            }
            int matchingQuote = inputQuery.indexOf(39, nextQuote + 1);
            int openingBrace = inputQuery.indexOf(40, nextQuote + 1);
            if (0 > matchingQuote) {
                matchingQuote = inputQuery.length() - 1;
            }
            if (0 < openingBrace && 0 < matchingQuote && openingBrace < matchingQuote) {
                matchingQuote = 0;
            }
            if (0 != matchingQuote) {
                parsed.append(inputQuery, nextQuote, matchingQuote + 1);
            }
            beforeQuote = beforeQuote.toLowerCase(Locale.ENGLISH);
            if (replacedBeforeQuote.contains("to_char(")) {
                hasToChar = true;
            } else if (replacedBeforeQuote.contains("extract(dow")) {
                hasExtractDow = true;
            }
            if (hasToChar) {
                if (beforeQuote.contains("dayname")) {
                    parsed.append(", 'Day'");
                } else if (beforeQuote.contains("monthname")) {
                    parsed.append(", 'Month'");
                }
            }
            if (hasExtractDow && beforeQuote.contains("dayofweek")) {
                isDayOfWeek = true;
            }
            if (0 < matchingQuote) {
                start = matchingQuote + 1;
                continue;
            }
            start = nextQuote;
        }
        return parsed.toString();
    }

    private static String parseFunctionBracket(String inputQuery) {
        int inBracketLevel = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean beforeBracket = false;
        StringBuilder result = new StringBuilder(inputQuery.length());
        block11: for (int inputPosition = 0; inputPosition < inputQuery.length(); ++inputPosition) {
            char c = inputQuery.charAt(inputPosition);
            switch (c) {
                case '{': {
                    if (!inSingleQuote && !inDoubleQuote) {
                        ++inBracketLevel;
                        beforeBracket = true;
                        continue block11;
                    }
                    result.append(c);
                    continue block11;
                }
                case '}': {
                    if (!inSingleQuote && !inDoubleQuote && 0 < inBracketLevel) {
                        --inBracketLevel;
                    } else {
                        result.append(c);
                    }
                    beforeBracket = false;
                    continue block11;
                }
                case '\"': {
                    int indexOfQuote = inputQuery.indexOf(34, inputPosition + 1);
                    int indexOfNextOpenBrace = inputQuery.indexOf(40, inputPosition + 1);
                    inDoubleQuote = !inDoubleQuote && !inSingleQuote ? 0 < indexOfNextOpenBrace && 0 < indexOfQuote && indexOfNextOpenBrace > indexOfQuote || 0 > indexOfNextOpenBrace && 0 < indexOfQuote : false;
                    result.append(c);
                    beforeBracket = false;
                    continue block11;
                }
                case '\'': {
                    int indexOfNextQuote = inputQuery.indexOf(39, inputPosition + 1);
                    int indexOfNextOpenBrace = inputQuery.indexOf(40, inputPosition + 1);
                    inSingleQuote = !inDoubleQuote && !inSingleQuote ? 0 < indexOfNextOpenBrace && 0 < indexOfNextQuote && indexOfNextOpenBrace > indexOfNextQuote || 0 > indexOfNextOpenBrace && 0 < indexOfNextQuote : false;
                    result.append(c);
                    beforeBracket = false;
                    continue block11;
                }
                case 'f': {
                    if (!inSingleQuote && !inDoubleQuote && inBracketLevel > 0 && beforeBracket) {
                        if (inputQuery.charAt(inputPosition + 1) == 'n') {
                            result.append("&f%n&");
                            ++inputPosition;
                            while (inputQuery.charAt(inputPosition + 1) == ' ' && ++inputPosition + 2 < inputQuery.length()) {
                            }
                        }
                    } else {
                        result.append(c);
                    }
                    beforeBracket = false;
                    continue block11;
                }
                case 't': {
                    if (!inSingleQuote && !inDoubleQuote && inBracketLevel > 0 && beforeBracket) {
                        if (inputQuery.charAt(inputPosition + 1) == 's') {
                            result.append(" timestamp ");
                            ++inputPosition;
                        } else {
                            result.append(" time ");
                        }
                    } else {
                        result.append(c);
                    }
                    beforeBracket = false;
                    continue block11;
                }
                case 'd': {
                    if (!inSingleQuote && !inDoubleQuote && inBracketLevel > 0 && beforeBracket) {
                        result.append(" date ");
                    } else {
                        result.append(c);
                    }
                    beforeBracket = false;
                    continue block11;
                }
                case ' ': {
                    result.append(c);
                    continue block11;
                }
                case '$': {
                    if (!inSingleQuote && !inDoubleQuote) {
                        if (inputPosition + 1 < inputQuery.length() && inputQuery.charAt(inputPosition + 1) == '$') {
                            int closingSequence = inputQuery.indexOf("$$", inputPosition + 2);
                            if (closingSequence < 0) {
                                result.append("$$");
                                ++inputPosition;
                                continue block11;
                            }
                            result.append(inputQuery.substring(inputPosition, closingSequence + 2));
                            inputPosition = closingSequence + 1;
                            continue block11;
                        }
                        result.append(c);
                        continue block11;
                    }
                    result.append(c);
                    continue block11;
                }
                default: {
                    beforeBracket = false;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    static {
        SCALAR_FUNCTION_MAP = new HashMap<String, String>();
        ORDERED_FUNCTION_LIST = new ArrayList();
        SCALAR_FUNCTION_MAP.put(UCASE, "upper");
        SCALAR_FUNCTION_MAP.put(LCASE, "lower");
        SCALAR_FUNCTION_MAP.put(IFNULL, "coalesce");
        SCALAR_FUNCTION_MAP.put(NOW, "getdate");
        SCALAR_FUNCTION_MAP.put(YEAR, "extract ( year from ");
        SCALAR_FUNCTION_MAP.put(MONTHNAME, "to_char( ");
        SCALAR_FUNCTION_MAP.put(MONTH, "extract ( month from ");
        SCALAR_FUNCTION_MAP.put(QUARTER, "extract ( quarter from ");
        SCALAR_FUNCTION_MAP.put(DAYOFMONTH, "extract(day from ");
        SCALAR_FUNCTION_MAP.put(DAYOFYEAR, "extract(doy from ");
        SCALAR_FUNCTION_MAP.put(DAYOFWEEK, "extract(dow from ");
        SCALAR_FUNCTION_MAP.put(DAYNAME, "to_char( ");
        SCALAR_FUNCTION_MAP.put(WEEK, "extract ( week from ");
        SCALAR_FUNCTION_MAP.put(DAY, "extract ( day from ");
        SCALAR_FUNCTION_MAP.put(HOUR, "extract ( hour from ");
        SCALAR_FUNCTION_MAP.put(MINUTE, "extract ( minute from ");
        SCALAR_FUNCTION_MAP.put(SECOND, "extract ( second from ");
        SCALAR_FUNCTION_MAP.put(RAND, "random");
        SCALAR_FUNCTION_MAP.put(LOG10, "log");
        SCALAR_FUNCTION_MAP.put(USER, "user");
        SCALAR_FUNCTION_MAP.put(CURDATE, "current_date");
        SCALAR_FUNCTION_MAP.put(CURTIME, "current_time");
        SCALAR_FUNCTION_MAP.put(LOG, "ln");
        SCALAR_FUNCTION_MAP.put(TRUNCATE, "trunc");
        SCALAR_FUNCTION_MAP.put(DATABASE, "current_database");
        SCALAR_FUNCTION_MAP.put(CHAR, "chr");
        SCALAR_FUNCTION_MAP.put(SPACE, "repeat(' ',");
        ORDERED_FUNCTION_LIST.add(CHAR);
        ORDERED_FUNCTION_LIST.add(UCASE);
        ORDERED_FUNCTION_LIST.add(LCASE);
        ORDERED_FUNCTION_LIST.add(IFNULL);
        ORDERED_FUNCTION_LIST.add(NOW);
        ORDERED_FUNCTION_LIST.add(MONTHNAME);
        ORDERED_FUNCTION_LIST.add(QUARTER);
        ORDERED_FUNCTION_LIST.add(DAYOFMONTH);
        ORDERED_FUNCTION_LIST.add(DAYOFYEAR);
        ORDERED_FUNCTION_LIST.add(DAYOFWEEK);
        ORDERED_FUNCTION_LIST.add(DAYNAME);
        ORDERED_FUNCTION_LIST.add(WEEK);
        ORDERED_FUNCTION_LIST.add(DAY);
        ORDERED_FUNCTION_LIST.add(HOUR);
        ORDERED_FUNCTION_LIST.add(MINUTE);
        ORDERED_FUNCTION_LIST.add(SECOND);
        ORDERED_FUNCTION_LIST.add(RAND);
        ORDERED_FUNCTION_LIST.add(LOG10);
        ORDERED_FUNCTION_LIST.add(USER);
        ORDERED_FUNCTION_LIST.add(CURDATE);
        ORDERED_FUNCTION_LIST.add(CURTIME);
        ORDERED_FUNCTION_LIST.add(LOG);
        ORDERED_FUNCTION_LIST.add(TRUNCATE);
        ORDERED_FUNCTION_LIST.add(DATABASE);
        ORDERED_FUNCTION_LIST.add(SPACE);
        ORDERED_FUNCTION_LIST.add(MONTH);
        ORDERED_FUNCTION_LIST.add(YEAR);
    }
}

