/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.core.impl.DSIStatement;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.interfaces.IDataEngine;
import com.amazon.dsi.exceptions.BadAttrValException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGDataEngine;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class PGJDBCStatement
extends DSIStatement {
    private ExpectedResult m_expectedResult;
    private List<PGMessagingContext> m_messagingContexts;
    private PGClient m_client;
    private int m_socketTimeoutMS;
    private boolean m_isCallableStatement;
    private boolean m_hasReturnQuestionMark = false;
    private int[] m_parameterOID;

    public PGJDBCStatement(PGJDBCConnection connection, PGClient client, int socketTimeoutMS) throws ErrorException {
        super(connection);
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        this.m_client = client;
        this.m_socketTimeoutMS = socketTimeoutMS;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        try {
            if (null != this.m_messagingContexts) {
                for (PGMessagingContext messagingContext : this.m_messagingContexts) {
                    messagingContext.close();
                    if (null == messagingContext.m_serverStatementName) continue;
                    this.m_client.closeServerNamedStatement(messagingContext, null);
                    messagingContext.m_serverStatementName = null;
                }
            }
        }
        catch (ErrorException e) {
            LogUtilities.logError(e, this.getLog());
        }
    }

    @Override
    public IDataEngine createDataEngine() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return new PGDataEngine(this, ((PGJDBCConnection)this.getParentConnection()).getPostgresqlClient(), ((PGJDBCConnection)this.getParentConnection()).getConnectionSettings(), this.getLog(), this.m_socketTimeoutMS);
    }

    public void setExpectedResult(ExpectedResult expectedResult) {
        this.m_expectedResult = expectedResult;
    }

    public ExpectedResult getExpectedResult() {
        return this.m_expectedResult;
    }

    public void pushContexts(List<PGMessagingContext> contexts) {
        this.m_messagingContexts = contexts;
    }

    public boolean isCallableStatement() {
        return this.m_isCallableStatement;
    }

    public boolean hasReturnQuestionMark() {
        return this.m_hasReturnQuestionMark;
    }

    public int[] getParameterOID() {
        return this.m_parameterOID;
    }

    public Lock getTransactionLock() {
        return ((PGJDBCConnection)this.getParentConnection()).getTransactionLock();
    }

    public void notifyTransaction(PGCoreUtils.TransactionVerb verb) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{verb});
        if (null == verb || PGCoreUtils.TransactionVerb.NONE == verb) {
            return;
        }
        PGJDBCConnection conn = (PGJDBCConnection)this.getParentConnection();
        switch (verb) {
            case BEGIN: {
                conn.getTransactionStateListener().notifyBeginTransaction();
                break;
            }
            case COMMIT: {
                conn.getTransactionStateListener().notifyCommit();
                break;
            }
            case ROLLBACK: {
                conn.getTransactionStateListener().notifyRollback();
                break;
            }
            default: {
                throw new IllegalArgumentException("" + (Object)((Object)verb));
            }
        }
    }

    public void setIsCallableStatement(boolean m_isCallableStatement) {
        this.m_isCallableStatement = m_isCallableStatement;
    }

    public void sethasReturnQuestionMark(boolean m_hasReturnQuestionMark) {
        this.m_hasReturnQuestionMark = m_hasReturnQuestionMark;
    }

    public void setparameterOID(int[] m_parameterOID) {
        this.m_parameterOID = m_parameterOID;
    }

    private void loadProperties() throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        this.setProperty(102, new Variant(3, new Long(Integer.MAX_VALUE)));
        this.setProperty(103, new Variant(3, new Long(0L)));
    }
}

