/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIConnection;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.interfaces.ITransactionStateListener;
import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.ConnSettingResponseMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.exceptions.BadAttrValException;
import com.amazon.dsi.exceptions.BadAuthException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.common.CommonCoreUtils;
import com.amazon.jdbc.common.ProductInfoHandler;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.core.BrandingPreferences;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.PGLogger;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PGJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private PGClient m_postgresqlClient;
    protected ILogger m_log;
    protected IPGLogger m_driverlog;
    private PGJDBCSettings m_settings;
    private ProductInfoHandler m_productInfoHandler;
    private final Lock m_txLock = new ReentrantLock();
    private static final String POSTGRESQL_LOG_NAME_PREFIX = "RedshiftJDBC_connection_";
    private static final int MIN_LOGIN_TIMEOUT = 0;
    private static final int DEFAULT_SOCKET_TIMEOUT = 0;
    private static final int MIN_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final int MAX_UNKNOWN_LENGTH = Integer.MAX_VALUE;

    public PGJDBCConnection(IEnvironment environment) throws ErrorException {
        super(environment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String productVersion = PGJDBCDriver.DRIVER_MAJOR_VERSION + "." + PGJDBCDriver.DRIVER_MINOR_VERSION;
        this.m_productInfoHandler = new ProductInfoHandler("SimbaAmazonRedshiftJDBCDriver.lic", "Simba Amazon Redshift JDBC Driver", productVersion, PGJDBCDriver.class);
        try {
            this.setProperty(136, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(137, new Variant(7, 11L));
            this.setProperty(1009, new Variant(6, 1));
        }
        catch (NumericOverflowException ex) {
            LogUtilities.logError(ex, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), ex);
        }
        catch (IncorrectTypeException ex) {
            LogUtilities.logError(ex, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), ex);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    public PGClient getPostgresqlClient() {
        return this.m_postgresqlClient;
    }

    public PGJDBCSettings getConnectionSettings() {
        return this.m_settings;
    }

    @Override
    public void connect(ConnSettingRequestMap requestMap) throws ErrorException {
        Variant unknownLength;
        Variant loginTimeOut;
        Variant socketTimeout;
        Variant filterLevel;
        CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), requestMap, String.valueOf(PGJDBCDriver.DRIVER_MAJOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_MINOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_HOT_FIX_VERSION), String.valueOf(PGJDBCDriver.DRIVER_BUILD_NUMBER));
        this.m_productInfoHandler.validateLicense();
        this.m_settings = new PGJDBCSettings();
        this.m_settings.m_host = this.getRequiredSetting("Host", requestMap).getString();
        Variant portVariant = this.getRequiredSetting("Port", requestMap);
        this.m_settings.m_Schema = this.getRequiredSetting("ConnSchema", requestMap).getString();
        this.m_settings.m_username = this.getRequiredSetting("UID", requestMap).getString();
        this.m_settings.m_password = this.getRequiredSetting("PWD", requestMap).getString();
        this.m_settings.m_loginTimeoutMS = 0;
        this.m_settings.m_rowsFetchedPerBlock = 10000;
        this.m_settings.m_authMech = BrandingPreferences.defaultSslOption;
        this.m_settings.m_newTCPConnectionKeepAliveMinutes = 0;
        this.m_settings.m_nRowMode = 0;
        this.m_settings.m_socketTimeoutMS = 0;
        try {
            this.m_settings.m_port = portVariant.getInt();
        }
        catch (Exception ex) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), ex.getMessage());
            err.initCause(ex);
            throw err;
        }
        Variant nRowMode = this.getOptionalSetting("BlockingRowsMode", requestMap);
        if (null != nRowMode) {
            try {
                this.m_settings.m_nRowMode = nRowMode.getInt();
                if (this.m_settings.m_nRowMode < 0) {
                    this.m_settings.m_nRowMode = 0;
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
                } else if (0 < this.m_settings.m_nRowMode && this.m_settings.m_nRowMode < 5) {
                    this.m_settings.m_nRowMode = 5;
                    String[] msgParams = new String[2];
                    StringBuilder sb = new StringBuilder();
                    sb.append("The given value is too small. Falling back to the default value ");
                    msgParams[0] = "BlockingRowsMode";
                    msgParams[1] = sb.toString();
                    Warning warn = new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), msgParams);
                    this.getWarningListener().postWarning(warn);
                }
            }
            catch (Exception ex) {
                this.m_settings.m_nRowMode = 0;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
            }
        }
        this.m_settings.m_filterLevel = null != (filterLevel = this.getOptionalSetting("FilterLevel", requestMap)) ? filterLevel.getString() : "NOTICE";
        Boolean isTcpKeepAliveOn = null;
        Variant tcpKeepAlive = this.getOptionalSetting("tcpKeepAlive", requestMap);
        if (null != tcpKeepAlive) {
            if (0 == tcpKeepAlive.getString().length() || Boolean.parseBoolean(tcpKeepAlive.getString())) {
                isTcpKeepAliveOn = true;
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
            } else {
                isTcpKeepAliveOn = false;
            }
        } else {
            isTcpKeepAliveOn = true;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
        }
        tcpKeepAlive = this.getOptionalSetting("TCPKeepAliveMinutes", requestMap);
        if (null != tcpKeepAlive) {
            try {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = tcpKeepAlive.getInt();
            }
            catch (Exception ex) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
            if (null != isTcpKeepAliveOn && (isTcpKeepAliveOn.booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes == 0 || !isTcpKeepAliveOn.booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes != 0)) {
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), new String[]{"tcpKeepAlive", "TCPKeepAliveMinutes"});
                LogUtilities.logError(err, this.m_log);
                throw err;
            }
            if (this.m_settings.m_newTCPConnectionKeepAliveMinutes < 0) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
        }
        if (null != (socketTimeout = this.getOptionalSetting("socketTimeout", requestMap))) {
            try {
                int socketTimeoutValue = socketTimeout.getInt();
                if (socketTimeoutValue > 0) {
                    this.m_settings.m_socketTimeoutMS = socketTimeoutValue * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
                }
            }
            catch (Exception e) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
            }
        }
        if (DriverManager.getLoginTimeout() > 0) {
            this.m_settings.m_loginTimeoutMS = DriverManager.getLoginTimeout() * 1000;
        }
        if (null != (loginTimeOut = this.getOptionalSetting("loginTimeout", requestMap))) {
            try {
                int tempTimeOutValue = loginTimeOut.getInt();
                if (tempTimeOutValue > 0) {
                    this.m_settings.m_loginTimeoutMS = tempTimeOutValue * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
                }
            }
            catch (Exception e) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
            }
        }
        if (null != (unknownLength = this.getOptionalSetting("unknownLength", requestMap))) {
            boolean isInvalidValue = false;
            try {
                int tempUnknownLengthValue = unknownLength.getInt();
                if (tempUnknownLengthValue >= Integer.MIN_VALUE && tempUnknownLengthValue <= Integer.MAX_VALUE) {
                    this.m_settings.m_unknownLength = tempUnknownLengthValue;
                } else {
                    isInvalidValue = true;
                }
            }
            catch (Exception e) {
                LogUtilities.logDebug(e, this.m_log);
                isInvalidValue = true;
            }
            if (isInvalidValue) {
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE_TYPE_OR_RANGE.name(), new String[]{"unknownLength", unknownLength.getString(), String.valueOf(Integer.MIN_VALUE), String.valueOf(Integer.MAX_VALUE)});
                LogUtilities.logError(err, this.m_log);
                throw err;
            }
        }
        this.setAuthMech(requestMap);
        this.m_postgresqlClient = new PGClient(this.m_settings, this.getDriverConnectionLog(), this.getWarningListener());
        this.incrementConnectionID();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    public IStatement prepareStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(POSTGRESQL_LOG_NAME_PREFIX + Integer.toString(s_connectionID));
            this.m_log.setLocale(this.getLocale());
        }
        return this.m_log;
    }

    public IPGLogger getDriverConnectionLog() {
        if (null == this.m_driverlog) {
            this.m_driverlog = new PGLogger(POSTGRESQL_LOG_NAME_PREFIX, s_connectionID);
            this.m_driverlog.setLocale(this.getLocale());
        }
        return this.m_driverlog;
    }

    @Override
    public String toNativeSQL(String sql) {
        String nativeSQL;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), sql);
        try {
            nativeSQL = PGCoreUtils.parseStoredProcedure(sql, this);
        }
        catch (NullPointerException ex) {
            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_PROCEDURE_CALL_FORMAT_ERROR.name()));
            return sql;
        }
        return nativeSQL;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap requestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), requestMap);
        ConnSettingResponseMap responseMap = new ConnSettingResponseMap();
        for (String currentKey : PGJDBCPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(currentKey, requestMap, responseMap);
        }
        for (String currentKey : PGJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(currentKey, requestMap, responseMap);
        }
        return responseMap;
    }

    @Override
    public void setProperty(int propKey, Variant propValue) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        switch (propKey) {
            case 26: {
                try {
                    if (1L == propValue.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read uncommitted'", null);
                        break;
                    }
                    if (2L == propValue.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read committed'", null);
                        break;
                    }
                    if (4L == propValue.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='repeatable read'", null);
                        break;
                    }
                    if (8L != propValue.getLong()) break;
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='serializable'", null);
                    break;
                }
                catch (NumericOverflowException ex) {
                    LogUtilities.logError(ex, this.m_log);
                    ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), ex.getMessage());
                    err.initCause(ex);
                    break;
                }
                catch (IncorrectTypeException ex) {
                    LogUtilities.logError(ex, this.m_log);
                    ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), ex.getMessage());
                    err.initCause(ex);
                }
            }
        }
        super.setProperty(propKey, propValue);
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("BEGIN;", null);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("COMMIT;", null);
    }

    @Override
    public void createSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        this.m_postgresqlClient.directExecuteImmediately("SAVEPOINT JDBC_SYNTH_SP_" + name + ";", null);
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        super.registerWarningListener(listener);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.registerWarningListener(listener);
        }
    }

    @Override
    public void releaseSavepoint(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        this.m_postgresqlClient.directExecuteImmediately("RELEASE SAVEPOINT JDBC_SYNTH_SP_" + name + ";", null);
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK;", null);
    }

    @Override
    public void rollback(String name) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), name);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK TO SAVEPOINT JDBC_SYNTH_SP_" + name + ";", null);
    }

    final Lock getTransactionLock() {
        return this.m_txLock;
    }

    final ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    private void setAuthMech(ConnSettingRequestMap requestMap) throws ErrorException {
        boolean sslExplicitlyEnabled = false;
        Variant ssl = this.getOptionalSetting("ssl", requestMap);
        if (null != ssl) {
            sslExplicitlyEnabled = true;
            if (Boolean.parseBoolean(ssl.getString()) || ssl.getString().equals("")) {
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            }
        }
        Variant nAuthMech = this.getOptionalSetting("AuthMech", requestMap);
        AuthMech explicitAuthMech = null;
        if (null != nAuthMech) {
            try {
                explicitAuthMech = AuthMech.valueOf(nAuthMech.getString().toUpperCase().trim());
            }
            catch (IllegalArgumentException e) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < AuthMech.values().length; ++i) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append((Object)AuthMech.values()[i]);
                }
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"AuthMech", str.toString()});
                LogUtilities.logError(err, this.m_log);
                throw err;
            }
        }
        boolean authMechSetExplicitly = false;
        if (null != explicitAuthMech) {
            authMechSetExplicitly = true;
        }
        if (sslExplicitlyEnabled && authMechSetExplicitly && null != this.m_settings.m_authMech && this.m_settings.m_authMech != explicitAuthMech) {
            this.throwConflictingPropertyException(new String[]{"AuthMech", "ssl"});
        }
        if (authMechSetExplicitly) {
            this.m_settings.m_authMech = explicitAuthMech;
        }
        Variant sslFactory = this.getOptionalSetting("sslfactory", requestMap);
        boolean sslFactorySet = false;
        if (null != sslFactory && this.isNonValidationFactory(sslFactory.getString())) {
            if (authMechSetExplicitly && this.m_settings.m_authMech != AuthMech.REQUIRE) {
                this.throwConflictingPropertyException(new String[]{"AuthMech", "sslfactory"});
            }
            sslFactorySet = true;
            this.m_settings.m_authMech = AuthMech.REQUIRE;
        }
        Variant sslMode = this.getOptionalSetting("sslmode", requestMap);
        boolean sslModeSet = false;
        if (null != sslMode) {
            sslModeSet = true;
        }
        if (sslModeSet) {
            if (authMechSetExplicitly) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "AuthMech"});
            }
            if (!sslExplicitlyEnabled) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "ssl"});
            }
            if (sslFactorySet) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "sslfactory"});
            }
            if (sslMode.getString().equals("verify-full")) {
                this.m_settings.m_authMech = AuthMech.VERIFY_FULL;
            } else if (sslMode.getString().equals("verify-ca")) {
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else {
                StringBuilder str = new StringBuilder();
                str.append("verify-full");
                str.append(", ");
                str.append("verify-ca");
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"sslmode", str.toString()});
                LogUtilities.logError(err, this.m_log);
                throw err;
            }
        }
    }

    private void throwConflictingPropertyException(String[] args) throws ErrorException {
        ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), args);
        LogUtilities.logError(err, this.m_log);
        throw err;
    }

    private boolean isNonValidationFactory(String factory) {
        boolean result = false;
        if (factory.equals(PGCoreUtils.NON_VALIDATING_SSL_FACTORY) || factory.equals(NonValidatingFactory.class.getName())) {
            result = true;
        }
        return result;
    }

    private Warning buildWarningForIncorrectIntPropertyValue(String propertyName) {
        String[] msgParams = new String[2];
        StringBuilder sb = new StringBuilder();
        sb.append("Numbers between 0 and 2147483647");
        sb.append(". The value is either negative, too large or not a number. ");
        sb.append("Falling back to the default value");
        msgParams[0] = propertyName;
        msgParams[1] = sb.toString();
        return new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), msgParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementConnectionID() {
        PGJDBCConnection pGJDBCConnection = this;
        synchronized (pGJDBCConnection) {
            ++s_connectionID;
        }
    }
}

