/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.support.exceptions.ErrorException;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PGArrayParser {
    static final byte UTF8LEFTCURLYBRACE = 123;
    static final byte UTF8RIGHTCURLYBRACE = 125;
    static final byte UTF8DOUBLEQUOTE = 34;
    static final byte UTF8COMMA = 44;
    static final byte UTF8BACKSLASH = 92;

    private static List<?> parse(byte[] content, int baseType, int beginIndex, int length) throws ErrorException {
        ArrayList<Object> result = new ArrayList<Object>();
        boolean inQuote = false;
        boolean isEscape = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        block20: for (int i = beginIndex; i < beginIndex + length; ++i) {
            switch (content[i]) {
                case 92: {
                    isEscape = true;
                    baos.write(content[i]);
                    continue block20;
                }
                case 123: {
                    if (!inQuote) continue block20;
                    baos.write(content[i]);
                    continue block20;
                }
                case 34: {
                    if (inQuote && isEscape) {
                        baos.write(content[i]);
                        continue block20;
                    }
                    inQuote = !inQuote;
                    continue block20;
                }
                case 44: 
                case 125: {
                    if (inQuote) {
                        baos.write(content[i]);
                        continue block20;
                    }
                    byte[] bytes = baos.toByteArray();
                    if (0 == bytes.length) continue block20;
                    switch (baseType) {
                        case 4: {
                            result.add(PGDataTypeUtilities.toInteger(bytes, 0, bytes.length));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 5: {
                            result.add(PGDataTypeUtilities.toShort(bytes, 0, bytes.length));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -5: {
                            result.add(PGDataTypeUtilities.toLong(bytes, 0, bytes.length));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 7: {
                            result.add(Float.valueOf(PGDataTypeUtilities.toFloat(bytes, 0, bytes.length)));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 8: {
                            result.add(PGDataTypeUtilities.toDouble(bytes, 0, bytes.length));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 91: {
                            int[] dateValueList = PGDataTypeUtilities.toDate(bytes, 0, bytes.length);
                            result.add(PGDataTypeUtilities.toSqlDate(dateValueList));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 92: {
                            int[] timeValueList = PGDataTypeUtilities.toTime(bytes, 0, bytes.length);
                            result.add(PGArrayParser.toSqlTime(timeValueList[0], timeValueList[1], timeValueList[2], timeValueList[3]));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 93: {
                            String timestampString = PGDataTypeUtilities.toUTF8String(baos.toByteArray());
                            timestampString = timestampString.toLowerCase();
                            if (timestampString.contains("infinity")) {
                                if (timestampString.startsWith("-")) {
                                    result.add(new PGTimestamp(Long.MIN_VALUE));
                                } else {
                                    result.add(new PGTimestamp(Long.MAX_VALUE));
                                }
                            } else {
                                int[] timestampValueList = PGDataTypeUtilities.toTimestamp(bytes, 0, bytes.length);
                                result.add(PGArrayParser.toSqlTimestamp(timestampValueList[0], timestampValueList[1] - 1, timestampValueList[2], timestampValueList[3], timestampValueList[4], timestampValueList[5], timestampValueList[6]));
                            }
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            result.add(PGDataTypeUtilities.toUTF8String(baos.toByteArray()));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -7: 
                        case 16: {
                            result.add(PGDataTypeUtilities.toBit(bytes, 0));
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal value = PGDataTypeUtilities.toBigDecimal(bytes, 0, bytes.length);
                            result.add(value);
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            result.add(baos.toByteArray());
                            baos = new ByteArrayOutputStream();
                            continue block20;
                        }
                    }
                    result.add(PGDataTypeUtilities.toUTF8String(baos.toByteArray()));
                    baos = new ByteArrayOutputStream();
                    continue block20;
                }
                default: {
                    isEscape = false;
                    baos.write(content[i]);
                }
            }
        }
        return result;
    }

    public static Object parseArray(byte[] content, int baseType, int beginIndex, int length) throws ErrorException {
        List<?> arrayList = PGArrayParser.parse(content, baseType, beginIndex, length);
        int numElementsFound = arrayList.size();
        Object[] result = PGArrayParser.createTypedArray(baseType, numElementsFound);
        for (int i = 0; i < numElementsFound; ++i) {
            result[i] = arrayList.get(i);
        }
        return result;
    }

    private static Object[] createTypedArray(int baseType, int length) {
        Object[] result = null;
        switch (baseType) {
            case 4: {
                result = new Integer[length];
                break;
            }
            case 5: {
                result = new Short[length];
                break;
            }
            case -5: {
                result = new Long[length];
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                result = new String[length];
                break;
            }
            case 7: {
                result = new Float[length];
                break;
            }
            case 6: 
            case 8: {
                result = new Double[length];
                break;
            }
            case -7: 
            case 16: {
                result = new Boolean[length];
                break;
            }
            case 91: {
                result = new Date[length];
                break;
            }
            case 92: {
                result = new Time[length];
                break;
            }
            case 93: {
                result = new Timestamp[length];
                break;
            }
            case 2: 
            case 3: {
                result = new BigDecimal[length];
                break;
            }
            case -6: {
                result = new Byte[length];
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = (Object[])new byte[length][];
                break;
            }
            default: {
                result = new Object[length];
            }
        }
        return result;
    }

    private static Time toSqlTime(int hour, int minute, int second, int fraction) {
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.set(14, fraction / 1000000);
        return new Time(cal.getTimeInMillis());
    }

    private static Timestamp toSqlTimestamp(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, dayOfMonth);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

