/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class PasswordMessage
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_password;

    public PasswordMessage(String password, IPGLogger logger) {
        this.m_password = (byte[])(null != password ? PGDataTypeUtilities.toUTF8ByteArray(password) : null);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public PasswordMessage(byte[] password, IPGLogger logger) {
        this.m_password = password;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)112);
        buffer.put(sizebytes);
        if (null != this.m_password) {
            buffer.put(this.m_password);
        }
        buffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + (this.m_password != null ? this.m_password.length : 0) + 1;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "=>FE Password(md5digest=" + new String(this.m_password) + ")";
        logger.logDebugExternal(message);
    }
}

