/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class ReadyForQuery
extends AbstractInboundMessage
implements PGConstants {
    private static final char STATUS_IDLE = 'I';
    private static final char STATUS_TRANSACTION_BLOCK = 'T';
    private static final char STATUS_FAILED_TRANSACTION_BLOCK = 'E';
    private final char m_status;

    public ReadyForQuery(ByteBuffer buffer, IPGLogger logger) {
        this.m_status = (char)buffer.get();
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public boolean isIdle() {
        return 'I' == this.m_status;
    }

    public boolean isTransactionBlock() {
        return 'T' == this.m_status;
    }

    public boolean isFailedTransactionBlock() {
        return 'E' == this.m_status;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE ReadyForQuery(" + this.m_status + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nReadyForQuery: isIdle - ");
        str.append(this.isIdle());
        str.append("\nisTransactionBlock - ");
        str.append(this.isTransactionBlock());
        str.append("\nisFailedTransactionBlock - ");
        str.append(this.isFailedTransactionBlock());
        return str.toString();
    }
}

