/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class ParameterStatus
extends AbstractInboundMessage
implements PGConstants {
    private final String m_name;
    private final String m_value;

    public ParameterStatus(ByteBuffer buffer, IPGLogger logger) {
        this.m_name = this.getNullTerminatedFieldAsUTF8String(buffer);
        this.m_value = this.getNullTerminatedFieldAsUTF8String(buffer);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE ParameterStatus(name=" + this.m_name + ", value=" + this.m_value + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        return "\nParameterStatus: name - `" + this.m_name + "`, value - `" + this.m_value + "`";
    }
}

