/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CopyData
extends AbstractInboundMessage
implements PGConstants {
    private int m_position = 0;
    private final byte[] m_data;

    public CopyData(ByteBuffer buffer, int size, IPGLogger logger) throws ErrorException {
        try {
            this.m_data = new byte[size];
        }
        catch (OutOfMemoryError ex) {
            LogUtilities.logFatal("OutOfMemoryError:CopyData:Size=" + size + ":" + ex.getMessage(), (ILogger)logger);
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage() + ":DataRowColumn:Size=" + size, (Throwable)ex);
            throw err;
        }
        this.read(buffer);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public void read(ByteBuffer buffer) {
        int chunk = this.m_data.length - this.m_position;
        if (buffer.remaining() < this.m_data.length - this.m_position) {
            chunk = buffer.remaining();
        }
        buffer.get(this.m_data, this.m_position, chunk);
        this.m_position += chunk;
    }

    public int getPosition() {
        return this.m_position;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public boolean isCopyComplete() {
        return this.m_position == this.m_data.length;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE CopyData(" + this.m_data.length + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nCopyData: data - ");
        str.append(new String(this.m_data));
        return str.toString();
    }
}

