/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.channels.AbstractSocketChannel;
import com.amazon.channels.PlainSocketChannel;
import com.amazon.channels.TLSSocketChannel;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.communications.InboundMessagesThread;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.InboundDataHandler;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.client.messages.outbound.Bind;
import com.amazon.redshift.client.messages.outbound.CancelRequest;
import com.amazon.redshift.client.messages.outbound.Close;
import com.amazon.redshift.client.messages.outbound.Describe;
import com.amazon.redshift.client.messages.outbound.Execute;
import com.amazon.redshift.client.messages.outbound.Flush;
import com.amazon.redshift.client.messages.outbound.Parse;
import com.amazon.redshift.client.messages.outbound.PasswordMessage;
import com.amazon.redshift.client.messages.outbound.Query;
import com.amazon.redshift.client.messages.outbound.SSLRequest;
import com.amazon.redshift.client.messages.outbound.Startup;
import com.amazon.redshift.client.messages.outbound.Sync;
import com.amazon.redshift.client.messages.outbound.Terminate;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class PGClient
implements SocketCloseListener,
PGConstants {
    private static final String SYNTHETIC_PREPARED_STATEMENT_NAME_SEED = "PGJDBCSTMT";
    private static final String SYNTHETIC_PORTAL_NAME_SEED = "PGJDBCPRTL";
    private static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PWD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private static final int WRITE_BUFFER_CAPACITY = 64000;
    private static final int WRITE_RETRY_DELAY_MS = 10;
    Selector m_selector;
    private IPGLogger m_log;
    private InboundMessagesThread m_backgroundFetcher;
    private final PGJDBCSettings m_settings;
    private AbstractSocketChannel m_socketChannel;
    private IWarningListener m_connectionWarningListener;
    private InboundDataHandler m_dataHandler;
    private final KeyData m_keyData;
    private final AbstractOutboundMessage[] m_oneMessage = new AbstractOutboundMessage[1];
    private final AbstractOutboundMessage[] m_threeMessages = new AbstractOutboundMessage[3];
    private final AbstractOutboundMessage[] m_fourMessages = new AbstractOutboundMessage[4];
    private final AbstractOutboundMessage[] m_fiveMessages = new AbstractOutboundMessage[5];
    private final AbstractOutboundMessage[] m_sixMessages = new AbstractOutboundMessage[6];
    private final AbstractOutboundMessage[] m_sevenMessages = new AbstractOutboundMessage[7];
    private final AbstractOutboundMessage[] m_flushSync = new AbstractOutboundMessage[2];
    public static final int MAX_CACHED_FORMAT_CODE_ARRAYS = 30;
    public short[][] m_cachedBinaryFormatCodes = new short[30][];
    public short[][] m_cachedTextFormatCodes = new short[30][];
    public ErrorException m_fatalException = null;
    private final Flush m_flush;
    private final Sync m_sync;
    private ByteBuffer m_writeBuffer;

    public PGClient(PGJDBCSettings m_settings, IPGLogger logger, IWarningListener connectionWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(logger, new Object[0]);
        try {
            this.m_settings = m_settings;
            this.m_connectionWarningListener = connectionWarningListener;
            this.m_log = logger;
            this.m_flush = new Flush(this.m_log);
            this.m_sync = new Sync(this.m_log);
            this.m_flushSync[0] = this.m_flush;
            this.m_flushSync[1] = this.m_sync;
            this.m_writeBuffer = ByteBuffer.allocateDirect(64000);
            this.m_dataHandler = new InboundDataHandler(this.m_log, m_settings.m_nRowMode, FilterUtilities.translateLevel(m_settings.m_filterLevel));
            this.m_socketChannel = this.connect(this.m_dataHandler);
            switch (m_settings.m_authMech) {
                case DISABLE: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException e) {
                        if (null != this.m_fatalException) {
                            e = this.m_fatalException;
                        }
                        throw e;
                    }
                }
                case ALLOW: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException e) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect(this.m_dataHandler);
                            this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                            this.startSession();
                            break;
                        }
                        catch (ErrorException ex) {
                            if (null != this.m_fatalException) {
                                ex = this.m_fatalException;
                            }
                            throw ex;
                        }
                    }
                }
                case PREFER: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException e) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect(this.m_dataHandler);
                            this.startSession();
                            break;
                        }
                        catch (ErrorException ex) {
                            if (null != this.m_fatalException) {
                                ex = this.m_fatalException;
                            }
                            throw ex;
                        }
                    }
                }
                case REQUIRE: 
                case VERIFY_CA: 
                case VERIFY_FULL: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException e) {
                        if (null != this.m_fatalException) {
                            e = this.m_fatalException;
                        }
                        throw e;
                    }
                }
            }
            this.m_keyData = this.m_dataHandler.m_keyData;
        }
        catch (ErrorException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
            this.closeSession();
            throw ex;
        }
    }

    protected AbstractSocketChannel connect(InboundDataHandler dataHandler) throws ErrorException {
        Object connectionInfoLog;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean successFlag = false;
        AbstractSocketChannel socketChannel = null;
        if (this.m_log.isExternalLoggerEnabled()) {
            connectionInfoLog = "Trying to establish a protocol version 3 connection to " + this.m_settings.m_host + ":" + this.m_settings.m_port;
            this.m_log.logInfoExternal((String)connectionInfoLog);
        }
        try {
            if (null != this.m_keyData) {
                this.m_dataHandler.m_keyData = this.m_keyData;
            }
            socketChannel = new PlainSocketChannel(SocketChannel.open(), dataHandler, this.m_log);
            this.m_selector = Selector.open();
            socketChannel.getSocketChannel().configureBlocking(true);
            socketChannel.getSocketChannel().socket().connect(new InetSocketAddress(this.m_settings.m_host, this.m_settings.m_port), this.m_settings.m_loginTimeoutMS);
            socketChannel.getSocketChannel().socket().setKeepAlive(false);
            if (0 < this.m_settings.m_newTCPConnectionKeepAliveMinutes) {
                socketChannel.getSocketChannel().socket().setKeepAlive(true);
            }
            successFlag = true;
            connectionInfoLog = socketChannel;
            return connectionInfoLog;
        }
        catch (IOException ex) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(ex, (ILogger)this.m_log);
            }
            this.closeSession();
            String message = ex.getLocalizedMessage();
            if (null == message) {
                message = ex.getClass().getSimpleName();
            }
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), message);
            err.initCause(ex);
            throw err;
        }
        finally {
            if (!successFlag && null != socketChannel && socketChannel.getSocketChannel().isOpen()) {
                LogUtilities.logDebug("Closing socket channel", (ILogger)this.m_log);
                socketChannel.close();
                socketChannel = null;
            }
        }
    }

    protected void startSession() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.m_socketChannel.getSocketChannel().configureBlocking(false);
            this.m_socketChannel.getSocketChannel().register(this.m_selector, 1);
        }
        catch (IllegalSelectorException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        catch (ClosedChannelException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        this.m_oneMessage[0] = new Startup(this.m_settings.m_username, this.m_settings.m_Schema, this.m_log);
        PGMessagingContext context = PGMessagingContext.createStatementContext(this, "start", 0, 0, this.m_log, null, null);
        context.openCurrentOperation();
        this.write(context, this.m_oneMessage);
        if (this.m_log.isExternalLoggerEnabled()) {
            this.m_log.logDebugExternal("Receive Buffer Size is " + this.m_socketChannel.getReadBufferCapacity());
            this.m_log.logDebugExternal("Send Buffer Size is " + this.m_socketChannel.getReadBufferCapacity());
        }
        this.m_backgroundFetcher = new InboundMessagesThread(this.m_selector, this.m_socketChannel, this.m_dataHandler, this.m_settings.m_newTCPConnectionKeepAliveMinutes, this.m_settings.m_host, this.m_settings.m_port, this.m_settings.m_socketTimeoutMS, this.m_log);
        this.m_backgroundFetcher.start();
        this.m_backgroundFetcher.addSocketCloseListener(this);
        for (int i = 0; i < 2; ++i) {
            Authentication auth = null;
            auth = context.getAuthentication(this.m_settings.m_loginTimeoutMS);
            if (null == auth) {
                LogUtilities.logFatal("Timeout waiting for respons to startup message.", (ILogger)this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_TIMEOUT_ERR.name());
            }
            if (auth.isAuthenticationOK()) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Authentication is OK", (ILogger)this.m_log);
                }
                context.checkErrorResponse(this.m_settings.m_loginTimeoutMS);
                if (null == this.m_fatalException) break;
                throw this.m_fatalException;
            }
            if (auth.isClearTextPasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending cleartext password", (ILogger)this.m_log);
                    }
                    this.m_oneMessage[0] = new PasswordMessage(this.m_settings.m_password, this.m_log);
                    this.write((PGMessagingContext)null, this.m_oneMessage);
                    continue;
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", (ILogger)this.m_log);
                }
                this.closeSession(false, true);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (auth.isMD5PasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending MD5 password", (ILogger)this.m_log);
                    }
                    try {
                        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                        md5Digest.update(PGDataTypeUtilities.toUTF8ByteArray(this.m_settings.m_password + this.m_settings.m_username));
                        byte[] hex = PGDataTypeUtilities.toHexString(md5Digest.digest());
                        md5Digest.update(hex, 0, hex.length);
                        md5Digest.update(auth.getMD5SaltKey());
                        String hexaPassword = PGDataTypeUtilities.toUTF8String(PGDataTypeUtilities.toHexString(md5Digest.digest()));
                        this.m_oneMessage[0] = new PasswordMessage("md5" + hexaPassword, this.m_log);
                        this.write((PGMessagingContext)null, this.m_oneMessage);
                        continue;
                    }
                    catch (NoSuchAlgorithmException ex) {
                        LogUtilities.logFatal(ex, (ILogger)this.m_log);
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), auth.toString());
                    }
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", (ILogger)this.m_log);
                }
                this.closeSession(false, true);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Authentication mechanism not supported: " + auth.toString(), (ILogger)this.m_log);
            }
            this.closeSession(false, true);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), auth.toString());
        }
    }

    public void cancelQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            CancelRequest cancelRequest = new CancelRequest(this.m_keyData, this.m_log);
            InboundDataHandler dataHandler = new InboundDataHandler(this.m_log, this.m_settings.m_nRowMode, FilterUtilities.translateLevel(this.m_settings.m_filterLevel));
            AbstractSocketChannel cancelSocketChannel = this.connect(dataHandler);
            if (this.m_socketChannel instanceof TLSSocketChannel) {
                cancelSocketChannel = this.checkSSL(cancelSocketChannel);
            }
            AbstractOutboundMessage[] message = new AbstractOutboundMessage[]{cancelRequest};
            this.write(cancelSocketChannel, null, null, message);
            try {
                cancelSocketChannel.read();
            }
            catch (Exception e) {
                // empty catch block
            }
            cancelSocketChannel.close();
        }
        catch (Exception ex) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(ex, (ILogger)this.m_log);
            }
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_GENERAL_ERR.name(), ex.getMessage());
            err.initCause(ex);
            throw err;
        }
    }

    public void closeSession() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.closeSession(true, true);
    }

    public void closeSession(boolean sendTerminate, boolean closeBackgroundThread) {
        LogUtilities.logFunctionEntrance(this.m_log, sendTerminate);
        if (null == this.m_socketChannel || !this.m_socketChannel.getSocketChannel().isConnected()) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Channel is not connected.", (ILogger)this.m_log);
            }
        } else if (sendTerminate && null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isConnected()) {
            AbstractOutboundMessage[] terminate = new AbstractOutboundMessage[]{new Terminate(this.m_log)};
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Sending terminate message", (ILogger)this.m_log);
            }
            try {
                this.write(PGMessagingContext.createStatementContext(this, "terminate", this.m_settings.m_nRowMode, 0, this.m_log, null, null), terminate);
            }
            catch (ErrorException ex) {
                // empty catch block
            }
        }
        if (closeBackgroundThread && null != this.m_backgroundFetcher) {
            LogUtilities.logDebug("Closing background thread", (ILogger)this.m_log);
            this.m_backgroundFetcher.close(null);
        }
        if (null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isOpen()) {
            LogUtilities.logDebug("Closing socket channel", (ILogger)this.m_log);
            this.m_socketChannel.close();
            this.m_socketChannel = null;
        }
        if (null != this.m_selector && this.m_selector.isOpen()) {
            try {
                this.m_selector.close();
                this.m_selector = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockingRowsMode(int fetchSize, boolean disableBlockingRowsMode) {
        StringBuilder str = null;
        boolean log = false;
        if (LogLevel.TRACE == this.m_log.getLogLevel()) {
            log = true;
            str = new StringBuilder();
            str.append("getBlockingRowsMode(");
            str.append(fetchSize);
            str.append(", ");
            str.append(disableBlockingRowsMode);
            str.append(")");
            str.append("=");
        }
        try {
            if (disableBlockingRowsMode) {
                int n = 0;
                return n;
            }
            if (0 == fetchSize && 0 == this.m_settings.m_nRowMode) {
                if (log) {
                    str.append(0);
                }
                int n = 0;
                return n;
            }
            if (fetchSize == this.m_settings.m_nRowMode) {
                if (log) {
                    str.append("m_settings.m_nRowMode=");
                    str.append(this.m_settings.m_nRowMode);
                }
                int n = this.m_settings.m_nRowMode;
                return n;
            }
            if (fetchSize > 0) {
                if (fetchSize >= 5) {
                    if (log) {
                        str.append("fetchSize=");
                        str.append(this.m_settings.m_nRowMode);
                    }
                    int n = fetchSize;
                    return n;
                }
                if (log) {
                    str.append("PGConstants.MIN_BLOCKING_ROWS_MODE=");
                    str.append(5);
                }
                int n = 5;
                return n;
            }
            if (log) {
                str.append("m_settings.m_nRowMode=");
                str.append(this.m_settings.m_nRowMode);
            }
            int n = this.m_settings.m_nRowMode;
            return n;
        }
        finally {
            if (log) {
                LogUtilities.logDebug(str.toString(), (ILogger)this.m_log);
            }
        }
    }

    public PGMessagingContext directExecute(String query, boolean isRowCount, int fetchSize, int maxRows, IWarningListener statementWarningListener, boolean disableBlockingRowsMode) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, query);
        int nRowMode = this.getBlockingRowsMode(fetchSize, isRowCount ? isRowCount : disableBlockingRowsMode);
        if (this.isConnected()) {
            try {
                PGMessagingContext context = PGMessagingContext.createStatementContext(this, query, nRowMode, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
                if (!isRowCount && maxRows > 0) {
                    context.clearPortalName();
                    byte[] portalName = this.generateSynthteticPortalName(0);
                    this.m_sevenMessages[0] = new Parse(null, query, null, this.m_log);
                    this.m_sevenMessages[1] = new Bind(portalName, null, null, null, null, this.m_log);
                    this.m_sevenMessages[2] = new Describe(portalName, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sevenMessages[3] = new Execute(portalName, maxRows, this.m_log);
                    this.m_sevenMessages[4] = new Close(portalName, Close.CloseType.PORTAL, this.m_log);
                    this.m_sevenMessages[5] = this.m_flush;
                    this.m_sevenMessages[6] = this.m_sync;
                    this.write(context, this.m_sevenMessages);
                } else {
                    this.m_sixMessages[0] = new Parse(null, query, null, this.m_log);
                    this.m_sixMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                    this.m_sixMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[3] = new Execute(null, 0, this.m_log);
                    this.m_sixMessages[4] = this.m_flush;
                    this.m_sixMessages[5] = this.m_sync;
                    this.write(context, this.m_sixMessages);
                }
                this.handleErrors(context);
                return context;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext directExecuteExtraMetadata(String query, int fetchSize, int maxRows, IWarningListener statementWarningListener, boolean disableBlockingRowsMode) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, query);
        if (this.isConnected()) {
            try {
                PGMessagingContext metadataContext = PGMessagingContext.createStatementContext(this, query, 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
                this.m_fiveMessages[0] = new Parse(null, query, null, this.m_log);
                this.m_fiveMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                this.m_fiveMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                this.m_fiveMessages[3] = this.m_flush;
                this.m_fiveMessages[4] = this.m_sync;
                this.write(metadataContext, this.m_fiveMessages);
                this.handleErrors(metadataContext);
                ColumnsIsNullResultSet columnNulls = this.createColumnsIsNullResultSet(metadataContext);
                metadataContext.close();
                PGMessagingContext context = this.directExecute(query, null != metadataContext.getNoData(), fetchSize, maxRows, statementWarningListener, disableBlockingRowsMode);
                context.m_columnsIsNullResultSet = columnNulls;
                return context;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext directExecuteImmediately(String query, IWarningListener statementWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, query);
        if (this.isConnected()) {
            try {
                PGMessagingContext context = PGMessagingContext.createStatementContext(this, query, 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
                context.m_query = query;
                context.openCurrentOperation(0, false);
                this.m_oneMessage[0] = new Query(query, this.m_log);
                this.write(context, this.m_oneMessage);
                this.checkTimeOut(context);
                context.closeOperation();
                return context;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void executePreparedStatement(PGMessagingContext context, int fetchSize, int maxRows, boolean disableBlockingRowsMode, byte[][] parameterValues) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, context.m_query);
        if (this.isConnected()) {
            try {
                if (null == context.getNoData()) {
                    if (disableBlockingRowsMode) {
                        this.postBRMDisabledWarning(context, fetchSize);
                    }
                    context.setNRowMode(this.getBlockingRowsMode(fetchSize, disableBlockingRowsMode), this.m_dataHandler);
                } else {
                    context.setNRowMode(0, this.m_dataHandler);
                    maxRows = 0;
                }
                short[] formatCodes = null;
                if (null != parameterValues) {
                    formatCodes = this.buildFormatCodes(parameterValues.length);
                }
                context.clearPortalName();
                byte[] portalName = this.generateSynthteticPortalName(0);
                context.setPortalName(portalName);
                if (maxRows > 0) {
                    context.openCurrentOperation(maxRows, true);
                    this.m_sixMessages[0] = new Bind(portalName, context.m_serverStatementName, formatCodes, parameterValues, null, this.m_log);
                    this.m_sixMessages[1] = new Describe(portalName, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[2] = new Execute(portalName, context.m_maxRow, this.m_log);
                    this.m_sixMessages[3] = new Close(portalName, Close.CloseType.PORTAL, this.m_log);
                    this.m_sixMessages[4] = this.m_flush;
                    this.m_sixMessages[5] = this.m_sync;
                    context.clearPortalName();
                    this.write(context, this.m_sixMessages);
                } else {
                    context.openCurrentOperation(0, true);
                    this.m_fiveMessages[0] = new Bind(portalName, context.m_serverStatementName, formatCodes, parameterValues, null, this.m_log);
                    this.m_fiveMessages[1] = new Describe(portalName, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_fiveMessages[2] = new Execute(portalName, 0, this.m_log);
                    this.m_fiveMessages[3] = this.m_flush;
                    this.m_fiveMessages[4] = this.m_sync;
                    this.write(context, this.m_fiveMessages);
                }
                this.handleErrorsPrepareExecute(context);
                this.checkTimeOut(context);
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public void executePreparedStatementParameterSets(PGMessagingContext context, int currentExecuteIndex, byte[][][] parameterValueBatch) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, context.m_query);
        if (this.isConnected()) {
            try {
                int i;
                AbstractOutboundMessage[] batch = new AbstractOutboundMessage[parameterValueBatch.length * 2 + 2];
                context.setNRowMode(0, this.m_dataHandler);
                context.openCurrentOperationBatchMode(parameterValueBatch.length);
                context.clearPortalName();
                for (i = 0; i < parameterValueBatch.length; ++i) {
                    byte[] portalName = this.generateSynthteticPortalName(i);
                    batch[i * 2] = new Bind(portalName, context.m_serverStatementName, this.buildFormatCodes(parameterValueBatch[i].length), parameterValueBatch[i], null, this.m_log);
                    batch[i * 2 + 1] = new Execute(portalName, 0, this.m_log);
                }
                batch[batch.length - 2] = this.m_flush;
                batch[batch.length - 1] = this.m_sync;
                this.write(context, batch);
                this.checkTimeOut(context);
                for (i = 0; i < parameterValueBatch.length; ++i) {
                    int batchIndex = i + currentExecuteIndex;
                    while (context.m_batchBindComplete.size() > batchIndex && null == context.m_batchBindComplete.get(batchIndex) && null == this.m_fatalException) {
                        Thread.yield();
                    }
                    if (null == this.m_fatalException) continue;
                    throw this.m_fatalException;
                }
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeAtomicStatement(List<PGMessagingContext> contexts, List<String> queries, HashMap<PGMessagingContext, ArrayList<byte[][]>> paramSets, int numberOfParameterSets, int maxRows, int fetchSize, IWarningListener statementWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean nonPreparedStatements = false;
        boolean createNamedStatements = false;
        if (this.isConnected()) {
            try {
                if (0 == contexts.size()) {
                    nonPreparedStatements = true;
                    this.buildAtomicStmtContexts(contexts, queries, statementWarningListener);
                }
                this.postBRMDisabledWarnings(contexts, fetchSize);
                fetchSize = 0;
                if (numberOfParameterSets > 1) {
                    maxRows = 0;
                }
                ArrayList<PGMessagingContext> contextExecutionOrder = new ArrayList<PGMessagingContext>(numberOfParameterSets * contexts.size());
                AbstractOutboundMessage[] outboundArray = this.buildAtomicStmtMessageBuffer(contextExecutionOrder, contexts, paramSets, numberOfParameterSets, maxRows, fetchSize, createNamedStatements);
                this.write(contextExecutionOrder, outboundArray);
                this.checkTimeOut(contexts.get(0));
                this.handleAtomicStmtErrors(contexts, nonPreparedStatements);
                if (!nonPreparedStatements) return;
                for (PGMessagingContext context : contexts) {
                    context.m_columnsIsNullResultSet = this.createColumnsIsNullResultSet(context);
                }
                return;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    private void handleAtomicStmtErrors(List<PGMessagingContext> contexts, boolean nonPreparedStatements) throws ErrorException {
        for (int i = 0; i < contexts.size(); ++i) {
            PGMessagingContext context = contexts.get(i);
            if (context.m_batchMode) {
                while (context.m_batchBindComplete.size() > context.m_batchCount && null == context.m_batchBindComplete.get(context.m_batchCount) && null == this.m_fatalException) {
                    Thread.yield();
                }
            } else if (nonPreparedStatements) {
                this.handleErrors(context);
            } else {
                this.handleErrorsPrepareExecute(context);
            }
            if (null == this.m_fatalException) continue;
            throw this.m_fatalException;
        }
    }

    private AbstractOutboundMessage[] buildAtomicStmtMessageBuffer(ArrayList<PGMessagingContext> contextExecutionOrder, List<PGMessagingContext> contexts, HashMap<PGMessagingContext, ArrayList<byte[][]>> paramSets, int numberOfParameterSets, int maxRows, int fetchSize, boolean createNamedStatements) throws InboundErrorMessage {
        ArrayList<AbstractOutboundMessage> outbound = new ArrayList<AbstractOutboundMessage>();
        byte[] localPortalName = null;
        if (maxRows > 0) {
            localPortalName = this.generateSynthteticPortalName(0);
        }
        int numQueries = contexts.size();
        PGMessagingContext.CloseMode defaultCloseMode = PGMessagingContext.CloseMode.ReadyForQuery;
        if (numQueries > 1) {
            defaultCloseMode = PGMessagingContext.CloseMode.CommandComplete;
            if (maxRows > 0) {
                defaultCloseMode = PGMessagingContext.CloseMode.CloseComplete;
            }
        }
        for (int executionContextCounter = 0; executionContextCounter < numberOfParameterSets; ++executionContextCounter) {
            for (int queryCounter = 0; queryCounter < numQueries; ++queryCounter) {
                PGMessagingContext context = contexts.get(queryCounter);
                ArrayList<byte[][]> contextParamSets = paramSets.get(context);
                byte[][] paramSet = null;
                short[] formatCodes = null;
                if (null != contextParamSets) {
                    paramSet = contextParamSets.get(executionContextCounter);
                    formatCodes = this.buildFormatCodes(paramSet.length);
                }
                if (null == context.m_serverStatementName) {
                    if (createNamedStatements) {
                        context.m_serverStatementName = this.generateSynthteticPreparedStatementName();
                    }
                    outbound.add(new Parse(context.m_serverStatementName, context.m_query, context.m_parameterOids, this.m_log));
                }
                outbound.add(new Bind(localPortalName, context.m_serverStatementName, formatCodes, paramSet, null, this.m_log));
                if (0 == executionContextCounter) {
                    outbound.add(new Describe(localPortalName, Describe.DescribeType.PORTAL, this.m_log));
                }
                outbound.add(new Execute(localPortalName, maxRows, this.m_log));
                if (maxRows > 0) {
                    outbound.add(new Close(localPortalName, Close.CloseType.PORTAL, this.m_log));
                }
                if (numberOfParameterSets > 1) {
                    context.openCurrentOperationBatchMode(numberOfParameterSets);
                } else {
                    context.openCurrentOperation(maxRows, true);
                }
                context.setNRowMode(fetchSize, this.m_dataHandler);
                context.setCloseMode(defaultCloseMode);
                context.clearPortalName();
                contextExecutionOrder.add(context);
            }
        }
        outbound.add(this.m_flush);
        outbound.add(this.m_sync);
        return outbound.toArray(new AbstractOutboundMessage[outbound.size()]);
    }

    private void buildAtomicStmtContexts(List<PGMessagingContext> contexts, List<String> queries, IWarningListener statementWarningListener) {
        for (int i = 0; i < queries.size(); ++i) {
            String query = queries.get(i);
            PGMessagingContext context = PGMessagingContext.createStatementContext(this, query, 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
            if (i == queries.size() - 1) {
                context.setFinalCommandInBatch(true);
            } else {
                context.setFinalCommandInBatch(false);
            }
            contexts.add(context);
        }
    }

    public PGMessagingContext prepareStatement(String query, IWarningListener statementWarningListener, boolean disableBlockingRowsMode) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, query);
        PGMessagingContext queryContext = PGMessagingContext.createPreparedStatementContext(this, query, 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
        queryContext.m_serverStatementName = this.generateSynthteticPreparedStatementName();
        if (this.isConnected()) {
            try {
                this.m_fourMessages[0] = new Parse(queryContext.m_serverStatementName, queryContext.m_query, queryContext.m_parameterOids, this.m_log);
                this.m_fourMessages[1] = new Describe(queryContext.m_serverStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = this.m_flush;
                this.m_fourMessages[3] = this.m_sync;
                this.write(queryContext, this.m_fourMessages);
                ParameterDescription paramDesc = null;
                if (null == queryContext.m_readyForQueryFromPipelineForQuery) {
                    LogUtilities.logError("ReadyForQuery not received.", (ILogger)this.m_log);
                }
                if (null != (paramDesc = queryContext.getParameterDescription())) {
                    for (int i = 0; i < paramDesc.getParameterDataTypeOIDs().length; ++i) {
                        int oid = paramDesc.getParameterDataTypeOIDs()[i];
                        int parameterIndex = i + 1;
                        try {
                            PGParameterMetadata paramMeta = PGDataTypeUtilities.createParameter(oid, parameterIndex, queryContext);
                            queryContext.m_parameterMetadata.add(paramMeta);
                            queryContext.m_parameterOids.add(oid);
                            continue;
                        }
                        catch (NumericOverflowException ex) {
                            LogUtilities.logFatal(ex, (ILogger)this.m_log);
                            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage());
                            err.initCause(ex);
                        }
                    }
                }
                queryContext.getReadyForQuery();
                queryContext.m_columnsIsNullResultSet = this.createColumnsIsNullResultSet(queryContext);
                return queryContext;
            }
            catch (ErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext reprepareStatement(PGMessagingContext context, List<Integer> parameterOIDs, IWarningListener statementWarningListener) throws ErrorException {
        if (this.isConnected()) {
            try {
                this.m_threeMessages[0] = new Close(context.m_serverStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                this.m_threeMessages[1] = this.m_flush;
                this.m_threeMessages[2] = this.m_sync;
                PGMessagingContext closeContext = PGMessagingContext.createStatementContext(this, "closeContextRePrepare", 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
                this.write(closeContext, this.m_threeMessages);
                context.openCurrentOperation(0, false);
                context.m_serverStatementName = this.generateSynthteticPreparedStatementName();
                context.m_readyForQueryFromPipelineForPrepare = null;
                context.m_parseComplete = null;
                this.m_fourMessages[0] = new Parse(context.m_serverStatementName, context.m_query, parameterOIDs, this.m_log);
                this.m_fourMessages[1] = new Describe(context.m_serverStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = this.m_flush;
                this.m_fourMessages[3] = this.m_sync;
                this.write(context, this.m_fourMessages);
                this.checkTimeOut(closeContext);
                closeContext.getReadyForQuery();
                closeContext.closeOperation();
            }
            catch (ErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
            try {
                context.getReadyForQuery();
                return context;
            }
            catch (ErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void closeServerNamedStatement(PGMessagingContext context, IWarningListener statementWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, context.m_query);
        if (this.isConnected()) {
            try {
                PGMessagingContext closeContext = PGMessagingContext.createStatementContext(this, "closeContext", 0, 0, this.m_log, this.m_connectionWarningListener, statementWarningListener);
                closeContext.openCurrentOperation();
                this.m_threeMessages[0] = new Close(context.m_serverStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                this.m_threeMessages[1] = this.m_flush;
                this.m_threeMessages[2] = this.m_sync;
                this.write(closeContext, this.m_threeMessages);
                this.checkTimeOut(closeContext);
                closeContext.getReadyForQuery();
            }
            catch (ErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw this.buildError(ex);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public ColumnsIsNullResultSet createColumnsIsNullResultSet(PGMessagingContext context) throws ErrorException {
        RowDescription rowDesc = context.getRowDescription();
        if (null == rowDesc) {
            return null;
        }
        ArrayList<String> tableOIDs = new ArrayList<String>(rowDesc.getNumberOfFields());
        ArrayList<String> colIndexes = new ArrayList<String>(rowDesc.getNumberOfFields());
        if (0 == rowDesc.getFieldDescriptions().length) {
            return null;
        }
        for (FieldDescription fd : rowDesc.getFieldDescriptions()) {
            if (fd.getTableObjectIDString().equals("0")) continue;
            tableOIDs.add(fd.getTableObjectIDString());
            colIndexes.add(fd.getColumnAttributeNumberString());
        }
        if (tableOIDs.size() == 0) {
            return null;
        }
        String catalogFunctionQuery = PGCatalogQueryBuilder.PGAttNotNullBuilder(tableOIDs, colIndexes);
        PGMessagingContext catalogFunctionContext = this.directExecute(catalogFunctionQuery, false, 0, 0, null, true);
        return new ColumnsIsNullResultSet(catalogFunctionContext, this.m_log);
    }

    public boolean isConnected() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_socketChannel || this.m_socketChannel.isClosed()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Not Connected");
        }
        return true;
    }

    private TLSSocketChannel checkSSL(AbstractSocketChannel socketChannel) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        TLSSocketChannel sslMessageSocketChannel = null;
        try {
            this.m_oneMessage[0] = new SSLRequest(this.m_log);
            this.write(socketChannel, null, null, this.m_oneMessage);
            ByteBuffer sslRequest = ByteBuffer.allocateDirect(512);
            int bytesRead = socketChannel.getSocketChannel().read(sslRequest);
            sslRequest.flip();
            if (bytesRead < 0) {
                LogUtilities.logDebug("createSSLSocketChannel:0 Bytes Read, Server closed socket.", (ILogger)this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection.");
            }
            char message = (char)sslRequest.get();
            switch (message) {
                case 'S': {
                    LogUtilities.logDebug("createSSLSocketChannel:SSL Supported", (ILogger)this.m_log);
                    socketChannel.getSocketChannel().configureBlocking(false);
                    TrustManager[] trustManagers = null;
                    trustManagers = AuthMech.VERIFY_FULL == this.m_settings.m_authMech || AuthMech.VERIFY_CA == this.m_settings.m_authMech ? this.getDefaultTrustManager() : new TrustManager[]{new NonValidatingFactory()};
                    sslMessageSocketChannel = new TLSSocketChannel(socketChannel.getSocketChannel(), this.m_dataHandler, this.m_settings.m_host, this.m_settings.m_port, AuthMech.VERIFY_FULL == this.m_settings.m_authMech, null, trustManagers, this.m_log);
                    break;
                }
                case 'N': {
                    LogUtilities.logFatal("createSSLSocketChannel:SSL Not Supported (Unwilling)", (ILogger)this.m_log);
                    break;
                }
                case 'E': {
                    ErrorResponse errorReponse = null;
                    try {
                        int length = sslRequest.getInt();
                        errorReponse = new ErrorResponse(sslRequest, length, this.m_log);
                        LogUtilities.logFatal(errorReponse.getMessage(), (ILogger)this.m_log);
                    }
                    catch (Exception ex) {
                        LogUtilities.logFatal("Attempting to connect to very old Server version.", (ILogger)this.m_log);
                        LogUtilities.logFatal(ex, (ILogger)this.m_log);
                    }
                    break;
                }
            }
            return sslMessageSocketChannel;
        }
        catch (IOException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage());
            err.initCause(ex);
            throw err;
        }
    }

    public void registerWarningListener(IWarningListener listener) {
        this.m_connectionWarningListener = listener;
        this.m_dataHandler.registerWarningListener(listener);
    }

    @Override
    public void socketClosed(ErrorException exception) {
        LogUtilities.logFunctionEntrance(this.m_log, exception);
        if (null != exception) {
            this.m_fatalException = exception;
        }
        this.closeSession(false, false);
    }

    public short[] buildFormatCodes(int length) {
        short[][] cachedFormatCodes = this.m_cachedTextFormatCodes;
        if (length < 30 && null != cachedFormatCodes[length]) {
            return cachedFormatCodes[length];
        }
        short[] formatCodes = new short[length];
        for (int i = 0; i < length; ++i) {
            formatCodes[i] = 0;
        }
        if (length < 30) {
            cachedFormatCodes[length] = formatCodes;
        }
        return formatCodes;
    }

    private void handleErrors(PGMessagingContext context) throws ErrorException {
        this.handleErrorsScenario1(context);
        this.handleErrorsScenario2(context);
        this.handleErrorsScenario3(context);
    }

    private void handleErrorsPrepareExecute(PGMessagingContext context) throws ErrorException {
        this.handleErrorsScenario1(context);
        this.handleErrorsScenario2ForPrepareExecution(context);
        this.handleErrorsScenario3(context);
    }

    private void handleErrorsScenario1(PGMessagingContext context) throws ErrorException {
        while (null == context.getBindComplete() && null == this.m_fatalException) {
            IInboundMessage peeked = context.peekNextMessage(this.m_settings.m_socketTimeoutMS);
            if (!(peeked instanceof ErrorResponse)) continue;
            context.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
    }

    private void handleErrorsScenario2ForPrepareExecution(PGMessagingContext context) throws ErrorException {
        IInboundMessage peeked;
        if (!(context.getNoDataForPrepareExecute() && context.getRowDescriptionForPrepareExecute() || !((peeked = context.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse))) {
            context.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
    }

    private void handleErrorsScenario2(PGMessagingContext context) throws ErrorException {
        IInboundMessage peeked;
        if (null == context.getNoData() && null == context.getRowDescription() && (peeked = context.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
            context.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
    }

    private void handleErrorsScenario3(PGMessagingContext context) throws ErrorException {
        IInboundMessage peeked;
        if (null == context.m_readyForQueryFromPipelineForQuery && (peeked = context.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
            context.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
    }

    private TrustManager[] getDefaultTrustManager() throws ErrorException {
        FileInputStream keystoreStream = null;
        String passphrase = null;
        String keystorePath = System.getProperty(TRUSTSTORE_PROPERTY);
        passphrase = System.getProperty(TRUSTSTORE_PWD_PROPERTY);
        if (null == keystorePath) {
            StringBuilder trustorePath = new StringBuilder();
            trustorePath.append(System.getProperty("java.home"));
            trustorePath.append(File.separatorChar);
            trustorePath.append("lib");
            trustorePath.append(File.separatorChar);
            trustorePath.append("security");
            trustorePath.append(File.separatorChar);
            trustorePath.append("cacerts");
            keystorePath = trustorePath.toString();
        }
        try {
            keystoreStream = new FileInputStream(new File(keystorePath));
        }
        catch (Exception e) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the keystore ");
            LogUtilities.logError(err, (ILogger)this.m_log);
            throw err;
        }
        return this.getExternalKeystoreTrustManager(keystoreStream, passphrase);
    }

    private TrustManager[] getExternalKeystoreTrustManager(InputStream keystoreStream, String passphrase) throws ErrorException {
        KeyStore keystore = null;
        try {
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] passphraseArray = null;
            if (null != passphrase) {
                passphraseArray = passphrase.toCharArray();
            }
            keystore.load(keystoreStream, passphraseArray);
            keystoreStream.close();
        }
        catch (Exception e) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the provided keystore");
            LogUtilities.logError(err, (ILogger)this.m_log);
            throw err;
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error retrieving the available trust managers");
            LogUtilities.logError(err, (ILogger)this.m_log);
            throw err;
        }
    }

    private byte[] generateSynthteticPortalName(int index) {
        StringBuilder str = new StringBuilder();
        str.append(SYNTHETIC_PORTAL_NAME_SEED);
        str.append("-");
        str.append(index);
        str.append("-");
        str.append(System.nanoTime());
        return PGDataTypeUtilities.toUTF8ByteArray(str.toString());
    }

    private byte[] generateSynthteticPreparedStatementName() {
        StringBuilder str = new StringBuilder();
        str.append(SYNTHETIC_PREPARED_STATEMENT_NAME_SEED);
        str.append("-");
        str.append(System.nanoTime());
        return PGDataTypeUtilities.toUTF8ByteArray(str.toString());
    }

    private void checkTimeOut(PGMessagingContext context) throws ErrorException {
        if (this.m_settings.m_socketTimeoutMS > 0) {
            IInboundMessage message = null;
            message = context.peekNextMessage(this.m_settings.m_socketTimeoutMS);
            if (null == message) {
                LogUtilities.logFatal("The Socket Has TimedOut.", (ILogger)this.m_log);
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name(), ExceptionType.TIME_OUT);
                throw err;
            }
        }
    }

    private ErrorException buildError(Exception ex) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (ex instanceof ErrorException) {
            return (ErrorException)ex;
        }
        ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        err.initCause(ex);
        return err;
    }

    public void sync() throws ErrorException {
        PGMessagingContext context = PGMessagingContext.createStatementContext(this, "sync", 0, 0, this.m_log, null, null);
        this.write(context, this.m_flushSync);
        context.getReadyForQuery();
    }

    public synchronized void write(PGMessagingContext pipeline, AbstractOutboundMessage[] messages) throws ErrorException {
        this.write(this.m_socketChannel, pipeline, null, messages);
    }

    public synchronized void write(List<PGMessagingContext> pipelines, AbstractOutboundMessage[] messages) throws ErrorException {
        this.write(this.m_socketChannel, null, pipelines, messages);
    }

    public synchronized void write(AbstractSocketChannel socketChannel, PGMessagingContext pipeline, List<PGMessagingContext> pipelines, AbstractOutboundMessage[] messages) throws ErrorException {
        if (null != socketChannel && !socketChannel.isClosed()) {
            int correctSize = 0;
            for (AbstractOutboundMessage message : messages) {
                if (null == message) continue;
                correctSize += message.getSize() + 1;
            }
            if (correctSize > this.m_writeBuffer.capacity()) {
                this.m_writeBuffer = ByteBuffer.allocateDirect(correctSize);
            }
            this.m_writeBuffer.clear();
            for (AbstractOutboundMessage message : messages) {
                if (null == message) continue;
                message.serialize(this.m_writeBuffer);
            }
            this.m_writeBuffer.flip();
            if (null != pipeline) {
                this.m_dataHandler.addPipeline(pipeline);
            } else if (null != pipelines) {
                for (PGMessagingContext context : pipelines) {
                    this.m_dataHandler.addPipeline(context);
                }
            }
            boolean writeComplete = socketChannel.write(this.m_writeBuffer);
            while (this.m_writeBuffer.hasRemaining() || !writeComplete) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                writeComplete = socketChannel.write(this.m_writeBuffer);
            }
        } else {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Internal channel not connected", (ILogger)this.m_log);
            }
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public synchronized void write(PGMessagingContext pipeline, Iterator<AbstractOutboundMessage> messagesIterator) throws ErrorException {
        AbstractOutboundMessage[] messages = new AbstractOutboundMessage[1];
        while (messagesIterator.hasNext()) {
            messages[0] = messagesIterator.next();
            this.write(pipeline, messages);
        }
    }

    private void postBRMDisabledWarnings(List<PGMessagingContext> contexts, int fetchSize) {
        for (PGMessagingContext context : contexts) {
            this.postBRMDisabledWarning(context, fetchSize);
        }
    }

    private void postBRMDisabledWarning(PGMessagingContext context, int fetchSize) {
        Integer value = null;
        if (0 != fetchSize) {
            value = fetchSize;
        } else if (0 != this.m_settings.m_nRowMode) {
            value = this.m_settings.m_nRowMode;
        }
        if (null != value) {
            context.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_QUERY_BLOCK_ROWS_MODE_DISABLED.name(), new String[]{value.toString()}));
        }
    }
}

