/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.utils;

import com.amazon.jdbc.utils.ParsingException;
import java.util.ArrayList;
import java.util.List;

public class ParseQueryUtils {
    public static List<String> splitQueries(String query, boolean isDollarQuoted) throws ParsingException {
        ArrayList<String> results = new ArrayList<String>();
        int startingIndex = 0;
        int i = 0;
        String subQuery = null;
        StringBuilder subQueryBuilder = new StringBuilder();
        for (i = 0; i < query.length() && 0 <= query.indexOf(59, i); ++i) {
            switch (query.charAt(i)) {
                case ';': {
                    subQueryBuilder.append(query.substring(startingIndex, i));
                    if (0 < subQueryBuilder.length() && null != (subQuery = subQueryBuilder.toString().trim()) && subQuery.length() > 0) {
                        results.add(subQuery);
                    }
                    subQueryBuilder = new StringBuilder();
                    startingIndex = i + 1;
                    break;
                }
                case '\"': {
                    if (i > 0 && '\\' == query.charAt(i - 1)) break;
                    i = query.indexOf(34, i + 1);
                    break;
                }
                case '\'': {
                    i = query.indexOf(39, i + 1);
                    while (i < query.length() - 1 && '\'' == query.charAt(i + 1) || i > 0 && '\\' == query.charAt(i - 1)) {
                        i = query.indexOf(39, i + 1);
                    }
                    break;
                }
                case '-': {
                    if (query.charAt(i + 1) != '-') break;
                    int j = query.indexOf(10, i + 2);
                    subQueryBuilder.append(query.substring(startingIndex, i));
                    i = j;
                    startingIndex = i + 1;
                    break;
                }
                case '#': {
                    int j = query.indexOf(10, i + 1);
                    subQueryBuilder.append(query.substring(startingIndex, i));
                    i = j;
                    startingIndex = i + 1;
                }
                case '/': {
                    int j;
                    if (query.charAt(i + 1) != '*' || -1 == (j = query.indexOf("*/", i + 2))) break;
                    subQueryBuilder.append(query.substring(startingIndex, i));
                    i = j;
                    startingIndex = i + 2;
                    break;
                }
                case '$': {
                    if (!isDollarQuoted || i + 1 >= query.length() || query.charAt(i + 1) != '$') break;
                    int j = query.indexOf("$$", i + 2);
                    i = j < 0 ? query.length() : j + 1;
                }
            }
            if (i >= 0) continue;
            throw new ParsingException();
        }
        if (startingIndex != query.length()) {
            subQuery = query.substring(startingIndex, query.length());
            if (null != (subQuery = ParseQueryUtils.parseCommentsOnSingleQuery(subQuery).trim()) && subQuery.length() > 0) {
                results.add(subQuery.trim());
            }
        }
        return results;
    }

    public static List<String> splitQueries(String query) throws ParsingException {
        return ParseQueryUtils.splitQueries(query, false);
    }

    public static String removeComments(String query) {
        String result = query;
        if (query.contains("/*")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("/*");
            int commentStop = query.indexOf("*/");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop, query.length()));
            }
            result = sb.toString().trim();
        } else if (query.contains("--")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("--");
            int commentStop = query.indexOf("\n");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop + 1, query.length()));
            }
            result = sb.toString().trim();
        } else if (query.contains("#")) {
            StringBuilder sb = new StringBuilder();
            int commentStart = query.indexOf("#");
            int commentStop = query.indexOf("\n");
            sb.append(query.substring(0, commentStart));
            if (-1 != commentStop) {
                sb.append(query.substring(commentStop + 1, query.length()));
            }
            result = sb.toString().trim();
        }
        return result;
    }

    public static String parseCommentsOnSingleQuery(String sql) {
        StringBuilder result = new StringBuilder();
        boolean inSingle = false;
        boolean inDouble = false;
        int queryLength = sql.length();
        block7: for (int i = 0; i < queryLength; ++i) {
            char cur = sql.charAt(i);
            switch (cur) {
                case '\'': {
                    int indexOfNextSingleQuote = sql.indexOf(39, i + 1);
                    int indexOfNextOpenBrace = sql.indexOf(40, i + 1);
                    inSingle = !inDouble && !inSingle ? 0 < indexOfNextOpenBrace && 0 < indexOfNextSingleQuote && indexOfNextOpenBrace > indexOfNextSingleQuote || 0 > indexOfNextOpenBrace && 0 <= indexOfNextSingleQuote : false;
                    result.append(cur);
                    continue block7;
                }
                case '\"': {
                    int indexOfNextQuote = sql.indexOf(34, i + 1);
                    int indexOfNextOpenBrace = sql.indexOf(40, i + 1);
                    inDouble = !inDouble && !inSingle ? 0 < indexOfNextOpenBrace && 0 < indexOfNextQuote && indexOfNextOpenBrace > indexOfNextQuote || 0 > indexOfNextOpenBrace && 0 <= indexOfNextQuote : false;
                    result.append(cur);
                    continue block7;
                }
                case '/': {
                    if (!inSingle && !inDouble && i + 1 < queryLength && '*' == sql.charAt(i + 1)) {
                        int end = sql.indexOf("*/", i);
                        if (end <= 0) {
                            return sql;
                        }
                        i = end + 1;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '-': {
                    int ret;
                    if (!inSingle && !inDouble && i + 1 < queryLength && '-' == sql.charAt(i + 1)) {
                        ret = sql.indexOf("\n", i);
                        if (ret == -1) {
                            i = queryLength;
                            continue block7;
                        }
                        i = ret;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                case '#': {
                    int ret;
                    if (!inSingle && !inDouble) {
                        ret = sql.indexOf("\n", i);
                        if (ret == -1) {
                            i = queryLength;
                            continue block7;
                        }
                        i = ret;
                        continue block7;
                    }
                    result.append(cur);
                    continue block7;
                }
                default: {
                    result.append(cur);
                }
            }
        }
        return result.toString();
    }
}

