/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.dataengine.filters;

import com.amazon.dsi.dataengine.filters.IFilter;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.exceptions.IncorrectTypeException;

public class StringFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private final String m_value;

    public StringFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string) {
        this.m_columnTag = metadataSourceColumnTag;
        this.m_value = null != string ? string.trim() : null;
    }

    @Override
    public boolean filter(DataWrapper dataWrapper) {
        if (null == this.m_value) {
            return true;
        }
        try {
            switch (dataWrapper.getType()) {
                case 1: {
                    return this.m_value.equals(dataWrapper.getChar());
                }
                case 12: {
                    return this.m_value.equals(dataWrapper.getVarChar());
                }
                case -1: {
                    return this.m_value.equals(dataWrapper.getLongVarChar());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

