/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.response.parser;

import com.amazon.pay.impl.PayLogUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class ResponseData {
    private final int statusCode;
    private final String responseXml;
    private final PayLogUtil payUtil = new PayLogUtil();

    public ResponseData(int responseCode, String rawXmlString) {
        this.statusCode = responseCode;
        this.responseXml = rawXmlString;
    }

    public ResponseData(ResponseData response) {
        this.responseXml = response.responseXml;
        this.statusCode = response.statusCode;
        this.payUtil.logMessage("\n\nResponse Data: \n" + this.payUtil.sanitizeString(this.responseXml));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String toXML() {
        return this.responseXml;
    }

    public String toJSON() throws JSONException {
        JSONObject jsonObj = XML.toJSONObject((String)this.responseXml);
        return jsonObj.toString();
    }
}

