/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl.ipn;

import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.response.ipn.model.Notification;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class NotificationVerification {
    protected void verifyHeaders(Map<String, String> headers) {
        String SNS_HEADER = "x-amz-sns-message-type";
        String SNS_HEADER_TYPE_NOTIFICATION = "Notification";
        if (headers == null || !headers.containsKey("x-amz-sns-message-type")) {
            throw new AmazonClientException("Error with SNS message, missing header x-amz-sns-message-type");
        }
        String messageType = headers.get("x-amz-sns-message-type");
        if (!"Notification".equalsIgnoreCase(messageType)) {
            throw new AmazonClientException("Error with SNS message, header x-amz-sns-message-type has unexpected value ");
        }
    }

    protected boolean verifyMessage(Notification notification) {
        if (notification == null || notification.getNotificationMetadata() == null || !"Notification".equals(notification.getNotificationMetadata().getType())) {
            throw new AmazonClientException("Unable to parse notification, invalid notification");
        }
        try {
            URL url = new URL(notification.toMap().get("SigningCertURL"));
            this.isValidSigningCertURL(url);
            InputStream inStream = url.openStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(cert.getPublicKey());
            sig.update(this.getMessageBytesToSign(notification));
            if (!sig.verify(DatatypeConverter.parseBase64Binary((String)notification.toMap().get("Signature")))) {
                throw new SecurityException("Message signature calculation failed");
            }
            return true;
        }
        catch (IOException ex) {
            throw new SecurityException("Encountered IOException, notification verification failed: ", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException("Encountered NoSuchAlgorithmException, notification verification failed: ", ex);
        }
        catch (SignatureException ex) {
            throw new SecurityException("Encountered SignatureException, notification verification failed: ", ex);
        }
        catch (CertificateException ex) {
            throw new SecurityException("Encountered CertificateException, notification verification failed: ", ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException("Encountered InvalidKeyException, notification verification failed: ", ex);
        }
    }

    private void isValidSigningCertURL(URL url) throws MalformedURLException {
        Pattern PATTERN_SNS_KEY = Pattern.compile("^sns\\.[a-zA-Z0-9\\-]{3,}\\.amazonaws\\.com(\\.cn)?$");
        String host = url.getHost();
        if (!("https".equals(url.getProtocol()) && url.getPath() != null && url.getPath().endsWith(".pem") && PATTERN_SNS_KEY.matcher(host).matches())) {
            throw new SecurityException("Illegal SigningCertURL parameter: ");
        }
    }

    private byte[] getMessageBytesToSign(Notification notification) {
        String stringToSign = null;
        stringToSign = "Message\n";
        stringToSign = stringToSign + notification.toMap().get("Message") + "\n";
        stringToSign = stringToSign + "MessageId\n";
        stringToSign = stringToSign + notification.toMap().get("MessageId") + "\n";
        stringToSign = stringToSign + "Timestamp\n";
        stringToSign = stringToSign + notification.toMap().get("Timestamp") + "\n";
        stringToSign = stringToSign + "TopicArn\n";
        stringToSign = stringToSign + notification.toMap().get("TopicArn") + "\n";
        stringToSign = stringToSign + "Type\n";
        stringToSign = stringToSign + notification.toMap().get("Type") + "\n";
        return stringToSign.getBytes();
    }
}

