/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.impl;

import com.amazon.pay.Config;
import com.amazon.pay.exceptions.AmazonClientException;
import com.amazon.pay.response.model.Environment;
import com.amazon.pay.types.CurrencyCode;
import com.amazon.pay.types.Key;
import com.amazon.pay.types.Region;
import java.util.Enumeration;
import java.util.Properties;

public class PayConfig
implements Config {
    private String accessKey;
    private String secretKey;
    private String merchantId;
    private Region region;
    private Environment environment;
    private CurrencyCode currencyCode;
    private String applicationName;
    private String applicationVersion;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean useAutoRetryOnThrottle;
    private String overrideServiceURL;
    private String overrideProfileURL;

    public PayConfig() {
    }

    public PayConfig(Properties prop) {
        this.loadConfigurationFromProperties(prop);
        this.checkIfRequriedPropertiesExist();
    }

    @Override
    public String getSellerId() {
        return this.merchantId;
    }

    @Override
    public void setSellerId(String merchantId) {
        this.merchantId = merchantId;
    }

    public PayConfig withSellerId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public PayConfig withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public PayConfig withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public void setRegion(Region region) {
        this.region = region;
    }

    public PayConfig withRegion(Region region) {
        this.region = region;
        return this;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public PayConfig withSandboxMode(boolean isSandbox) {
        this.environment = isSandbox ? Environment.SANDBOX : Environment.LIVE;
        return this;
    }

    @Override
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PayConfig withCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public PayConfig withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Override
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Override
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public PayConfig withApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public PayConfig withProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public PayConfig withProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public PayConfig withProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public PayConfig withProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    @Override
    public boolean isUseAutoRetryOnThrottle() {
        return this.useAutoRetryOnThrottle;
    }

    @Override
    public void setUseAutoRetryOnThrottle(boolean useAutoRetryOnThrottle) {
        this.useAutoRetryOnThrottle = useAutoRetryOnThrottle;
    }

    public PayConfig withUseAutoRetryOnThrottle(boolean useAutoRetryOnThrottle) {
        this.useAutoRetryOnThrottle = useAutoRetryOnThrottle;
        return this;
    }

    @Override
    public String getOverrideServiceURL() {
        return this.overrideServiceURL;
    }

    @Override
    public void setOverrideServiceURL(String overrideServiceURL) {
        this.overrideServiceURL = overrideServiceURL;
    }

    public PayConfig withOverrideServiceURL(String overrideServiceURL) {
        this.overrideServiceURL = overrideServiceURL;
        return this;
    }

    @Override
    public String getOverrideProfileURL() {
        return this.overrideProfileURL;
    }

    @Override
    public void setOverrideProfileURL(String overrideProfileURL) {
        this.overrideProfileURL = overrideProfileURL;
    }

    public PayConfig withOverrideProfileURL(String overrideProfileURL) {
        this.overrideProfileURL = overrideProfileURL;
        return this;
    }

    private PayConfig loadConfigurationFromProperties(Properties prop) {
        if (prop == null || prop.isEmpty()) {
            throw new IllegalArgumentException("Properties are empty, Need required propeties to proceed configuring amazon Pay client");
        }
        Enumeration<?> enumeration = prop.propertyNames();
        block19: while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            try {
                switch (Key.valueOf(property.toUpperCase())) {
                    case ACCESS_KEY: {
                        this.setAccessKey(prop.getProperty(property));
                        break;
                    }
                    case SECRET_KEY: {
                        this.setSecretKey(prop.getProperty(property));
                        break;
                    }
                    case MERCHANT_ID: {
                        this.setSellerId(prop.getProperty(property));
                        break;
                    }
                    case ENVIRONMENT: {
                        Environment env = Environment.valueOf(prop.getProperty(property).toUpperCase());
                        this.setEnvironment(env);
                        break;
                    }
                    case REGION: {
                        Region reg = Region.valueOf(prop.getProperty(property).toUpperCase());
                        this.setRegion(reg);
                        break;
                    }
                    case CURRENCY_CODE: {
                        CurrencyCode currency = CurrencyCode.valueOf(prop.getProperty(property).toUpperCase());
                        this.setCurrencyCode(currency);
                        break;
                    }
                    case PROXY_HOST: {
                        String proxyHostProperty = prop.getProperty(property);
                        this.setProxyHost(proxyHostProperty);
                        break;
                    }
                    case PROXY_PORT: {
                        String proxyPortProperty = prop.getProperty(property);
                        if (proxyPortProperty == null || proxyPortProperty.isEmpty()) continue block19;
                        this.setProxyPort(Integer.parseInt(proxyPortProperty));
                        break;
                    }
                    case PROXY_USERNAME: {
                        String proxyUsernameProperty = prop.getProperty(property);
                        this.setProxyUsername(proxyUsernameProperty);
                        break;
                    }
                    case PROXY_PASSWORD: {
                        String proxyPasswordProperty = prop.getProperty(property);
                        this.setProxyPassword(proxyPasswordProperty);
                        break;
                    }
                    case APPLICATION_NAME: {
                        String applicationNameProperty = prop.getProperty(property);
                        this.setApplicationName(applicationNameProperty);
                        break;
                    }
                    case APPLICATION_VERSION: {
                        String applicationVersionProperty = prop.getProperty(property);
                        this.setApplicationVersion(applicationVersionProperty);
                        break;
                    }
                    case AUTO_RETRY_ON_THROTTLE: {
                        String useAutoRetyOnThrottle = prop.getProperty(property);
                        this.setUseAutoRetryOnThrottle(Boolean.valueOf(useAutoRetyOnThrottle));
                        break;
                    }
                    case OVERRIDE_SERVICE_URL: {
                        String overrideServiceURL = prop.getProperty(property);
                        this.setOverrideServiceURL(overrideServiceURL);
                        break;
                    }
                    case OVERRIDE_PROFILE_URL: {
                        String overrideProfileURL = prop.getProperty(property);
                        this.setOverrideProfileURL(overrideProfileURL);
                        break;
                    }
                    default: {
                        throw new AmazonClientException("Client error, unable to set client configuration property [Key: " + property + ", Value: " + prop.getProperty(property) + "]. ");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to process client configuration parameter [Key: " + property + ", Value: " + prop.getProperty(property) + "]. ", e);
            }
        }
        return this;
    }

    private boolean checkIfRequriedPropertiesExist() {
        if (this.accessKey == null) {
            this.generateException(Key.ACCESS_KEY);
        } else if (this.secretKey == null) {
            this.generateException(Key.SECRET_KEY);
        } else if (this.merchantId == null) {
            this.generateException(Key.MERCHANT_ID);
        } else if (this.environment == null) {
            this.generateException(Key.ENVIRONMENT);
        } else if (this.region == null) {
            this.generateException(Key.REGION);
        } else if (this.currencyCode == null) {
            this.generateException(Key.CURRENCY_CODE);
        }
        return true;
    }

    private void generateException(Key propertyKey) {
        throw new IllegalArgumentException(propertyKey.toString() + " property is not set, this is a required property for Amazon Pay client configuration");
    }

    public String toString() {
        return "PayConfig{accessKeyId=" + this.accessKey + ", secretAccessKey=" + this.secretKey + ", sellerId=" + this.merchantId + ", region=" + (Object)((Object)this.region) + ", environment=" + (Object)((Object)this.environment) + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", applicationName=" + this.applicationName + ", applicationVersion=" + this.applicationVersion + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", useAutoRetryOnThrottle=" + this.useAutoRetryOnThrottle + ", overrideServiceURL=" + this.overrideServiceURL + ", overrideProfileURL=" + this.overrideProfileURL + "}";
    }
}

