/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.internal.model.PurchaseResponseBuilder;
import com.amazon.device.iap.model.Receipt;
import com.amazon.device.iap.model.RequestId;
import com.amazon.device.iap.model.UserData;
import org.json.JSONException;
import org.json.JSONObject;

public final class PurchaseResponse {
    private static final String USER_DATA = "userData";
    private static final String RECEIPT = "receipt";
    private static final String REQUEST_STATUS = "requestStatus";
    private static final String REQUEST_ID = "requestId";
    private static final String TO_STRING_FORMAT = "(%s, requestId: \"%s\", purchaseRequestStatus: \"%s\", userId: \"%s\", receipt: %s)";
    private final RequestId requestId;
    private final RequestStatus requestStatus;
    private final UserData userData;
    private final Receipt receipt;

    public PurchaseResponse(PurchaseResponseBuilder purchaseResponseBuilder) {
        f.a(purchaseResponseBuilder.getRequestId(), REQUEST_ID);
        f.a((Object)purchaseResponseBuilder.getRequestStatus(), REQUEST_STATUS);
        if (purchaseResponseBuilder.getRequestStatus() == RequestStatus.SUCCESSFUL) {
            f.a(purchaseResponseBuilder.getReceipt(), RECEIPT);
            f.a(purchaseResponseBuilder.getUserData(), USER_DATA);
        }
        this.requestId = purchaseResponseBuilder.getRequestId();
        this.userData = purchaseResponseBuilder.getUserData();
        this.receipt = purchaseResponseBuilder.getReceipt();
        this.requestStatus = purchaseResponseBuilder.getRequestStatus();
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public Receipt getReceipt() {
        return this.receipt;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public String toString() {
        return String.format(TO_STRING_FORMAT, super.toString(), this.requestId, this.requestStatus != null ? this.requestStatus.toString() : "null", this.userData, this.receipt);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(REQUEST_ID, (Object)this.requestId);
        jSONObject.put(REQUEST_STATUS, (Object)this.requestStatus);
        jSONObject.put(USER_DATA, this.userData != null ? this.userData.toJSON() : "");
        jSONObject.put(RECEIPT, this.getReceipt() != null ? this.getReceipt().toJSON() : "");
        return jSONObject;
    }

    public static enum RequestStatus {
        SUCCESSFUL,
        FAILED,
        INVALID_SKU,
        ALREADY_PURCHASED,
        PENDING,
        NOT_SUPPORTED;


        public static RequestStatus safeValueOf(String string) {
            if (f.a(string)) {
                return null;
            }
            if ("ALREADY_ENTITLED".equalsIgnoreCase(string)) {
                return ALREADY_PURCHASED;
            }
            return RequestStatus.valueOf(string.toUpperCase());
        }
    }
}

