/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.WebRequest;
import org.json.JSONObject;

class SISUpdateDeviceInfoRequest
extends SISDeviceRequest {
    private static final String LOGTAG = "SISUpdateDeviceInfoRequest";
    private static final Metrics.MetricType CALL_METRIC_TYPE = Metrics.MetricType.SIS_LATENCY_UPDATE_DEVICE_INFO;
    private static final String PATH = "/update_dev_info";
    private final DebugProperties debugPropertes;
    private final Metrics metrics;

    public SISUpdateDeviceInfoRequest(AdvertisingIdentifier advertisingIdentifier) {
        this(advertisingIdentifier, MobileAdsInfoStore.getInstance(), Configuration.getInstance(), DebugProperties.getInstance(), Metrics.getInstance());
    }

    SISUpdateDeviceInfoRequest(AdvertisingIdentifier advertisingIdentifier, MobileAdsInfoStore mobileAdsInfoStore, Configuration configuration, DebugProperties debugProperties, Metrics metrics) {
        super(new MobileAdsLoggerFactory(), LOGTAG, CALL_METRIC_TYPE, PATH, advertisingIdentifier, mobileAdsInfoStore, configuration);
        this.debugPropertes = debugProperties;
        this.metrics = metrics;
    }

    @Override
    public WebRequest.QueryStringParameters getQueryParameters() {
        String adId = this.debugPropertes.getDebugPropertyAsString("debug.adid", this.getAdvertisingIdentifierInfo().getSISDeviceIdentifier());
        WebRequest.QueryStringParameters baseQueryParameters = super.getQueryParameters();
        if (!StringUtils.isNullOrEmpty(adId)) {
            baseQueryParameters.putUrlEncoded("adId", adId);
        }
        return baseQueryParameters;
    }

    @Override
    public void onResponseReceived(JSONObject payload) {
        super.onResponseReceived(payload);
        boolean idChanged = JSONUtils.getBooleanFromJSON(payload, "idChanged", false);
        if (idChanged) {
            this.metrics.getMetricsCollector().incrementMetric(Metrics.MetricType.SIS_COUNTER_IDENTIFIED_DEVICE_CHANGED);
        }
    }
}

