/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.GooglePlayServices;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;

class GooglePlayServicesAdapter {
    private static final String LOGTAG = GooglePlayServicesAdapter.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    GooglePlayServicesAdapter() {
    }

    public GooglePlayServices.AdvertisingInfo getAdvertisingIdentifierInfo() {
        AdvertisingIdClient.Info info;
        Context context = MobileAdsInfoStore.getInstance().getApplicationContext();
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
        }
        catch (IllegalStateException e) {
            this.logger.e("The Google Play Services Advertising Identifier could not be retrieved: %s", e.getMessage());
            return new GooglePlayServices.AdvertisingInfo();
        }
        catch (IOException e) {
            this.logger.e("Retrieving the Google Play Services Advertising Identifier caused an IOException.");
            return new GooglePlayServices.AdvertisingInfo();
        }
        catch (GooglePlayServicesNotAvailableException e) {
            this.logger.v("Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesNotAvailableException.");
            return GooglePlayServices.AdvertisingInfo.createNotAvailable();
        }
        catch (GooglePlayServicesRepairableException e) {
            this.logger.v("Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesRepairableException.");
            return new GooglePlayServices.AdvertisingInfo();
        }
        catch (Exception e) {
            this.logger.v("Run time exception occured while retrieving Advertising Identifier:  %s", e.getMessage());
            return new GooglePlayServices.AdvertisingInfo();
        }
        this.logger.v("The Google Play Services Advertising Identifier was successfully retrieved.");
        if (info != null) {
            String advertisingId = info.getId();
            boolean limitAdTrackingEnabled = info.isLimitAdTrackingEnabled();
            return new GooglePlayServices.AdvertisingInfo().setAdvertisingIdentifier(advertisingId).setLimitAdTrackingEnabled(limitAdTrackingEnabled);
        }
        return new GooglePlayServices.AdvertisingInfo();
    }
}

