/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.SharedPreferences;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class GDPRInfo {
    private static final String LOGTAG = GDPRInfo.class.getSimpleName();
    private MobileAdsLogger logger;
    private SharedPreferences prefs;

    public GDPRInfo(SharedPreferences prefs) {
        this.prefs = prefs;
        this.logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    }

    public JSONObject toJsonObject() {
        return this.toJsonObject(this.prefs);
    }

    public JSONObject toJsonObject(SharedPreferences prefs) {
        String gdprSubject = prefs.getString("IABConsent_SubjectToGDPR", null);
        String apsSubject = prefs.getString("aps_gdpr_pub_pref_li", null);
        String gdprConsent = prefs.getString("IABConsent_ConsentString", null);
        String gdprSubject_tcf2 = prefs.getString("IABTCF_gdprApplies", null);
        String gdprConsent_tcf2 = prefs.getString("IABTCF_TCString", null);
        JSONObject reply = null;
        try {
            if (gdprSubject_tcf2 != null || gdprConsent_tcf2 != null) {
                reply = new JSONObject();
                if (gdprSubject_tcf2 != null) {
                    reply.put("e", (Object)gdprSubject_tcf2);
                }
                if (gdprConsent_tcf2 != null) {
                    reply.put("c", (Object)gdprConsent_tcf2);
                }
                return reply;
            }
            if (gdprConsent != null) {
                reply = new JSONObject();
                reply.put("c", (Object)gdprConsent);
            }
            if (gdprSubject != null) {
                gdprSubject = gdprSubject.trim();
                if (reply == null) {
                    reply = new JSONObject();
                }
                reply.put("e", (Object)gdprSubject);
            }
            if (apsSubject != null) {
                apsSubject = apsSubject.trim();
                if (reply == null) {
                    reply = new JSONObject();
                }
                reply.put("i", (Object)apsSubject);
            }
        }
        catch (JSONException ex) {
            this.logger.w("INVALID JSON formed for GDPR clause");
            reply = null;
        }
        return reply;
    }

    public String getGdprSubjectTcf2() {
        return this.prefs.getString("IABTCF_gdprApplies", null);
    }

    public String getGdprConsent_Tcf2() {
        return this.prefs.getString("IABTCF_TCString", null);
    }
}

