/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebRequest;

class ViewabilityJavascriptFetcher {
    private static final String LOGTAG = ViewabilityJavascriptFetcher.class.getSimpleName();
    private static final String CDN_URL = "https://dwxjayoxbnyrr.cloudfront.net/amazon-ads.viewablejs";
    private final MobileAdsLogger logger;
    private final PermissionChecker permissionChecker;
    private final WebRequest.WebRequestFactory webRequestFactory;
    private final Metrics metrics;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final Settings settings;
    private final MobileAdsInfoStore infoStore;
    private final DebugProperties debugProperties;
    private int currentJSVersion;
    private static ViewabilityJavascriptFetcher instance = new ViewabilityJavascriptFetcher();

    protected ViewabilityJavascriptFetcher() {
        this(new MobileAdsLoggerFactory(), new PermissionChecker(), DebugProperties.getInstance(), Settings.getInstance(), new WebRequest.WebRequestFactory(), Metrics.getInstance(), ThreadUtils.getThreadRunner(), MobileAdsInfoStore.getInstance());
    }

    ViewabilityJavascriptFetcher(MobileAdsLoggerFactory mobileAdsLoggerFactory, PermissionChecker permissionChecker, DebugProperties debugProperties, Settings settings, WebRequest.WebRequestFactory webRequestFactory, Metrics metrics, ThreadUtils.ThreadRunner threadRunner, MobileAdsInfoStore mobileAdsInfoStore) {
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(LOGTAG);
        this.permissionChecker = permissionChecker;
        this.debugProperties = debugProperties;
        this.settings = settings;
        this.webRequestFactory = webRequestFactory;
        this.metrics = metrics;
        this.threadRunner = threadRunner;
        this.infoStore = mobileAdsInfoStore;
    }

    private boolean shouldFetch() {
        this.currentJSVersion = this.settings.getInt(Configuration.ConfigOption.VIEWABLE_JS_VERSION_CONFIG.getSettingsName(), 0);
        if (this.settings.getInt("viewableJSVersionStored", -1) < this.currentJSVersion) {
            return true;
        }
        return StringUtils.isNullOrEmpty(this.settings.getString("viewableJSSettingsNameAmazonAdSDK", null));
    }

    public void fetchJavascript() {
        if (this.shouldFetch()) {
            this.beginFetch();
        }
    }

    protected void beginFetch() {
        this.threadRunner.execute(new Runnable(){

            public void run() {
                ViewabilityJavascriptFetcher.this.fetchJavascriptFromURLOnBackgroundThread();
            }
        }, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.BACKGROUND_THREAD);
    }

    public void fetchJavascriptFromURLOnBackgroundThread() {
        WebRequest.WebResponse webResponse;
        this.logger.d("In ViewabilityJavascriptFetcher background thread");
        boolean passesInternetPermissionCheck = this.permissionChecker.hasInternetPermission(this.infoStore.getApplicationContext());
        if (!passesInternetPermissionCheck) {
            this.logger.e("Network task cannot commence because the INTERNET permission is missing from the app's manifest.");
            this.onFetchFailure();
            return;
        }
        WebRequest webRequest = this.createWebRequest();
        if (webRequest == null) {
            this.onFetchFailure();
            return;
        }
        try {
            webResponse = webRequest.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            this.onFetchFailure();
            return;
        }
        String javascript = webResponse.getResponseReader().readAsString();
        this.settings.putString("viewableJSSettingsNameAmazonAdSDK", javascript);
        this.settings.putInt("viewableJSVersionStored", this.currentJSVersion);
        this.logger.d("Viewability Javascript fetched and saved");
    }

    protected WebRequest createWebRequest() {
        WebRequest webRequest = this.webRequestFactory.createWebRequest();
        webRequest.setExternalLogTag(LOGTAG);
        webRequest.enableLog(true);
        webRequest.setUrlString(this.settings.getString(Configuration.ConfigOption.VIEWABLE_JAVASCRIPT_URL.getSettingsName(), CDN_URL));
        webRequest.setMetricsCollector(this.metrics.getMetricsCollector());
        webRequest.setServiceCallLatencyMetric(Metrics.MetricType.CDN_JAVASCRIPT_DOWLOAD_LATENCY);
        webRequest.setUseSecure(this.debugProperties.getDebugPropertyAsBoolean("debug.aaxConfigUseSecure", true));
        return webRequest;
    }

    private void onFetchFailure() {
        this.metrics.getMetricsCollector().incrementMetric(Metrics.MetricType.CDN_JAVASCRIPT_DOWNLOAD_FAILED);
        this.logger.w("Viewability Javascript fetch failed");
    }

    public static final ViewabilityJavascriptFetcher getInstance() {
        return instance;
    }
}

