/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.StringUtils;

class Parsers {
    Parsers() {
    }

    public static class IntegerParser {
        private final MobileAdsLogger logger;
        private int defaultValue;
        private String parseErrorLogTag;
        private String parseErrorLogMessage;

        public IntegerParser() {
            this(new MobileAdsLoggerFactory());
        }

        IntegerParser(MobileAdsLoggerFactory loggerFactory) {
            this.logger = loggerFactory.createMobileAdsLogger("");
        }

        public IntegerParser setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public IntegerParser setParseErrorLogMessage(String parseErrorLogMessage) {
            this.parseErrorLogMessage = parseErrorLogMessage;
            return this;
        }

        public IntegerParser setParseErrorLogTag(String parseErrorLogTag) {
            this.parseErrorLogTag = parseErrorLogTag;
            this.logger.withLogTag(this.parseErrorLogTag);
            return this;
        }

        public int parse(String text) {
            int parsedValue;
            block3: {
                parsedValue = this.defaultValue;
                if (!StringUtils.isNullOrWhiteSpace(text)) {
                    try {
                        parsedValue = Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        if (this.parseErrorLogTag == null || this.parseErrorLogMessage == null) break block3;
                        this.logger.w(this.parseErrorLogMessage);
                    }
                }
            }
            return parsedValue;
        }
    }
}

