/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdCloser;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.ImageButtonFactory;
import com.amazon.device.ads.ImageViewFactory;
import com.amazon.device.ads.LayoutFactory;
import com.amazon.device.ads.RelativePosition;
import com.amazon.device.ads.ThreadUtils;

class NativeCloseButton {
    private static final int CLOSE_BUTTON_SIZE_DP = 60;
    private static final int CLOSE_BUTTON_TAP_TARGET_SIZE_DP = 80;
    private static final String CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON = "nativeCloseButton";
    private static final String CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON_IMAGE = "nativeCloseButtonImage";
    private static final String CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON_CONTAINER = "nativeCloseButtonContainer";
    private ImageView closeButtonImage;
    private ViewGroup closeButton;
    private ViewGroup closeButtonContainer;
    private final ViewGroup viewGroup;
    private final AdCloser adCloser;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final LayoutFactory layoutFactory;
    private final ImageViewFactory imageViewFactory;
    private boolean hasNativeCloseButton = false;

    public NativeCloseButton(ViewGroup viewGroup, AdCloser adCloser) {
        this(viewGroup, adCloser, ThreadUtils.getThreadRunner(), new LayoutFactory(), new ImageButtonFactory());
    }

    NativeCloseButton(ViewGroup viewGroup, AdCloser adCloser, ThreadUtils.ThreadRunner threadRunner, LayoutFactory layoutFactory, ImageViewFactory imageViewFactory) {
        this.viewGroup = viewGroup;
        this.adCloser = adCloser;
        this.threadRunner = threadRunner;
        this.layoutFactory = layoutFactory;
        this.imageViewFactory = imageViewFactory;
    }

    private Context getContext() {
        return this.viewGroup.getContext();
    }

    public void enable(final boolean showImage, final RelativePosition position) {
        this.hasNativeCloseButton = true;
        if (this.closeButton != null && this.closeButtonImage != null && this.viewGroup.equals(this.closeButton.getParent()) && (this.closeButton.equals(this.closeButtonImage.getParent()) || !showImage)) {
            if (!showImage) {
                this.hideImage();
            }
            return;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        final int buttonSize = (int)(60.0f * metrics.density + 0.5f);
        final int tapTargetSize = (int)(80.0f * metrics.density + 0.5f);
        ThreadUtils.MobileAdsAsyncTask<Void, Void, Void> closeButtonTask = new ThreadUtils.MobileAdsAsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... empty) {
                NativeCloseButton.this.createButtonIfNeeded(tapTargetSize);
                return null;
            }

            @Override
            protected void onPostExecute(Void result) {
                NativeCloseButton.this.addCloseButtonToTapTargetIfNeeded(showImage, position, buttonSize, tapTargetSize);
            }
        };
        this.threadRunner.executeAsyncTask(closeButtonTask, new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createButtonIfNeeded(int tapTargetSize) {
        boolean createButton = false;
        NativeCloseButton nativeCloseButton = this;
        synchronized (nativeCloseButton) {
            if (this.closeButton == null) {
                this.closeButton = this.layoutFactory.createLayout(this.getContext(), LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON);
                this.closeButtonImage = this.imageViewFactory.createImageView(this.getContext(), CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON_IMAGE);
                createButton = true;
            }
        }
        if (createButton) {
            final BitmapDrawable closeNormal = this.imageViewFactory.createBitmapDrawable(this.getContext().getResources(), Assets.getInstance().getFilePath("amazon_ads_close_normal.png"));
            final BitmapDrawable closePressed = this.imageViewFactory.createBitmapDrawable(this.getContext().getResources(), Assets.getInstance().getFilePath("amazon_ads_close_pressed.png"));
            this.closeButtonImage.setImageDrawable((Drawable)closeNormal);
            this.closeButtonImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.closeButtonImage.setBackgroundDrawable(null);
            View.OnClickListener onClickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    NativeCloseButton.this.closeAd();
                }
            };
            this.closeButtonImage.setOnClickListener(onClickListener);
            this.closeButton.setOnClickListener(onClickListener);
            View.OnTouchListener onTouchListener = new View.OnTouchListener(){

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View v, MotionEvent event) {
                    NativeCloseButton.this.animateCloseButton(event, closeNormal, closePressed);
                    return false;
                }
            };
            this.closeButton.setOnTouchListener(onTouchListener);
            this.closeButtonImage.setOnTouchListener(onTouchListener);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(tapTargetSize, tapTargetSize);
            layoutParams.addRule(11);
            layoutParams.addRule(10);
            this.closeButtonContainer = this.layoutFactory.createLayout(this.getContext(), LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_NATIVE_CLOSE_BUTTON_CONTAINER);
            this.closeButtonContainer.addView((View)this.closeButton, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void closeAd() {
        this.adCloser.closeAd();
    }

    private void animateCloseButton(MotionEvent motionEvent, BitmapDrawable closeNormal, BitmapDrawable closePressed) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.closeButtonImage.setImageDrawable((Drawable)closePressed);
                break;
            }
            case 1: {
                this.closeButtonImage.setImageDrawable((Drawable)closeNormal);
            }
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void addCloseButtonToTapTargetIfNeeded(boolean showImage, RelativePosition position, int buttonSize, int tapTargetSize) {
        RelativeLayout.LayoutParams params;
        if (showImage && !this.closeButton.equals(this.closeButtonImage.getParent())) {
            params = new RelativeLayout.LayoutParams(buttonSize, buttonSize);
            params.addRule(13);
            this.closeButton.addView((View)this.closeButtonImage, (ViewGroup.LayoutParams)params);
        } else if (!showImage && this.closeButton.equals(this.closeButtonImage.getParent())) {
            this.closeButton.removeView((View)this.closeButtonImage);
        }
        if (!this.viewGroup.equals(this.closeButtonContainer.getParent())) {
            this.viewGroup.addView((View)this.closeButtonContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        params = new RelativeLayout.LayoutParams(tapTargetSize, tapTargetSize);
        RelativePosition p = position;
        if (position == null) {
            p = RelativePosition.TOP_RIGHT;
        }
        switch (p) {
            case BOTTOM_CENTER: {
                params.addRule(12);
                params.addRule(14);
                break;
            }
            case BOTTOM_LEFT: {
                params.addRule(12);
                params.addRule(9);
                break;
            }
            case BOTTOM_RIGHT: {
                params.addRule(12);
                params.addRule(11);
                break;
            }
            case CENTER: {
                params.addRule(13);
                break;
            }
            case TOP_CENTER: {
                params.addRule(10);
                params.addRule(14);
                break;
            }
            case TOP_LEFT: {
                params.addRule(10);
                params.addRule(9);
                break;
            }
            case TOP_RIGHT: {
                params.addRule(10);
                params.addRule(11);
                break;
            }
            default: {
                params.addRule(10);
                params.addRule(11);
            }
        }
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.closeButtonContainer.bringToFront();
    }

    public void remove() {
        this.hasNativeCloseButton = false;
        this.threadRunner.execute(new Runnable(){

            public void run() {
                NativeCloseButton.this.removeNativeCloseButtonOnMainThread();
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    private void removeNativeCloseButtonOnMainThread() {
        this.viewGroup.removeView((View)this.closeButtonContainer);
    }

    public void showImage(boolean show) {
        if (this.hasNativeCloseButton && this.closeButton != null) {
            if (show) {
                this.enable(true, null);
            } else {
                this.hideImage();
            }
        }
    }

    private void hideImage() {
        this.threadRunner.execute(new Runnable(){

            public void run() {
                NativeCloseButton.this.hideImageOnMainThread();
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    private void hideImageOnMainThread() {
        this.closeButton.removeAllViews();
    }
}

