/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.view.ViewTreeObserver;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.MRAIDAdSDKBridge;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Position;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.SDKEventListener;

class MRAIDAdSDKEventListener
implements SDKEventListener {
    private static final String LOGTAG = MRAIDAdSDKEventListener.class.getSimpleName();
    private MRAIDAdSDKBridge mraidAdSDKBridge;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    MRAIDAdSDKEventListener(MRAIDAdSDKBridge adBridge) {
        this.mraidAdSDKBridge = adBridge;
    }

    public void onSDKEvent(SDKEvent sdkEvent, AdControlAccessor adControlAccessor) {
        this.logger.d(sdkEvent.getEventType().toString());
        switch (sdkEvent.getEventType()) {
            case RENDERED: {
                break;
            }
            case PLACED: {
                this.handleDefaultEvent(adControlAccessor);
                this.handleReadyEvent(adControlAccessor);
                break;
            }
            case VISIBLE: {
                this.handleShowingEvent(adControlAccessor);
                this.handleDefaultEvent(adControlAccessor);
                this.handleReadyEvent(adControlAccessor);
                break;
            }
            case CLOSED: {
                this.handleClosedEvent(adControlAccessor);
                break;
            }
            case RESIZED: {
                this.mraidAdSDKBridge.reportSizeChangeEvent();
                break;
            }
            case HIDDEN: 
            case DESTROYED: {
                adControlAccessor.injectJavascript("mraidBridge.stateChange('hidden');");
                break;
            }
            case BRIDGE_ADDED: {
                this.handleBridgeAddedEvent(sdkEvent, adControlAccessor);
                break;
            }
            case VIEWABLE: {
                this.handleViewableEvent(sdkEvent, adControlAccessor);
                break;
            }
        }
    }

    private void handleViewableEvent(SDKEvent sdkEvent, AdControlAccessor adControlAccessor) {
        String isViewable = sdkEvent.getParameter("IS_VIEWABLE");
        adControlAccessor.injectJavascript("mraidBridge.viewableChange(" + isViewable + ");");
    }

    private void handleBridgeAddedEvent(SDKEvent sdkEvent, AdControlAccessor adControlAccessor) {
        String bridgeName = sdkEvent.getParameter("bridgeName");
        if (bridgeName != null && bridgeName.equals(this.mraidAdSDKBridge.getName())) {
            switch (adControlAccessor.getAdState()) {
                case EXPANDED: 
                case SHOWING: {
                    this.handleShowingEvent(adControlAccessor);
                    this.handleDefaultEvent(adControlAccessor);
                    this.handleReadyEvent(adControlAccessor);
                    break;
                }
                case RENDERED: {
                    if (adControlAccessor.isModal()) break;
                    this.handleDefaultEvent(adControlAccessor);
                    this.handleReadyEvent(adControlAccessor);
                    break;
                }
            }
        }
    }

    private void handleReadyEvent(AdControlAccessor adControlAccessor) {
        adControlAccessor.injectJavascript("mraidBridge.ready();");
    }

    private void handleShowingEvent(final AdControlAccessor adControlAccessor) {
        adControlAccessor.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Position currentPosition = adControlAccessor.getCurrentPosition();
                if (currentPosition != null) {
                    adControlAccessor.removeOnGlobalLayoutListener(this);
                    MRAIDAdSDKEventListener.this.mraidAdSDKBridge.updateDefaultPosition(currentPosition.getSize().getWidth(), currentPosition.getSize().getHeight(), currentPosition.getX(), currentPosition.getY());
                    MRAIDAdSDKEventListener.this.mraidAdSDKBridge.orientationPropertyChange();
                }
            }
        });
    }

    private void handleDefaultEvent(AdControlAccessor adControlAccessor) {
        adControlAccessor.injectJavascript("mraidBridge.stateChange('default');");
    }

    private void handleClosedEvent(AdControlAccessor adControlAccessor) {
        if (adControlAccessor.getAdState().equals((Object)AdState.EXPANDED)) {
            this.mraidAdSDKBridge.collapseExpandedAd(adControlAccessor);
        } else if (adControlAccessor.getAdState().equals((Object)AdState.SHOWING)) {
            adControlAccessor.injectJavascript("mraidBridge.stateChange('hidden');");
            adControlAccessor.injectJavascript("mraidBridge.viewableChange('false');");
        }
    }
}

