/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONUtils {
    JSONUtils() {
    }

    public static boolean getBooleanFromJSON(JSONObject json, String key, boolean defaultValue) {
        if (json.isNull(key)) {
            return defaultValue;
        }
        boolean ret = json.optBoolean(key, defaultValue);
        return ret;
    }

    public static String getStringFromJSON(JSONObject json, String key, String defaultValue) {
        if (json.isNull(key)) {
            return defaultValue;
        }
        String ret = json.optString(key, defaultValue);
        return ret;
    }

    public static int getIntegerFromJSON(JSONObject json, String key, int defaultValue) {
        if (json.isNull(key)) {
            return defaultValue;
        }
        int ret = json.optInt(key, defaultValue);
        return ret;
    }

    public static long getLongFromJSON(JSONObject json, String key, long defaultValue) {
        if (json.isNull(key)) {
            return defaultValue;
        }
        long ret = json.optLong(key, defaultValue);
        return ret;
    }

    public static JSONArray getJSONArrayFromJSON(JSONObject json, String key) {
        if (json.isNull(key)) {
            return null;
        }
        JSONArray ret = json.optJSONArray(key);
        return ret;
    }

    public static int getIntegerFromJSONArray(JSONArray jsonArray, int index, int defaultValue) {
        if (jsonArray.isNull(index)) {
            return defaultValue;
        }
        int ret = jsonArray.optInt(index, defaultValue);
        return ret;
    }

    public static JSONObject getJSONObjectFromJSONArray(JSONArray jsonArray, int index) {
        if (jsonArray.isNull(index)) {
            return null;
        }
        try {
            return jsonArray.getJSONObject(index);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static void put(JSONObject json, String key, String value) {
        if (value != null && !value.equals("")) {
            try {
                json.put(key, (Object)value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static void put(JSONObject json, String key, int value) {
        try {
            json.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void put(JSONObject json, String key, long value) {
        try {
            json.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void put(JSONObject json, String key, boolean value) {
        try {
            json.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static JSONObject getJSONObjectFromString(String str) {
        try {
            return new JSONObject(str);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Map<String, String> createMapFromJSON(JSONObject json) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keysItr = json.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            String value = JSONUtils.getStringFromJSON(json, key, null);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONUtilities {
        public boolean getBooleanFromJSON(JSONObject json, String key, boolean defaultValue) {
            return JSONUtils.getBooleanFromJSON(json, key, defaultValue);
        }

        public String getStringFromJSON(JSONObject json, String key, String defaultValue) {
            return JSONUtils.getStringFromJSON(json, key, defaultValue);
        }

        public int getIntegerFromJSON(JSONObject json, String key, int defaultValue) {
            return JSONUtils.getIntegerFromJSON(json, key, defaultValue);
        }

        public long getLongFromJSON(JSONObject json, String key, long defaultValue) {
            return JSONUtils.getLongFromJSON(json, key, defaultValue);
        }

        public JSONArray getJSONArrayFromJSON(JSONObject json, String key) {
            return JSONUtils.getJSONArrayFromJSON(json, key);
        }

        public int getIntegerFromJSONArray(JSONArray jsonArray, int index, int defaultValue) {
            return JSONUtils.getIntegerFromJSONArray(jsonArray, index, defaultValue);
        }

        public JSONObject getJSONObjectFromJSONArray(JSONArray jsonArray, int index) {
            return JSONUtils.getJSONObjectFromJSONArray(jsonArray, index);
        }

        public Map<String, String> createMapFromJSON(JSONObject json) {
            return JSONUtils.createMapFromJSON(json);
        }

        public void put(JSONObject json, String key, String value) {
            JSONUtils.put(json, key, value);
        }

        public void put(JSONObject json, String key, int value) {
            JSONUtils.put(json, key, value);
        }

        public void put(JSONObject json, String key, long value) {
            JSONUtils.put(json, key, value);
        }

        public void put(JSONObject json, String key, boolean value) {
            JSONUtils.put(json, key, value);
        }

        public JSONObject getJSONObjectFromString(String str) {
            return JSONUtils.getJSONObjectFromString(str);
        }
    }
}

