/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.view.ViewGroup;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.InterstitialAd;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.SDKEventListener;

@SuppressLint(value={"NewApi"})
class InterstitialAdActivityAdapter
implements AdActivity.AdActivityAdapter {
    private static final String LOGTAG = InterstitialAdActivityAdapter.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private final AndroidBuildInfo buildInfo = new AndroidBuildInfo();
    private Activity activity = null;
    private AdController adController;

    InterstitialAdActivityAdapter() {
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void preOnCreate() {
        this.activity.requestWindowFeature(1);
        this.activity.getWindow().setFlags(1024, 1024);
        AndroidTargetUtils.hideActionAndStatusBars(this.buildInfo, this.activity);
    }

    public void onCreate() {
        AndroidTargetUtils.enableHardwareAcceleration(this.buildInfo, this.activity.getWindow());
        this.adController = this.getAdController();
        if (this.adController == null) {
            this.logger.e("Failed to show interstitial ad due to an error in the Activity.");
            InterstitialAd.resetIsAdShowing();
            this.activity.finish();
            return;
        }
        this.adController.setAdActivity(this.activity);
        this.adController.addSDKEventListener(new InterstitialAdSDKEventListener());
        ViewGroup parent = (ViewGroup)this.adController.getView().getParent();
        if (parent != null) {
            parent.removeView(this.adController.getView());
        }
        this.activity.setContentView(this.adController.getView());
        this.adController.adShown();
    }

    AdController getAdController() {
        return AdControllerFactory.getCachedAdController();
    }

    public void onPause() {
        if (this.adController != null) {
            this.adController.fireViewableEvent();
        }
    }

    public void onResume() {
    }

    public void onStop() {
        if (this.activity.isFinishing() && this.adController != null) {
            this.adController.fireViewableEvent();
            this.adController.closeAd();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public boolean onBackPressed() {
        if (this.adController != null) {
            return this.adController.onBackButtonPress();
        }
        return false;
    }

    public void onWindowFocusChanged() {
        if (this.adController != null) {
            this.adController.fireViewableEvent();
        }
    }

    Activity getActivity() {
        return this.activity;
    }

    private void finishActivity() {
        if (!this.activity.isFinishing()) {
            this.adController = null;
            this.activity.finish();
        }
    }

    class InterstitialAdSDKEventListener
    implements SDKEventListener {
        InterstitialAdSDKEventListener() {
        }

        public void onSDKEvent(SDKEvent sdkEvent, AdControlAccessor controller) {
            if (sdkEvent.getEventType().equals((Object)SDKEvent.SDKEventType.CLOSED)) {
                InterstitialAdActivityAdapter.this.finishActivity();
            }
        }
    }
}

