/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.FileHandler;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class FileOutputHandler
extends FileHandler {
    private static final String LOGTAG = FileOutputHandler.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private OutputStream outputStream;
    private BufferedWriter bufferedWriter;
    private WriteMethod writeMethod;

    FileOutputHandler() {
    }

    public boolean isOpen() {
        return this.outputStream != null;
    }

    public boolean open(WriteMethod writeMethod) {
        FileOutputStream fos;
        if (this.file == null) {
            this.logger.e("A file must be set before it can be opened.");
            return false;
        }
        if (this.outputStream != null) {
            this.logger.e("The file is already open.");
            return false;
        }
        try {
            fos = new FileOutputStream(this.file, WriteMethod.APPEND.equals((Object)writeMethod));
        }
        catch (Exception e) {
            return false;
        }
        this.writeMethod = writeMethod;
        this.outputStream = new BufferedOutputStream(fos);
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.outputStream));
        return true;
    }

    public void close() {
        this.flush();
        this.closeCloseables();
        this.bufferedWriter = null;
        this.outputStream = null;
    }

    public void flush() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                this.logger.e("Could not flush the OutputStream. %s", e.getMessage());
            }
        }
        if (this.bufferedWriter != null) {
            try {
                this.bufferedWriter.flush();
            }
            catch (IOException e) {
                this.logger.e("Could not flush the BufferedWriter. %s", e.getMessage());
            }
        }
    }

    protected Closeable getCloseableStream() {
        return this.outputStream;
    }

    protected Closeable getCloseableReaderWriter() {
        return this.bufferedWriter;
    }

    private void checkWritable() {
        if (this.bufferedWriter == null) {
            throw new IllegalStateException("Could not write to the file because no file has been opened yet. Please set the file, then call open() before attempting to write.");
        }
    }

    public void write(String str) throws IOException {
        this.checkWritable();
        this.bufferedWriter.write(str);
    }

    public void write(byte[] buffer) throws IOException {
        this.checkWritable();
        this.outputStream.write(buffer);
    }

    public boolean overwriteFile(String data) {
        return this.writeToFile(data, WriteMethod.OVERWRITE);
    }

    public boolean appendToFile(String data) {
        return this.writeToFile(data, WriteMethod.APPEND);
    }

    private boolean writeToFile(String data, WriteMethod writeMethod) {
        if (this.isOpen()) {
            if (!writeMethod.equals((Object)this.writeMethod)) {
                this.close();
                if (!this.open(writeMethod)) {
                    this.logger.e("Could not reopen the file for %s.", writeMethod.toString());
                    return false;
                }
            }
        } else if (!this.open(writeMethod)) {
            this.logger.e("Could not open the file for writing.");
            return false;
        }
        try {
            this.write(data);
        }
        catch (IOException e) {
            this.logger.e("Failed to write data to the file.");
            return false;
        }
        this.close();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriteMethod {
        APPEND,
        OVERWRITE;

    }
}

