/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.FileHandler;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class FileInputHandler
extends FileHandler {
    private static final String LOGTAG = FileInputHandler.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private InputStream inputStream;
    private BufferedReader bufferedReader;

    FileInputHandler() {
    }

    public boolean isOpen() {
        return this.inputStream != null;
    }

    public boolean open() {
        FileInputStream fos;
        if (this.file == null) {
            this.logger.e("A file must be set before it can be opened.");
            return false;
        }
        if (this.inputStream != null) {
            this.logger.e("The file is already open.");
            return false;
        }
        try {
            fos = new FileInputStream(this.file);
        }
        catch (Exception e) {
            return false;
        }
        this.inputStream = new BufferedInputStream(fos);
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
        return true;
    }

    public void close() {
        this.closeCloseables();
        this.bufferedReader = null;
        this.inputStream = null;
    }

    protected Closeable getCloseableStream() {
        return this.inputStream;
    }

    protected Closeable getCloseableReaderWriter() {
        return this.bufferedReader;
    }

    private void checkReadable() {
        if (this.bufferedReader == null) {
            throw new IllegalStateException("Could not read from the file because no file has been opened yet. Please set the file, then call open() before attempting to read.");
        }
    }

    public byte[] readBytes() {
        this.checkReadable();
        try {
            int totalBytesRead = 0;
            byte[] data = new byte[(int)this.file.length()];
            while (totalBytesRead < data.length) {
                int bytesRemaining = data.length - totalBytesRead;
                int bytesRead = this.inputStream.read(data, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            return data;
        }
        catch (IOException e) {
            this.logger.e("Error reading bytes from input file: %s", e.getMessage());
            return null;
        }
    }

    public byte[] readAllBytesFromFileAndClose() {
        if (!this.isOpen() && !this.open()) {
            this.logger.e("Could not open the file for reading");
            return null;
        }
        byte[] data = this.readBytes();
        this.close();
        return data;
    }

    public String readLine() {
        this.checkReadable();
        try {
            return this.bufferedReader.readLine();
        }
        catch (IOException e) {
            this.logger.e("Error reading line from file.");
            return null;
        }
    }
}

