/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.UserAgentManager;
import com.amazon.device.ads.Version;

class AdRegistrationExecutor {
    private final MobileAdsInfoStore infoStore;
    private final Settings settings;
    private final PermissionChecker permissionChecker;
    private final MobileAdsLogger logger;
    private final MobileAdsLoggerFactory loggerFactory;
    private volatile boolean isInitialized = false;

    public AdRegistrationExecutor(String logtag) {
        this(logtag, MobileAdsInfoStore.getInstance(), Settings.getInstance(), new MobileAdsLoggerFactory(), new PermissionChecker());
    }

    AdRegistrationExecutor(String logtag, MobileAdsInfoStore infoStore, Settings settings, MobileAdsLoggerFactory loggerFactory, PermissionChecker permissionChecker) {
        this.infoStore = infoStore;
        this.settings = settings;
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(logtag);
        this.permissionChecker = permissionChecker;
    }

    public void setAppKey(String appKey) throws IllegalArgumentException {
        this.infoStore.getRegistrationInfo().putAppKey(appKey);
    }

    public void enableLogging(boolean enable) {
        this.logger.enableLoggingWithSetterNotification(enable);
    }

    public void enableTesting(boolean enable) {
        this.settings.putTransientBoolean("testingEnabled", enable);
        this.logger.logSetterNotification("Test mode", enable);
    }

    public String getVersion() {
        return Version.getSDKVersion();
    }

    public void registerApp(Context context) {
        if (!this.permissionChecker.hasInternetPermission(context)) {
            this.logger.e("Network task cannot commence because the INTERNET permission is missing from the app's manifest.");
            return;
        }
        this.initializeAds(context);
        this.infoStore.register();
    }

    public void initializeAds(Context context) {
        if (!this.isInitialized) {
            this.infoStore.contextReceived(context);
            this.infoStore.getDeviceInfo().setUserAgentManager(new UserAgentManager());
            this.isInitialized = true;
        }
    }

    MobileAdsInfoStore getMobileAdsInfoStore() {
        return this.infoStore;
    }

    Settings getSettings() {
        return this.settings;
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    MobileAdsLogger getLogger() {
        return this.logger;
    }

    MobileAdsLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }
}

