/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXParameter;
import com.amazon.device.ads.AAXParameterGroupParameter;
import com.amazon.device.ads.AdvertisingIdentifierAAXParameter;
import com.amazon.device.ads.DirectedIdAAXParameter;
import com.amazon.device.ads.SHA1UDIDAAXParameter;
import com.amazon.device.ads.SISDeviceIdentifierAAXParameter;
import org.json.JSONObject;

abstract class AAXParameterGroup {
    public static final UserIdAAXParameterGroup USER_ID = new UserIdAAXParameterGroup();

    AAXParameterGroup() {
    }

    public abstract void evaluate(AAXParameter.ParameterData var1, JSONObject var2);

    static final class UserIdAAXParameterGroup
    extends AAXParameterGroup {
        private final DirectedIdAAXParameter directedIdParameter;
        private final AdvertisingIdentifierAAXParameter idfaParameter;
        private final SISDeviceIdentifierAAXParameter adIdParameter;
        private final SHA1UDIDAAXParameter sha1udidParameter;

        UserIdAAXParameterGroup() {
            this(AAXParameterGroupParameter.DIRECTED_ID, AAXParameterGroupParameter.ADVERTISING_IDENTIFIER, AAXParameterGroupParameter.SIS_DEVICE_IDENTIFIER, AAXParameterGroupParameter.SHA1_UDID);
        }

        UserIdAAXParameterGroup(DirectedIdAAXParameter directedIdParameter, AdvertisingIdentifierAAXParameter idfaParameter, SISDeviceIdentifierAAXParameter adIdParameter, SHA1UDIDAAXParameter sha1udidParameter) {
            this.directedIdParameter = directedIdParameter;
            this.idfaParameter = idfaParameter;
            this.adIdParameter = adIdParameter;
            this.sha1udidParameter = sha1udidParameter;
        }

        public void evaluate(AAXParameter.ParameterData parameterData, JSONObject jsonObject) {
            boolean directedId = this.directedIdParameter.evaluate(parameterData, jsonObject);
            if (directedId) {
                return;
            }
            boolean idfa = this.idfaParameter.evaluate(parameterData, jsonObject);
            if (!idfa) {
                this.sha1udidParameter.evaluate(parameterData, jsonObject);
            }
            this.adIdParameter.evaluate(parameterData, jsonObject);
        }
    }
}

