/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.os.Looper;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.robolectric.RobolectricUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Supplier;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class TestPlayerRunHelper {
    private TestPlayerRunHelper() {
    }

    public static void runUntilPlaybackState(Player player, int expectedState) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player instanceof ExoPlayer) {
            TestPlayerRunHelper.verifyPlaybackThreadIsAlive((ExoPlayer)player);
        }
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> player.getPlaybackState() == expectedState || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void runUntilPlayWhenReady(Player player, boolean expectedPlayWhenReady) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player instanceof ExoPlayer) {
            TestPlayerRunHelper.verifyPlaybackThreadIsAlive((ExoPlayer)player);
        }
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> player.getPlayWhenReady() == expectedPlayWhenReady || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void runUntilIsLoading(Player player, boolean expectedIsLoading) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player instanceof ExoPlayer) {
            TestPlayerRunHelper.verifyPlaybackThreadIsAlive((ExoPlayer)player);
        }
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> player.isLoading() == expectedIsLoading || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void runUntilTimelineChanged(Player player, Timeline expectedTimeline) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player instanceof ExoPlayer) {
            TestPlayerRunHelper.verifyPlaybackThreadIsAlive((ExoPlayer)player);
        }
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> expectedTimeline.equals((Object)player.getCurrentTimeline()) || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static Timeline runUntilTimelineChanged(Player player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicReference<@NullableType V> receivedTimeline = new AtomicReference();
        Player.Listener listener = new Player.Listener(){

            public void onTimelineChanged(Timeline timeline, int reason) {
                receivedTimeline.set(timeline);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receivedTimeline.get() != null || player.getPlayerError() != null));
        player.removeListener(listener);
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
        return (Timeline)Assertions.checkNotNull((Object)((Timeline)receivedTimeline.get()));
    }

    public static void runUntilPositionDiscontinuity(Player player, final int expectedReason) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player instanceof ExoPlayer) {
            TestPlayerRunHelper.verifyPlaybackThreadIsAlive((ExoPlayer)player);
        }
        final AtomicBoolean receivedCallback = new AtomicBoolean(false);
        Player.Listener listener = new Player.Listener(){

            public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
                if (reason == expectedReason) {
                    receivedCallback.set(true);
                }
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receivedCallback.get() || player.getPlayerError() != null));
        player.removeListener(listener);
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static ExoPlaybackException runUntilError(ExoPlayer player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        TestPlayerRunHelper.verifyPlaybackThreadIsAlive(player);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> player.getPlayerError() != null));
        return (ExoPlaybackException)Assertions.checkNotNull((Object)player.getPlayerError());
    }

    public static void runUntilSleepingForOffload(ExoPlayer player, final boolean expectedSleepForOffload) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        TestPlayerRunHelper.verifyPlaybackThreadIsAlive(player);
        final AtomicBoolean receiverCallback = new AtomicBoolean(false);
        ExoPlayer.AudioOffloadListener listener = new ExoPlayer.AudioOffloadListener(){

            public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
                if (sleepingForOffload == expectedSleepForOffload) {
                    receiverCallback.set(true);
                }
            }
        };
        player.addAudioOffloadListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receiverCallback.get() || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void runUntilRenderedFirstFrame(ExoPlayer player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        TestPlayerRunHelper.verifyPlaybackThreadIsAlive(player);
        final AtomicBoolean receivedCallback = new AtomicBoolean(false);
        Player.Listener listener = new Player.Listener(){

            public void onRenderedFirstFrame() {
                receivedCallback.set(true);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receivedCallback.get() || player.getPlayerError() != null));
        player.removeListener(listener);
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void playUntilPosition(ExoPlayer player, int mediaItemIndex, long positionMs) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        TestPlayerRunHelper.verifyPlaybackThreadIsAlive(player);
        Looper applicationLooper = Util.getCurrentOrMainLooper();
        AtomicBoolean messageHandled = new AtomicBoolean(false);
        player.createMessage((messageType, payload) -> {
            ConditionVariable blockPlaybackThreadCondition = new ConditionVariable();
            player.getClock().createHandler(applicationLooper, null).post(() -> {
                player.pause();
                messageHandled.set(true);
                blockPlaybackThreadCondition.open();
            });
            try {
                player.getClock().onThreadBlocked();
                blockPlaybackThreadCondition.block();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).setPosition(mediaItemIndex, positionMs).send();
        player.play();
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> messageHandled.get() || player.getPlayerError() != null));
        if (player.getPlayerError() != null) {
            throw new IllegalStateException((Throwable)player.getPlayerError());
        }
    }

    public static void playUntilStartOfMediaItem(ExoPlayer player, int mediaItemIndex) throws TimeoutException {
        TestPlayerRunHelper.playUntilPosition(player, mediaItemIndex, 0L);
    }

    public static void runUntilPendingCommandsAreFullyHandled(ExoPlayer player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        TestPlayerRunHelper.verifyPlaybackThreadIsAlive(player);
        AtomicBoolean receivedMessageCallback = new AtomicBoolean(false);
        player.createMessage((type, data) -> receivedMessageCallback.set(true)).setLooper(Util.getCurrentOrMainLooper()).send();
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedMessageCallback::get));
    }

    private static void verifyMainTestThread(Player player) {
        if (Looper.myLooper() != Looper.getMainLooper() || player.getApplicationLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException();
        }
    }

    private static void verifyPlaybackThreadIsAlive(ExoPlayer player) {
        Assertions.checkState((boolean)player.getPlaybackLooper().getThread().isAlive(), (Object)"Playback thread is not alive, has the player been released?");
    }
}

