/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.os.Looper;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.SystemClock;
import com.google.common.base.Supplier;
import java.util.concurrent.TimeoutException;
import org.robolectric.Shadows;
import org.robolectric.shadows.ShadowLooper;

public final class RobolectricUtil {
    public static final long DEFAULT_TIMEOUT_MS = 10000L;

    private RobolectricUtil() {
    }

    public static ConditionVariable createRobolectricConditionVariable() {
        return new ConditionVariable((Clock)new SystemClock(){

            public long elapsedRealtime() {
                return Clock.DEFAULT.currentTimeMillis();
            }
        });
    }

    public static void runMainLooperUntil(Supplier<Boolean> condition) throws TimeoutException {
        RobolectricUtil.runMainLooperUntil(condition, 10000L, Clock.DEFAULT);
    }

    public static void runMainLooperUntil(Supplier<Boolean> condition, long timeoutMs, Clock clock) throws TimeoutException {
        RobolectricUtil.runLooperUntil(Looper.getMainLooper(), condition, timeoutMs, clock);
    }

    public static void runLooperUntil(Looper looper, Supplier<Boolean> condition) throws TimeoutException {
        RobolectricUtil.runLooperUntil(looper, condition, 10000L, Clock.DEFAULT);
    }

    public static void runLooperUntil(Looper looper, Supplier<Boolean> condition, long timeoutMs, Clock clock) throws TimeoutException {
        if (Looper.myLooper() != looper) {
            throw new IllegalStateException();
        }
        ShadowLooper shadowLooper = Shadows.shadowOf((Looper)looper);
        long timeoutTimeMs = clock.currentTimeMillis() + timeoutMs;
        while (!((Boolean)condition.get()).booleanValue()) {
            if (clock.currentTimeMillis() >= timeoutTimeMs) {
                throw new TimeoutException();
            }
            shadowLooper.runOneTask();
        }
    }
}

