/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.testutil.TestUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.shadows.ShadowMediaCodec;

@RequiresApi(value=29)
public final class RandomizedMp3Decoder
implements ShadowMediaCodec.CodecConfig.Codec {
    private final List<byte[]> decoderOutput = new ArrayList<byte[]>();
    private int frameSizeInBytes;

    public void process(ByteBuffer in, ByteBuffer out) {
        if (in.remaining() == 0) {
            return;
        }
        Assertions.checkState((in.remaining() >= 4 ? 1 : 0) != 0, (Object)"Frame size too small, should be at least 4 to hold an MP3 header");
        int headerDataBigEndian = Util.getBigEndianInt((ByteBuffer)in, (int)in.position());
        int frameCount = MpegAudioUtil.parseMpegAudioFrameSampleCount((int)headerDataBigEndian);
        int expectedNumBytes = frameCount * this.frameSizeInBytes;
        byte[] bytesToWrite = TestUtil.buildTestData((int)expectedNumBytes);
        out.put(bytesToWrite);
        this.decoderOutput.add(bytesToWrite);
        in.position(in.limit());
    }

    public void onConfigured(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        int pcmEncoding = format.getInteger("pcm-encoding", 2);
        int channelCount = format.getInteger("channel-count");
        Assertions.checkArgument((boolean)format.getString("mime", "audio/mpeg").equals("audio/mpeg"));
        this.frameSizeInBytes = Util.getPcmFrameSize((int)pcmEncoding, (int)channelCount);
    }

    public ImmutableList<byte[]> getAllOutputBytes() {
        return ImmutableList.copyOf(this.decoderOutput);
    }
}

