/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.robolectric.RobolectricUtil;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public final class TestDownloadManagerListener
implements DownloadManager.Listener {
    private static final int TIMEOUT_MS = 10000;
    private static final int STATE_REMOVED = -1;
    private final DownloadManager downloadManager;
    private final HashMap<String, LinkedBlockingQueue<Integer>> downloadStates;
    private final ConditionVariable initializedCondition;
    private final ConditionVariable idleCondition;
    private int failureReason;

    public TestDownloadManagerListener(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
        this.downloadStates = new HashMap();
        this.initializedCondition = RobolectricUtil.createRobolectricConditionVariable();
        this.idleCondition = RobolectricUtil.createRobolectricConditionVariable();
        downloadManager.addListener((DownloadManager.Listener)this);
    }

    public void blockUntilInitialized() throws InterruptedException {
        Truth.assertThat((Boolean)this.initializedCondition.block(10000L)).isTrue();
    }

    public void blockUntilIdle() throws InterruptedException {
        this.idleCondition.close();
        ConditionVariable checkedOnMainThread = RobolectricUtil.createRobolectricConditionVariable();
        new Handler(this.downloadManager.getApplicationLooper()).post(() -> {
            if (this.downloadManager.isIdle()) {
                this.idleCondition.open();
            }
            checkedOnMainThread.open();
        });
        Truth.assertThat((Boolean)checkedOnMainThread.block(10000L)).isTrue();
        Truth.assertThat((Boolean)this.idleCondition.block(10000L)).isTrue();
    }

    public void blockUntilIdleAndThrowAnyFailure() throws Exception {
        this.blockUntilIdle();
        if (this.failureReason != 0) {
            throw new Exception("Failure reason: " + this.failureReason);
        }
    }

    public void assertState(String id, int state) {
        this.assertStateInternal(id, state);
    }

    public void assertRemoved(String id) {
        this.assertStateInternal(id, -1);
    }

    public void onInitialized(DownloadManager downloadManager) {
        this.initializedCondition.open();
    }

    public void onDownloadChanged(DownloadManager downloadManager, Download download, @Nullable Exception finalException) {
        if (download.state == 4) {
            this.failureReason = download.failureReason;
        }
        this.getStateQueue(download.request.id).add(download.state);
    }

    public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
        this.getStateQueue(download.request.id).add(-1);
    }

    public void onIdle(DownloadManager downloadManager) {
        this.idleCondition.open();
    }

    private void assertStateInternal(String id, int expectedState) {
        while (true) {
            Integer state = null;
            try {
                state = this.getStateQueue(id).poll(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("Interrupted: " + e.getMessage()));
            }
            if (state != null) {
                if (expectedState != state) continue;
                return;
            }
            Assert.fail((String)("Didn't receive expected state: " + expectedState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedBlockingQueue<Integer> getStateQueue(String id) {
        HashMap<String, LinkedBlockingQueue<Integer>> hashMap = this.downloadStates;
        synchronized (hashMap) {
            LinkedBlockingQueue<Integer> stateQueue = this.downloadStates.get(id);
            if (stateQueue == null) {
                stateQueue = new LinkedBlockingQueue();
                this.downloadStates.put(id, stateQueue);
            }
            return stateQueue;
        }
    }
}

