/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.os.Looper;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.robolectric.RobolectricUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.common.base.Supplier;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class TestPlayerRunHelper {
    private TestPlayerRunHelper() {
    }

    public static void runUntilPlaybackState(Player player, final int expectedState) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player.getPlaybackState() == expectedState) {
            return;
        }
        final AtomicBoolean receivedExpectedState = new AtomicBoolean(false);
        Player.EventListener listener = new Player.EventListener(){

            public void onPlaybackStateChanged(int state) {
                if (state == expectedState) {
                    receivedExpectedState.set(true);
                }
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedExpectedState::get));
        player.removeListener(listener);
    }

    public static void runUntilPlayWhenReady(final Player player, final boolean expectedPlayWhenReady) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (player.getPlayWhenReady() == expectedPlayWhenReady) {
            return;
        }
        final AtomicBoolean receivedExpectedPlayWhenReady = new AtomicBoolean(false);
        Player.EventListener listener = new Player.EventListener(){

            public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
                if (playWhenReady == expectedPlayWhenReady) {
                    receivedExpectedPlayWhenReady.set(true);
                }
                player.removeListener((Player.EventListener)this);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedExpectedPlayWhenReady::get));
    }

    public static void runUntilTimelineChanged(final Player player, final Timeline expectedTimeline) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        if (expectedTimeline.equals((Object)player.getCurrentTimeline())) {
            return;
        }
        final AtomicBoolean receivedExpectedTimeline = new AtomicBoolean(false);
        Player.EventListener listener = new Player.EventListener(){

            public void onTimelineChanged(Timeline timeline, int reason) {
                if (expectedTimeline.equals((Object)timeline)) {
                    receivedExpectedTimeline.set(true);
                }
                player.removeListener((Player.EventListener)this);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedExpectedTimeline::get));
    }

    public static Timeline runUntilTimelineChanged(final Player player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicReference receivedTimeline = new AtomicReference();
        Player.EventListener listener = new Player.EventListener(){

            public void onTimelineChanged(Timeline timeline, int reason) {
                receivedTimeline.set(timeline);
                player.removeListener((Player.EventListener)this);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receivedTimeline.get() != null));
        return (Timeline)receivedTimeline.get();
    }

    public static void runUntilPositionDiscontinuity(final Player player, final int expectedReason) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicBoolean receivedCallback = new AtomicBoolean(false);
        Player.EventListener listener = new Player.EventListener(){

            public void onPositionDiscontinuity(int reason) {
                if (reason == expectedReason) {
                    receivedCallback.set(true);
                    player.removeListener((Player.EventListener)this);
                }
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedCallback::get));
    }

    public static ExoPlaybackException runUntilError(final Player player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicReference receivedError = new AtomicReference();
        Player.EventListener listener = new Player.EventListener(){

            public void onPlayerError(ExoPlaybackException error) {
                receivedError.set(error);
                player.removeListener((Player.EventListener)this);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> receivedError.get() != null));
        return (ExoPlaybackException)receivedError.get();
    }

    public static boolean runUntilReceiveOffloadSchedulingEnabledNewState(Player player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicReference<@NullableType V> offloadSchedulingEnabledReceiver = new AtomicReference();
        Player.EventListener listener = new Player.EventListener(){

            public void onExperimentalOffloadSchedulingEnabledChanged(boolean offloadSchedulingEnabled) {
                offloadSchedulingEnabledReceiver.set(offloadSchedulingEnabled);
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)() -> offloadSchedulingEnabledReceiver.get() != null));
        return (Boolean)Assertions.checkNotNull(offloadSchedulingEnabledReceiver.get());
    }

    public static void runUntilSleepingForOffload(Player player, final boolean expectedSleepForOffload) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread(player);
        final AtomicBoolean receiverCallback = new AtomicBoolean(false);
        Player.EventListener listener = new Player.EventListener(){

            public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
                if (sleepingForOffload == expectedSleepForOffload) {
                    receiverCallback.set(true);
                }
            }
        };
        player.addListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receiverCallback::get));
    }

    public static void runUntilRenderedFirstFrame(final SimpleExoPlayer player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        final AtomicBoolean receivedCallback = new AtomicBoolean(false);
        VideoListener listener = new VideoListener(){

            public void onRenderedFirstFrame() {
                receivedCallback.set(true);
                player.removeVideoListener((VideoListener)this);
            }
        };
        player.addVideoListener(listener);
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedCallback::get));
    }

    public static void playUntilPosition(ExoPlayer player, int windowIndex, long positionMs) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        Looper applicationLooper = Util.getCurrentOrMainLooper();
        AtomicBoolean messageHandled = new AtomicBoolean(false);
        player.createMessage((messageType, payload) -> {
            ConditionVariable blockPlaybackThreadCondition = new ConditionVariable();
            player.getClock().createHandler(applicationLooper, null).post(() -> {
                player.pause();
                messageHandled.set(true);
                blockPlaybackThreadCondition.open();
            });
            try {
                blockPlaybackThreadCondition.block();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).setPosition(windowIndex, positionMs).send();
        player.play();
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)messageHandled::get));
    }

    public static void playUntilStartOfWindow(ExoPlayer player, int windowIndex) throws TimeoutException {
        TestPlayerRunHelper.playUntilPosition(player, windowIndex, 0L);
    }

    public static void runUntilPendingCommandsAreFullyHandled(ExoPlayer player) throws TimeoutException {
        TestPlayerRunHelper.verifyMainTestThread((Player)player);
        AtomicBoolean receivedMessageCallback = new AtomicBoolean(false);
        player.createMessage((type, data) -> receivedMessageCallback.set(true)).setLooper(Util.getCurrentOrMainLooper()).send();
        RobolectricUtil.runMainLooperUntil((Supplier<Boolean>)((Supplier)receivedMessageCallback::get));
    }

    private static void verifyMainTestThread(Player player) {
        if (Looper.myLooper() != Looper.getMainLooper() || player.getApplicationLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException();
        }
    }
}

