/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import com.google.android.exoplayer2.testutil.Dumper;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.shadows.ShadowMediaCodec;

public final class TeeCodec
implements ShadowMediaCodec.CodecConfig.Codec,
Dumper.Dumpable {
    private final String mimeType;
    private final List<byte[]> receivedBuffers;

    public TeeCodec(String mimeType) {
        this.mimeType = mimeType;
        this.receivedBuffers = Collections.synchronizedList(new ArrayList());
    }

    public void process(ByteBuffer in, ByteBuffer out) {
        byte[] bytes = new byte[in.remaining()];
        in.get(bytes);
        this.receivedBuffers.add(bytes);
        if (!MimeTypes.isAudio((String)this.mimeType)) {
            out.put(bytes);
        }
    }

    public void dump(Dumper dumper) {
        if (this.receivedBuffers.isEmpty()) {
            return;
        }
        dumper.startBlock("MediaCodec (" + this.mimeType + ")");
        dumper.add("buffers.length", (Object)this.receivedBuffers.size());
        for (int i = 0; i < this.receivedBuffers.size(); ++i) {
            dumper.add("buffers[" + i + "]", this.receivedBuffers.get(i));
        }
        dumper.endBlock();
    }

    public ImmutableList<byte[]> getReceivedBuffers() {
        return ImmutableList.copyOf(this.receivedBuffers);
    }
}

