/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import com.google.android.exoplayer2.robolectric.TeeCodec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.robolectric.shadows.MediaCodecInfoBuilder;
import org.robolectric.shadows.ShadowMediaCodec;
import org.robolectric.shadows.ShadowMediaCodecList;

public final class ShadowMediaCodecConfig
extends ExternalResource {
    private final Map<String, TeeCodec> codecsByMimeType = new HashMap<String, TeeCodec>();

    private ShadowMediaCodecConfig() {
    }

    public static ShadowMediaCodecConfig forAllSupportedMimeTypes() {
        return new ShadowMediaCodecConfig();
    }

    public ImmutableMap<String, TeeCodec> getCodecs() {
        return ImmutableMap.copyOf(this.codecsByMimeType);
    }

    protected void before() throws Throwable {
        MediaCodecInfo.CodecProfileLevel avcProfileLevel = ShadowMediaCodecConfig.createProfileLevel(8, 524288);
        this.configureCodec("exotest.video.avc", "video/avc", (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of((Object)avcProfileLevel), (List<Integer>)ImmutableList.of((Object)2135033992));
        MediaCodecInfo.CodecProfileLevel mpeg2ProfileLevel = ShadowMediaCodecConfig.createProfileLevel(1, 1);
        this.configureCodec("exotest.video.mpeg2", "video/mpeg2", (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of((Object)mpeg2ProfileLevel), (List<Integer>)ImmutableList.of((Object)2135033992));
        this.configureCodec("exotest.audio.aac", "audio/mp4a-latm");
        this.configureCodec("exotest.audio.mpegl2", "audio/mpeg-L2");
    }

    protected void after() {
        this.codecsByMimeType.clear();
        ShadowMediaCodecList.reset();
        ShadowMediaCodec.clearCodecs();
    }

    private void configureCodec(String codecName, String mimeType) {
        this.configureCodec(codecName, mimeType, (List<MediaCodecInfo.CodecProfileLevel>)ImmutableList.of(), (List<Integer>)ImmutableList.of());
    }

    private void configureCodec(String codecName, String mimeType, List<MediaCodecInfo.CodecProfileLevel> profileLevels, List<Integer> colorFormats) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", mimeType);
        MediaCodecInfoBuilder.CodecCapabilitiesBuilder capabilities = MediaCodecInfoBuilder.CodecCapabilitiesBuilder.newBuilder().setMediaFormat(mediaFormat);
        if (!profileLevels.isEmpty()) {
            capabilities.setProfileLevels(profileLevels.toArray(new MediaCodecInfo.CodecProfileLevel[0]));
        }
        if (!colorFormats.isEmpty()) {
            capabilities.setColorFormats(Ints.toArray(colorFormats));
        }
        ShadowMediaCodecList.addCodec((MediaCodecInfo)MediaCodecInfoBuilder.newBuilder().setName(codecName).setCapabilities(new MediaCodecInfo.CodecCapabilities[]{capabilities.build()}).build());
        TeeCodec codec = new TeeCodec(mimeType);
        ShadowMediaCodec.addDecoder((String)codecName, (ShadowMediaCodec.CodecConfig)new ShadowMediaCodec.CodecConfig(50000, 50000, (ShadowMediaCodec.CodecConfig.Codec)codec));
        this.codecsByMimeType.put(mimeType, codec);
    }

    private static MediaCodecInfo.CodecProfileLevel createProfileLevel(int profile, int level) {
        MediaCodecInfo.CodecProfileLevel profileLevel = new MediaCodecInfo.CodecProfileLevel();
        profileLevel.profile = profile;
        profileLevel.level = level;
        return profileLevel;
    }
}

