/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.robolectric;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.robolectric.ShadowMediaCodecConfig;
import com.google.android.exoplayer2.robolectric.TeeCodec;
import com.google.android.exoplayer2.testutil.Dumper;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PlaybackOutput
implements Dumper.Dumpable {
    private final ShadowMediaCodecConfig codecConfig;
    private final List<Metadata> metadatas;
    private final List<List<Cue>> subtitles;

    private PlaybackOutput(SimpleExoPlayer player, ShadowMediaCodecConfig codecConfig) {
        this.codecConfig = codecConfig;
        this.metadatas = Collections.synchronizedList(new ArrayList());
        this.subtitles = Collections.synchronizedList(new ArrayList());
        player.addMetadataOutput(this.metadatas::add);
        player.addTextOutput(this.subtitles::add);
    }

    public static PlaybackOutput register(SimpleExoPlayer player, ShadowMediaCodecConfig mediaCodecConfig) {
        return new PlaybackOutput(player, mediaCodecConfig);
    }

    public void dump(Dumper dumper) {
        ImmutableMap<String, TeeCodec> codecs = this.codecConfig.getCodecs();
        ImmutableList mimeTypes = ImmutableList.sortedCopyOf((Iterable)codecs.keySet());
        for (String mimeType : mimeTypes) {
            dumper.add((Dumper.Dumpable)Assertions.checkNotNull((Object)codecs.get((Object)mimeType)));
        }
        this.dumpMetadata(dumper);
        this.dumpSubtitles(dumper);
    }

    private void dumpMetadata(Dumper dumper) {
        if (this.metadatas.isEmpty()) {
            return;
        }
        dumper.startBlock("MetadataOutput");
        for (int i = 0; i < this.metadatas.size(); ++i) {
            dumper.startBlock("Metadata[" + i + "]");
            Metadata metadata = this.metadatas.get(i);
            for (int j = 0; j < metadata.length(); ++j) {
                dumper.add("entry[" + j + "]", (Object)metadata.get(j).getClass().getSimpleName());
            }
            dumper.endBlock();
        }
        dumper.endBlock();
    }

    private void dumpSubtitles(Dumper dumper) {
        if (this.subtitles.isEmpty()) {
            return;
        }
        dumper.startBlock("TextOutput");
        for (int i = 0; i < this.subtitles.size(); ++i) {
            dumper.startBlock("Subtitle[" + i + "]");
            List<Cue> subtitle = this.subtitles.get(i);
            if (subtitle.isEmpty()) {
                dumper.add("Cues", (Object)ImmutableList.of());
            }
            for (int j = 0; j < subtitle.size(); ++j) {
                dumper.startBlock("Cue[" + j + "]");
                Cue cue = subtitle.get(j);
                PlaybackOutput.dumpIfNotEqual(dumper, "text", cue.text, null);
                PlaybackOutput.dumpIfNotEqual(dumper, "textAlignment", cue.textAlignment, null);
                PlaybackOutput.dumpBitmap(dumper, cue.bitmap);
                PlaybackOutput.dumpIfNotEqual(dumper, "line", Float.valueOf(cue.line), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "lineType", cue.lineType, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "lineAnchor", cue.lineAnchor, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "position", Float.valueOf(cue.position), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "positionAnchor", cue.positionAnchor, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "size", Float.valueOf(cue.size), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "bitmapHeight", Float.valueOf(cue.bitmapHeight), Float.valueOf(-3.4028235E38f));
                if (cue.windowColorSet) {
                    dumper.add("cue.windowColor", (Object)cue.windowColor);
                }
                PlaybackOutput.dumpIfNotEqual(dumper, "textSizeType", cue.textSizeType, Integer.MIN_VALUE);
                PlaybackOutput.dumpIfNotEqual(dumper, "textSize", Float.valueOf(cue.textSize), Float.valueOf(-3.4028235E38f));
                PlaybackOutput.dumpIfNotEqual(dumper, "verticalType", cue.verticalType, Integer.MIN_VALUE);
                dumper.endBlock();
            }
            dumper.endBlock();
        }
        dumper.endBlock();
    }

    private static void dumpIfNotEqual(Dumper dumper, String field, @Nullable Object actual, @Nullable Object comparison) {
        if (!Util.areEqual((Object)actual, (Object)comparison)) {
            dumper.add(field, actual);
        }
    }

    private static void dumpBitmap(Dumper dumper, @Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        byte[] bytes = new byte[bitmap.getByteCount()];
        bitmap.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(bytes));
        dumper.add("bitmap", bytes);
    }
}

