/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbLog;
import org.json.JSONException;
import org.json.JSONObject;

class DtbPackageNativeData {
    private static DtbPackageNativeData packageNativeDataInstance = null;
    private JSONObject json = new JSONObject();
    private String packageName;
    private String versionName;
    private String applicationLabel;
    private String versionCode;

    protected static synchronized DtbPackageNativeData getPackageNativeDataInstance(Context context) {
        if (packageNativeDataInstance == null) {
            packageNativeDataInstance = new DtbPackageNativeData(context);
        }
        return packageNativeDataInstance;
    }

    private DtbPackageNativeData(Context context) {
        this.packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        this.applicationLabel = (String)packageManager.getApplicationLabel(applicationInfo);
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            DtbLog.error("Package " + this.packageName + " not found");
        }
        this.versionName = packageInfo != null ? packageInfo.versionName : "";
        this.versionCode = packageInfo != null ? Integer.toString(packageInfo.versionCode) : "";
        try {
            this.json.put("lbl", (Object)this.applicationLabel);
            this.json.put("pn", (Object)this.packageName);
            if (!DtbCommonUtils.isNullOrEmpty(this.versionCode)) {
                this.json.put("v", (Object)this.versionCode);
            }
            if (!DtbCommonUtils.isNullOrEmpty(this.versionName)) {
                this.json.put("vn", (Object)this.versionName);
            }
        }
        catch (JSONException e) {
            DtbLog.error("JSON exception while buildinf package native data");
        }
    }

    protected JSONObject getParamsJson() {
        return this.json;
    }
}

