/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbMetric;
import com.amazon.device.ads.DtbThreadService;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

class DtbMetrics
implements Cloneable {
    private final String LOG_TAG = DtbMetrics.class.getSimpleName();
    private volatile Map<DtbMetric, Long> collectedMetrics = new EnumMap<DtbMetric, Long>(DtbMetric.class);
    private volatile Map<DtbMetric, Long> tempTimer = new EnumMap<DtbMetric, Long>(DtbMetric.class);
    private String instPxlUrl = null;

    DtbMetrics() {
    }

    public void incrementMetric(DtbMetric metric) {
        if (metric == null || metric.getMetricType() != DtbMetric.DtbMetricType.COUNTER) {
            throw new IllegalArgumentException("Either metric is null or metric type is not counter.");
        }
        if (this.collectedMetrics.get((Object)metric) == null) {
            this.collectedMetrics.put(metric, 0L);
        }
        this.collectedMetrics.put(metric, this.collectedMetrics.get((Object)metric) + 1L);
    }

    public void startTimer(DtbMetric metric) {
        try {
            if (metric == null || metric.getMetricType() != DtbMetric.DtbMetricType.TIMER) {
                throw new IllegalArgumentException("Either metric is null or metric type is not timer.");
            }
            if (this.collectedMetrics.get((Object)metric) != null) {
                throw new IllegalArgumentException((Object)((Object)metric) + " is already set, your operation is trying to override a value.");
            }
            this.tempTimer.put(metric, System.currentTimeMillis());
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to Start timer ", e);
        }
    }

    public void resetMetric(DtbMetric metric) {
        try {
            this.collectedMetrics.remove((Object)metric);
            this.tempTimer.remove((Object)metric);
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to reset Metrics ", e);
        }
    }

    public void stopTimer(DtbMetric metric) {
        try {
            if (metric == null || metric.getMetricType() == DtbMetric.DtbMetricType.COUNTER) {
                throw new IllegalArgumentException("Either metric is null or metric type is not timer.");
            }
            if (this.tempTimer.get((Object)metric) == null) {
                throw new IllegalArgumentException("You are trying to stop a metric, which is not yet started: " + (Object)((Object)metric));
            }
            if (this.collectedMetrics.get((Object)metric) != null) {
                throw new IllegalArgumentException((Object)((Object)metric) + " is already set, your operation is trying to override a value.");
            }
            this.collectedMetrics.put(metric, System.currentTimeMillis() - this.tempTimer.get((Object)metric));
            this.tempTimer.remove((Object)metric);
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to stop timer ", e);
        }
    }

    public boolean isStarted(DtbMetric metric) {
        return this.tempTimer.containsKey((Object)metric);
    }

    public String toString() {
        JSONObject json = new JSONObject();
        try {
            json.put("c", (Object)"dtbm");
            for (Map.Entry<DtbMetric, Long> entry : this.collectedMetrics.entrySet()) {
                DtbMetric key = entry.getKey();
                Long value = entry.getValue();
                json.put(key.getAAXName(), (Object)value);
            }
        }
        catch (JSONException e) {
            DtbLog.debug("Error while adding values to JSON object: " + e.getLocalizedMessage());
        }
        return json.toString();
    }

    public String toURLEncodedString() {
        return DtbCommonUtils.getURLEncodedString(this.toString());
    }

    public int getMetricsCount() {
        return this.collectedMetrics.size();
    }

    public String getInstPxlUrl() {
        return this.instPxlUrl;
    }

    public void setInstPxlUrl(String instPxlUrl) {
        int protocolIdx;
        if (instPxlUrl != null && (protocolIdx = instPxlUrl.indexOf("://")) != -1) {
            instPxlUrl = instPxlUrl.substring(protocolIdx + 3);
        }
        this.instPxlUrl = instPxlUrl;
    }

    protected DtbMetrics clone() {
        DtbMetrics clone = new DtbMetrics();
        clone.collectedMetrics.putAll(this.collectedMetrics);
        clone.tempTimer.putAll(this.tempTimer);
        clone.instPxlUrl = this.instPxlUrl;
        return clone;
    }

    public void reset() {
        this.collectedMetrics.clear();
        this.tempTimer.clear();
    }

    static class Submitter {
        public static final Submitter INSTANCE = new Submitter();
        private final String LOG_TAG = Submitter.class.getSimpleName();
        private final Queue<DtbMetrics> metricsQueue = new ConcurrentLinkedQueue<DtbMetrics>();

        private Submitter() {
        }

        public void submitMetrics(DtbMetrics metrics) {
            if (metrics.getMetricsCount() > 0) {
                this.metricsQueue.add(metrics.clone());
                metrics.reset();
                DtbLog.debug("Scheduling metrics submission in background thread.");
                DtbThreadService.getInstance().schedule(() -> {
                    DtbLog.debug("Starting metrics submission..");
                    this.submitMetrics();
                    DtbLog.debug("Metrics submission thread complete.");
                });
                DtbLog.debug("Dispatched the metrics submit task on a background schedule thread.");
            }
        }

        private void submitMetrics() {
            int count = 0;
            Iterator iterator = this.metricsQueue.iterator();
            while (iterator.hasNext()) {
                DtbMetrics metrics = (DtbMetrics)iterator.next();
                DtbLog.debug("Starting metrics submission - Sequence " + ++count);
                if (metrics.getInstPxlUrl() == null) {
                    iterator.remove();
                    DtbLog.debug("No metric url found- Sequence " + count + ", skipping..");
                    continue;
                }
                String metricsUrl = metrics.getInstPxlUrl() + metrics.toURLEncodedString();
                DtbLog.debug("Metrics URL:" + metricsUrl);
                try {
                    DtbHttpClient client = new DtbHttpClient(metricsUrl);
                    client.setUseSecure(DtbDebugProperties.getIsSecure(true));
                    client.executeGET(60000);
                    if (client.isHttpStatusCodeOK()) {
                        DtbLog.debug("Metrics submitted- Sequence " + count);
                        iterator.remove();
                        continue;
                    }
                    DtbLog.debug("Metrics submission failed- Sequence " + count + ", response invalid");
                }
                catch (Exception e) {
                    DtbLog.debug("Metrics submission failed- Sequence " + count + ", encountered error:" + e.toString());
                }
                break;
            }
        }
    }
}

