/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbGooglePlayServices;
import com.amazon.device.ads.DtbLog;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;

class DtbGooglePlayServicesAdapter {
    DtbGooglePlayServicesAdapter() {
    }

    public static DtbGooglePlayServicesAdapter newAdapter() {
        return new DtbGooglePlayServicesAdapter();
    }

    public DtbGooglePlayServices.AdvertisingInfo getAdvertisingIdentifierInfo() {
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)AdRegistration.getContext());
        }
        catch (IllegalStateException e) {
            DtbLog.error("Retrieving the Google Play Services  caused Illegal State Exception ( be sure the call was made from a non-background thread)." + DtbCommonUtils.exceptionToString(e));
        }
        catch (IOException e) {
            DtbLog.error("Retrieving the Google Play Services Advertising Identifier caused an IOException." + DtbCommonUtils.exceptionToString(e));
        }
        catch (GooglePlayServicesNotAvailableException e) {
            DtbLog.error("Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesNotAvailableException." + DtbCommonUtils.exceptionToString((Exception)((Object)e)));
            return DtbGooglePlayServices.AdvertisingInfo.createNotAvailable();
        }
        catch (GooglePlayServicesRepairableException e) {
            DtbLog.error("Retrieving the Google Play Services Advertising Identifier caused a GooglePlayServicesRepairableException." + DtbCommonUtils.exceptionToString((Exception)((Object)e)));
        }
        if (info == null) {
            DtbLog.debug("The Google Play Services Advertising Identifier could not be retrieved.");
            return new DtbGooglePlayServices.AdvertisingInfo();
        }
        DtbLog.debug("The Google Play Services Advertising Identifier was successfully retrieved.");
        String advertisingId = info.getId();
        boolean limitAdTrackingEnabled = info.isLimitAdTrackingEnabled();
        DtbLog.debug(" Retrieved google ad id " + info.getId() + " and tracking enabled : " + info.isLimitAdTrackingEnabled());
        return new DtbGooglePlayServices.AdvertisingInfo().setAdvertisingIdentifier(advertisingId).setLimitAdTrackingEnabled(limitAdTrackingEnabled);
    }
}

