/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import com.amazon.aps.ads.ApsMigrationUtil;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbAdvertisingInfo;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbDeviceData;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbMetric;
import com.amazon.device.ads.DtbMetrics;
import com.amazon.device.ads.DtbPackageNativeData;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.DtbThreadService;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DtbDeviceRegistration {
    private static final String LOG_TAG = DtbDeviceRegistration.class.getName();
    private static DtbDeviceRegistration dtbDeviceRegistrationInstance = null;
    private static String appId;
    private static final String AAX_VIDEO_HOST_NAME_KEY = "aaxVideoHostname";
    private static final String CONFIG_SEGMENT_ID_KEY = "segmentId";
    private static final String CONFIG_OS_KEY = "os";
    private static final String CONFIG_OS_VERSION_KEY = "osVersion";
    private static final String CONFIG_PRIVACY_KEY = "privacy";
    private final DtbMetrics metrics = new DtbMetrics();

    public static synchronized void verifyRegistration() {
        if (dtbDeviceRegistrationInstance == null) {
            dtbDeviceRegistrationInstance = new DtbDeviceRegistration();
            ApsMigrationUtil.setApsRemoteConfigInProgress(false);
        }
        if (!ApsMigrationUtil.isApsRemoteConfigInProgress()) {
            ApsMigrationUtil.setApsRemoteConfigInProgress(true);
            DtbThreadService.getInstance().execute(() -> {
                dtbDeviceRegistrationInstance.initializeAds();
                ApsMigrationUtil.setApsRemoteConfigInProgress(false);
            });
        }
    }

    private DtbDeviceRegistration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void initializeAds() {
        if (DtbCommonUtils.isOnMainThread()) {
            DtbLog.error(LOG_TAG, "Unable to fetch advertising identifier information on main thread.");
            return;
        }
        appId = AdRegistration.getAppKey();
        if (DtbCommonUtils.isNullOrEmpty(appId)) {
            DtbLog.error(LOG_TAG, "App id not available");
            return;
        }
        if (!DtbCommonUtils.isNetworkConnected()) {
            DtbLog.debug("Network is not available");
            return;
        }
        DtbDebugProperties.getInstance();
        this.registerConfig(appId);
        long now = System.currentTimeMillis();
        long sisLastCheckIn = DtbSharedPreferences.getInstance().getSisLastCheckIn();
        if (DtbSharedPreferences.getInstance().getIsSisRegisterationSuccessful() && now - sisLastCheckIn <= 86400000L) {
            DtbLog.debug("SIS call not required, last registration duration:" + (now - sisLastCheckIn) + ", expiration:" + 86400000L);
            return;
        }
        DtbAdvertisingInfo adInfo = new DtbAdvertisingInfo();
        String sisEndpoint = DtbSharedPreferences.getInstance().getSisEndpoint();
        if (sisEndpoint.startsWith("null")) {
            DtbLog.debug("SIS is not ready");
            return;
        }
        StringBuilder sisUrl = new StringBuilder(DtbDebugProperties.getSISUrl(sisEndpoint));
        boolean metricsForUpdate = false;
        if (sisLastCheckIn == 0L) {
            DtbLog.info(LOG_TAG, "Trying to register ad id..");
            sisUrl.append("/generate_did");
        } else {
            DtbLog.info(LOG_TAG, "Trying to update ad id..");
            sisUrl.append("/update_dev_info");
            metricsForUpdate = true;
        }
        HashMap<String, Object> params = this.buildSISParams(appId);
        DtbMetric metric = null;
        try {
            DtbHttpClient client = new DtbHttpClient(sisUrl.toString());
            client.setUseSecure(DtbDebugProperties.getIsSecure(true));
            client.setParams(params);
            client.enableQueryParams();
            metric = metricsForUpdate ? DtbMetric.SIS_LATENCY_UPDATE_DEVICE_INFO : DtbMetric.SIS_LATENCY_REGISTER_EVENT;
            this.metrics.startTimer(metric);
            client.executePOST(60000);
            this.metrics.stopTimer(metric);
            if (DtbCommonUtils.isNullOrEmpty(client.getResponse())) {
                DtbLog.debug("No response from sis call.");
                throw new Exception("SIS Response is null");
            }
            JSONObject jsonPayload = (JSONObject)new JSONTokener(client.getResponse()).nextValue();
            DtbSharedPreferences.getInstance().setIsSisRegisterationSuccessful(this.isRegistrationRequestSuccessful(jsonPayload));
            if (!DtbSharedPreferences.getInstance().getIsSisRegisterationSuccessful()) {
                DtbLog.info(LOG_TAG, "ad id failed registration: " + jsonPayload.toString());
                throw new Exception("ad id failed registration: ");
            }
            if (metric != null) {
                this.metrics.resetMetric(metric);
            }
        }
        catch (JSONException e) {
            DtbLog.error("JSON error parsing return from SIS: " + e.getMessage());
            if (metric != null) {
                this.metrics.resetMetric(metric);
            }
            return;
        }
        catch (Exception e2) {
            DtbLog.error("Error registering device for ads:" + e2.toString());
            if (metric != null) {
                this.metrics.resetMetric(metric);
            }
            return;
            {
                catch (Throwable throwable) {
                    if (metric != null) {
                        this.metrics.resetMetric(metric);
                    }
                    throw throwable;
                }
            }
        }
        this.pingSis(sisEndpoint, appId);
    }

    private void pingSis(String sisEndpoint, String appId) {
        long sisLastPing;
        long now = System.currentTimeMillis();
        if (now - (sisLastPing = DtbSharedPreferences.getInstance().getSisLastPing()) < 2592000000L) {
            return;
        }
        String adId = DtbSharedPreferences.getInstance().getAdId();
        if (adId == null || adId.isEmpty()) {
            DtbLog.info("error retrieving ad id, cancelling sis ping");
            return;
        }
        try {
            String encodedNonIABString;
            if (!DtbCommonUtils.isNetworkConnected()) {
                DtbLog.debug("Network is not available");
                return;
            }
            DtbHttpClient client = new DtbHttpClient(sisEndpoint + "/ping");
            client.setUseSecure(DtbDebugProperties.getIsSecure(true));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appId", appId);
            params.put("adId", adId);
            Context context = AdRegistration.getContext();
            if (context != null) {
                HashMap<String, Object> gppParams;
                SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                Object IABGDPRApplies_TCFv2 = sharedPreferences.contains("IABTCF_gdprApplies") ? (Object)sharedPreferences.getAll().get("IABTCF_gdprApplies") : null;
                String IABConsentString_TCFv2 = sharedPreferences.getString("IABTCF_TCString", null);
                if (IABGDPRApplies_TCFv2 != null) {
                    try {
                        if (IABGDPRApplies_TCFv2 instanceof Integer && ((Integer)IABGDPRApplies_TCFv2 == 1 || (Integer)IABGDPRApplies_TCFv2 == 0)) {
                            params.put("gdpr", IABGDPRApplies_TCFv2);
                        } else if (IABGDPRApplies_TCFv2 instanceof String && ((String)IABGDPRApplies_TCFv2).equals("1") || ((String)IABGDPRApplies_TCFv2).equals("0")) {
                            params.put("gdpr", IABGDPRApplies_TCFv2);
                        } else {
                            DtbLog.info("IABTCF_gdprApplies should be a 1 or 0 as per IAB guideline");
                        }
                    }
                    catch (ClassCastException ex) {
                        DtbLog.info("IABTCF_gdprApplies should be a number as per IAB guideline");
                    }
                }
                if (IABConsentString_TCFv2 != null) {
                    params.put("gdpr_consent", IABConsentString_TCFv2);
                }
                if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("enable_gpp_params_to_aip_call") && !DtbCommonUtils.isNullOrEmpty(gppParams = DtbCommonUtils.addGPPParametersFromPreferences(sharedPreferences))) {
                    params.putAll(gppParams);
                }
            }
            if (!DtbCommonUtils.isNullOrEmpty(encodedNonIABString = AdRegistration.getEncodedNonIABString())) {
                params.put("gdpr_custom", encodedNonIABString);
            }
            client.setParams(params);
            client.executeGET(60000);
            if (DtbCommonUtils.isNullOrEmpty(client.getResponse())) {
                DtbLog.debug("No response from sis ping.");
                throw new Exception("Ping SIS Response is null");
            }
            JSONObject jsonPayload = (JSONObject)new JSONTokener(client.getResponse()).nextValue();
            if (!this.isPingRequestSuccessful(jsonPayload)) {
                DtbLog.info(LOG_TAG, "sis ping failed failed registration: " + jsonPayload.toString());
                throw new Exception("sis ping failed registration: ");
            }
        }
        catch (Exception e) {
            DtbLog.error("Error pinging sis: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerConfig(String appId) {
        boolean isSisEndpointChanged = false;
        long now = System.currentTimeMillis();
        long lastCheckInDuration = now - DtbSharedPreferences.getInstance().getConfigLastCheckIn();
        long configCheckInTimeToLive = DtbSharedPreferences.getInstance().getConfigTtlInMilliSeconds();
        DtbLog.debug("Config last check in duration: " + lastCheckInDuration + ", Expiration: " + configCheckInTimeToLive);
        if (!DTBMetricsConfiguration.getInstance().isFeatureEnabled("config_check_in_ttl_feature_v2")) {
            configCheckInTimeToLive = 172800000L;
        }
        if (lastCheckInDuration <= configCheckInTimeToLive) {
            DtbLog.debug("No config refresh required");
            return false;
        }
        if (!DtbCommonUtils.isNetworkConnected()) {
            DtbLog.debug("Network is not available");
            return isSisEndpointChanged;
        }
        String configUrl = DtbDebugProperties.getConfigHostName("mads.amazon-adsystem.com") + "/msdk/getConfig";
        DtbHttpClient client = new DtbHttpClient(configUrl);
        client.addHeader("Accept", "application/json");
        HashMap<String, String> configRequestHeaders = DtbDebugProperties.getConfigRequestHeaders("{}");
        for (Map.Entry<String, String> header : configRequestHeaders.entrySet()) {
            client.addHeader(header.getKey(), header.getValue());
        }
        client.setUseSecure(DtbDebugProperties.getIsSecure(true));
        HashMap<String, Object> params = this.buildConfigInfoParams(appId);
        client.setParams(params);
        try {
            this.metrics.startTimer(DtbMetric.CONFIG_DOWNLOAD_LATENCY);
            client.executeGET(60000);
            this.metrics.stopTimer(DtbMetric.CONFIG_DOWNLOAD_LATENCY);
            if (DtbCommonUtils.isNullOrEmpty(client.getResponse())) {
                throw new Exception("Config Response is null");
            }
            isSisEndpointChanged = this.parseRegisterConfigResponse(client.getResponse(), now, isSisEndpointChanged);
        }
        catch (Exception e) {
            DtbLog.error("Error fetching DTB config: " + e.toString());
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error fetching DTB config:", e);
        }
        finally {
            if (this.metrics != null) {
                this.metrics.resetMetric(DtbMetric.CONFIG_DOWNLOAD_LATENCY);
            }
        }
        try {
            DTBMetricsConfiguration.getInstance().loadMobileClientConfig();
            double analyticPercentage = (float)DTBMetricsConfiguration.getClientConfigVal("sampling_rate", DTBMetricsConfiguration.ANALYTIC_PIXEL_DEFAULT_VALUE, "analytics").intValue() / 100.0f;
            String urlAnalytic = DTBMetricsConfiguration.getClientConfigVal("url", "", "analytics");
            String apiKeyAnalytic = DTBMetricsConfiguration.getClientConfigVal("api_key", "", "analytics");
            if (!APSAnalytics.isInitialized()) {
                APSAnalytics.init(AdRegistration.getContext());
                APSAnalytics.setVersion(AdRegistration.getVersion());
            }
            APSAnalytics.setSamplingRate((int)analyticPercentage);
            APSAnalytics.setHttpUrl(urlAnalytic);
            APSAnalytics.setApiKey(apiKeyAnalytic);
            this.loadApsMetricsConfig();
        }
        catch (RuntimeException e) {
            DtbLog.warn("Error when reading client config file for APSAndroidShared library" + e.toString());
        }
        return isSisEndpointChanged;
    }

    private void loadApsMetricsConfig() {
        ApsMetrics.Companion.setEndpointUrl(DTBMetricsConfiguration.getClientConfigVal("apsmetricsv2", "mobile", "url", "https://prod.tahoe-analytics.publishers.advertising.a2z.com/logevent/putRecord"));
        ApsMetrics.Companion.setSamplingPercentage(DTBMetricsConfiguration.getClientConfigVal("apsmetricsv2", "mobile", "samplingPercentage", 0.01));
        ApsMetrics.Companion.setApiKey(DTBMetricsConfiguration.getClientConfigVal("apsmetricsv2", "mobile", "apiKey", "a5c71f6aff54eb34c826d952c285eaf0650b4259c83ae598962681a6429b63f6"));
    }

    private boolean parseRegisterConfigResponse(String response, long now, boolean isSisEndpointChanged) throws Exception {
        JSONObject jsonPayload = (JSONObject)new JSONTokener(response).nextValue();
        if (jsonPayload.has("pj")) {
            DtbSharedPreferences.getInstance().savePJTemplate(jsonPayload.getJSONObject("pj"));
        } else {
            DtbSharedPreferences.getInstance().removePJTemplate();
        }
        if (jsonPayload.has(CONFIG_PRIVACY_KEY)) {
            this.setPrivacyConfigToSharedPreferences(jsonPayload.getJSONArray(CONFIG_PRIVACY_KEY));
        } else {
            DtbSharedPreferences.getInstance().removePrivacyLocationConfig();
        }
        if (jsonPayload.has("aaxHostname") || jsonPayload.has("sisURL") || jsonPayload.has(AAX_VIDEO_HOST_NAME_KEY)) {
            if (jsonPayload.has("aaxHostname")) {
                DtbSharedPreferences.getInstance().saveAaxHostname(jsonPayload.getString("aaxHostname"));
            }
            if (jsonPayload.has("sisURL")) {
                isSisEndpointChanged = DtbSharedPreferences.getInstance().saveSisEndpoint(jsonPayload.getString("sisURL"));
            }
            if (jsonPayload.has("ttl")) {
                long ttl = Long.parseLong(jsonPayload.getString("ttl"));
                DtbSharedPreferences.getInstance().saveConfigTtlInMilliSeconds(ttl);
            }
            if (jsonPayload.has(AAX_VIDEO_HOST_NAME_KEY)) {
                DtbSharedPreferences.getInstance().saveAaxVideoHostname(jsonPayload.getString(AAX_VIDEO_HOST_NAME_KEY));
            }
            if (jsonPayload.has("bidTimeout")) {
                DtbSharedPreferences.getInstance().saveBidTimeout(jsonPayload.getInt("bidTimeout"));
            } else {
                DtbSharedPreferences.getInstance().removeBidTimeout();
            }
        } else {
            DtbLog.info(LOG_TAG, "ad configuration failed load: " + jsonPayload.toString());
            throw new Exception("ad configuration failed load");
        }
        DtbSharedPreferences.getInstance().saveConfigLastCheckIn(now);
        DtbLog.info(LOG_TAG, "ad configuration loaded successfully.");
        return isSisEndpointChanged;
    }

    private static String convertBooleanToFlag(Boolean value) {
        if (value == null) {
            return "0";
        }
        return value != false ? "1" : "0";
    }

    private HashMap<String, Object> buildSISParams(String appId) {
        String encodedNonIABString;
        Context context;
        JSONObject packageNativeData;
        HashMap<String, Object> params = new HashMap<String, Object>(DtbDeviceData.getDeviceDataInstance().getDeviceParams());
        String adId = DtbSharedPreferences.getInstance().getAdId();
        if (adId != null) {
            params.put("adId", adId);
        }
        String advertisingIdentifier = DtbSharedPreferences.getInstance().getIdfa();
        Boolean isLimitAdTrackingEnabled = DtbSharedPreferences.getInstance().getOptOut();
        if (!DtbCommonUtils.isNullOrEmpty(advertisingIdentifier)) {
            params.put("idfa", advertisingIdentifier);
        }
        params.put("oo", DtbDeviceRegistration.convertBooleanToFlag(isLimitAdTrackingEnabled));
        if (appId != null) {
            params.put("appId", appId);
        }
        if ((packageNativeData = DtbPackageNativeData.getPackageNativeDataInstance(AdRegistration.getContext()).getParamsJson()) != null) {
            params.put("pkg", packageNativeData);
        }
        if ((context = AdRegistration.getContext()) != null) {
            HashMap<String, Object> gppParams;
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            Object IABGDPRApplies_TCFv2 = sharedPreferences.contains("IABTCF_gdprApplies") ? (Object)sharedPreferences.getAll().get("IABTCF_gdprApplies") : null;
            String IABConsentString_TCFv2 = sharedPreferences.getString("IABTCF_TCString", null);
            if (IABGDPRApplies_TCFv2 != null) {
                try {
                    if (IABGDPRApplies_TCFv2 instanceof Integer && ((Integer)IABGDPRApplies_TCFv2 == 1 || (Integer)IABGDPRApplies_TCFv2 == 0)) {
                        params.put("gdpr", IABGDPRApplies_TCFv2);
                    } else if (IABGDPRApplies_TCFv2 instanceof String && ((String)IABGDPRApplies_TCFv2).equals("1") || ((String)IABGDPRApplies_TCFv2).equals("0")) {
                        params.put("gdpr", IABGDPRApplies_TCFv2);
                    } else {
                        DtbLog.info("IABTCF_gdprApplies should be a 1 or 0 as per IAB guideline");
                    }
                }
                catch (ClassCastException ex) {
                    DtbLog.info("IABTCF_gdprApplies should be a number as per IAB guideline");
                }
            }
            if (IABConsentString_TCFv2 != null) {
                params.put("gdpr_consent", IABConsentString_TCFv2);
            }
            if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("enable_gpp_params_to_aip_call") && !DtbCommonUtils.isNullOrEmpty(gppParams = DtbCommonUtils.addGPPParametersFromPreferences(sharedPreferences))) {
                params.putAll(gppParams);
            }
        }
        if (!DtbCommonUtils.isNullOrEmpty(encodedNonIABString = AdRegistration.getEncodedNonIABString())) {
            params.put("gdpr_custom", encodedNonIABString);
        }
        return params;
    }

    private HashMap<String, Object> buildConfigInfoParams(String appId) {
        String distributionVal;
        String mediationName;
        JSONObject packageNativeData;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("sdkVer", DtbCommonUtils.getSDKVersion());
        params.put("fp", "false");
        params.put("testMode", Boolean.toString(AdRegistration.isTestMode()));
        JSONObject deviceData = DtbDeviceData.getDeviceDataInstance().getParamsJsonGetSafe();
        if (deviceData != null) {
            params.put("dinfo", deviceData);
        }
        if ((packageNativeData = DtbPackageNativeData.getPackageNativeDataInstance(AdRegistration.getContext()).getParamsJson()) != null) {
            params.put("pkg", packageNativeData);
        }
        if (AdRegistration.getCustomDictionary() != null && AdRegistration.getCustomDictionary().containsKey("mediationName") && !DtbCommonUtils.isNullOrEmpty(mediationName = AdRegistration.getCustomDictionary().get("mediationName"))) {
            params.put("mediationName", mediationName);
        }
        double percentage = (float)DTBMetricsConfiguration.getClientConfigVal("distribution_pixel", DTBMetricsConfiguration.DISTRIBUTION_PIXEL_DEFAULT_VALUE, "sample_rates").intValue() / 100.0f;
        if (Math.random() <= percentage && !DtbCommonUtils.isNullOrEmpty(distributionVal = AdRegistration.getSDKDistributionPlace())) {
            params.put("distribution", distributionVal);
        }
        params.put(CONFIG_SEGMENT_ID_KEY, new SecureRandom().nextInt(1000) + 1);
        params.put(CONFIG_OS_KEY, "android");
        params.put(CONFIG_OS_VERSION_KEY, Build.VERSION.RELEASE);
        return params;
    }

    private boolean isRegistrationRequestSuccessful(JSONObject jsonPayload) throws JSONException {
        if (jsonPayload.has("rcode")) {
            DtbSharedPreferences.getInstance().saveSisLastCheckIn(System.currentTimeMillis());
            if (jsonPayload.getInt("rcode") == 1 && jsonPayload.has("adId")) {
                String adid = jsonPayload.getString("adId");
                if (jsonPayload.has("idChanged") && jsonPayload.getBoolean("idChanged")) {
                    DtbLog.info(LOG_TAG, "ad id has changed, updating..");
                    this.metrics.incrementMetric(DtbMetric.SIS_COUNTER_IDENTIFIED_DEVICE_CHANGED);
                }
                DtbSharedPreferences.getInstance().saveAdId(adid);
                DtbLog.info(LOG_TAG, "ad id is registered or updated successfully.");
                return true;
            }
            if (jsonPayload.getInt("rcode") == 103 || jsonPayload.getInt("rcode") == 101 && jsonPayload.has("msg") && (jsonPayload.optInt("msg") == 103 || "need at least one native id in parameter".equals(jsonPayload.get("msg")))) {
                DtbSharedPreferences.getInstance().removeAdid();
                DtbLog.debug(LOG_TAG, "No ad-id returned");
                return true;
            }
        }
        return false;
    }

    private boolean isPingRequestSuccessful(JSONObject jsonPayload) throws JSONException {
        if (jsonPayload.has("rcode")) {
            if (jsonPayload.getInt("rcode") == 1) {
                DtbSharedPreferences.getInstance().saveSisLastPing(System.currentTimeMillis());
                DtbLog.info(LOG_TAG, "ad id is registered or updated successfully.");
                return true;
            }
            if (jsonPayload.getInt("rcode") == 103 || jsonPayload.getInt("rcode") == 101 && jsonPayload.has("msg") && jsonPayload.getInt("msg") == 103) {
                DtbSharedPreferences.getInstance().saveSisLastPing(System.currentTimeMillis());
                DtbLog.info("gdpr consent not granted");
                return true;
            }
        }
        return false;
    }

    private void setPrivacyConfigToSharedPreferences(JSONArray privacyConfigs) {
        try {
            boolean isLocationKey = false;
            for (int i = 0; i < privacyConfigs.length(); ++i) {
                JSONObject privacyConfig = privacyConfigs.getJSONObject(i);
                if (!privacyConfig.has("location")) continue;
                DtbSharedPreferences.getInstance().savePrivacyLocationConfig(privacyConfig.getJSONObject("location"));
                isLocationKey = true;
                break;
            }
            if (!isLocationKey) {
                DtbSharedPreferences.getInstance().removePrivacyLocationConfig();
            }
        }
        catch (RuntimeException | JSONException e) {
            DtbLog.error(LOG_TAG, "Failed to parse privacy configuration");
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to parse privacy configuration", (Exception)e);
        }
    }
}

