/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class DtbDebugProperties {
    private static final String LOG_TAG = DtbDebugProperties.class.getName();
    private static final String TEST_OVERRIDE_FILE = "com.amazon.device.ads.dtb.debug.override";
    public static final String AAX_HOSTNAME = "aaxHostname";
    public static final String AAX_ROUTE53_ENABLED_CNAME = "route53EnabledAAXCname";
    public static final String SIS_URL = "sisUrl";
    public static final String USE_SECURE = "useSecure";
    public static final String CONFIG_HOSTNAME = "configHostname";
    public static final String INTERNAL_DEBUG_MODE = "internalDebugMode";
    public static final String CONFIG_REQUEST_HEADERS = "configRequestHeaders";
    static boolean isInternalDebugMode = false;
    private static DtbDebugProperties debugProperties = null;
    private static HashMap<String, String> propertyMap = new HashMap();
    private static boolean isInitialized = false;
    private static Set<String> preDefinedKeys;

    DtbDebugProperties() {
    }

    public static DtbDebugProperties getInstance() {
        if (!isInitialized) {
            DtbLog.debug("Running the debug initialization.");
            debugProperties = new DtbDebugProperties();
            preDefinedKeys = new HashSet<String>();
            preDefinedKeys.add(AAX_HOSTNAME.toLowerCase());
            preDefinedKeys.add(SIS_URL.toLowerCase());
            preDefinedKeys.add(USE_SECURE.toLowerCase());
            preDefinedKeys.add(CONFIG_HOSTNAME.toLowerCase());
            preDefinedKeys.add(INTERNAL_DEBUG_MODE.toLowerCase());
            preDefinedKeys.add(CONFIG_REQUEST_HEADERS.toLowerCase());
            DtbDebugProperties.initializeDtbDebugProperties();
        }
        return debugProperties;
    }

    public boolean isDebugMode() {
        return isInternalDebugMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeDtbDebugProperties() {
        block12: {
            try {
                Context context = AdRegistration.getContext();
                if (AdRegistration.isTestMode() && context == null) {
                    DtbLog.debugError("unable to initialize debug preferences without setting app context");
                    throw new IllegalArgumentException("unable to initialize debug preferences without setting app context");
                }
                String fileName = DtbCommonUtils.getApplicationBundle().getString(TEST_OVERRIDE_FILE);
                if (DtbCommonUtils.isNullOrEmpty(fileName) || context == null) break block12;
                DtbLog.debug("Override file: " + fileName);
                InputStream inputStream = DtbCommonUtils.getResourceAsStream(fileName);
                if (inputStream == null) {
                    DtbLog.debug("Failed to read override from classpath, trying to read override file from absolute location: " + fileName);
                    fileName = context.getFilesDir() + "/aps_override_properties/override.properties";
                    File file = new File(fileName);
                    if (!file.exists()) {
                        DtbLog.debug("Couldn't find the override file, skipping.");
                        return;
                    }
                    inputStream = new FileInputStream(file);
                }
                try {
                    DtbLog.debug("Reading debug params..");
                    Properties overrides = new Properties();
                    overrides.load(inputStream);
                    for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                        String key = (String)entry.getKey();
                        if (DtbCommonUtils.isNullOrWhiteSpace(key)) {
                            DtbLog.debug("Error: The debug property name must not be null or empty string");
                            continue;
                        }
                        String value = (String)entry.getValue();
                        if (value != null) {
                            value = value.trim();
                        }
                        DtbLog.debug("Overrides found: " + key + " --> " + value);
                        if (key.equalsIgnoreCase(INTERNAL_DEBUG_MODE)) {
                            isInternalDebugMode = value.equalsIgnoreCase("true");
                        }
                        propertyMap.put(key, value);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                DtbLog.debug("Error:: Failed to read the debug params. ignoring." + e.getStackTrace());
            }
        }
        isInitialized = true;
    }

    public static HashMap<String, String> getDebugParams() {
        if (AdRegistration.isTestMode() && isInternalDebugMode) {
            return propertyMap;
        }
        return new HashMap<String, String>();
    }

    public static String getAaxHostName(String defaultValue) {
        return DtbDebugProperties.getDebugProperty(AAX_HOSTNAME, defaultValue);
    }

    public static String getAaxVideoHostName(String defaultValue) {
        return DtbDebugProperties.getDebugProperty(AAX_ROUTE53_ENABLED_CNAME, defaultValue);
    }

    public static String getSISUrl(String defaultValue) {
        return DtbDebugProperties.getDebugProperty(SIS_URL, defaultValue);
    }

    public static boolean getIsSecure(boolean defaultValue) {
        String useSecure = DtbDebugProperties.getDebugProperty(USE_SECURE, "");
        if (useSecure.equals("true")) {
            return true;
        }
        if (useSecure.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public static String getConfigHostName(String defaultValue) {
        return DtbDebugProperties.getDebugProperty(CONFIG_HOSTNAME, defaultValue);
    }

    public static HashMap<String, String> getConfigRequestHeaders(String defaultValue) {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            String configRequestHeaders = DtbDebugProperties.getDebugProperty(CONFIG_REQUEST_HEADERS, defaultValue);
            JSONObject configRequestHeadersJson = new JSONObject(configRequestHeaders);
            Iterator headerKeys = configRequestHeadersJson.keys();
            while (headerKeys.hasNext()) {
                String header = (String)headerKeys.next();
                Object countryHeader = configRequestHeadersJson.get(header);
                if (!(countryHeader instanceof String)) continue;
                String headerVal = String.valueOf(countryHeader);
                headers.put(header, headerVal);
            }
        }
        catch (RuntimeException | JSONException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Failed to execute getConfigRequestHeaders method", (Exception)e);
        }
        return headers;
    }

    private static String getDebugProperty(String key, String defaultValue) {
        if (AdRegistration.isTestMode() && isInternalDebugMode) {
            if (propertyMap != null && propertyMap.get(key) != null) {
                return propertyMap.get(key);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static void resetProperties() {
        isInitialized = false;
        propertyMap = new HashMap();
    }

    public static String getEncodedUrlParams() {
        if (!isInternalDebugMode) {
            return "";
        }
        StringBuilder kvps = new StringBuilder();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                if (preDefinedKeys.contains(key.toLowerCase())) continue;
                kvps.append('&');
                kvps.append(key).append('=');
                kvps.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                DtbLog.debugError(String.format("Cannot encode %d=%d due to exception %d", key, value, e.getMessage()));
            }
        }
        return kvps.toString();
    }
}

