/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbDeviceData;
import com.amazon.device.ads.DtbLog;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class DTBMetricReport {
    private String type;
    private int latency = -1;
    private BidWrapper bidWrapper;
    private JSONObject propertiesMap;
    private static final String TYPE = "type";
    private static final String SDK = "sdk";
    private static final String ADSERVER = "mediation";
    private static final String CONNECTION = "connection";
    private static final String TIME = "time";
    private static final String LATENCY = "latency";
    private static final String ADAPTER_VERSION = "adapter_version";
    private static final String APP_NAME = "app_id";
    private static final String PROJECT = "project";
    private static final String PROJECT_NAME = "aps_mobile";
    private static final String LOG_TAG = DTBMetricReport.class.getSimpleName();

    private DTBMetricReport(String type, BidWrapper bidWrapper, int latency) {
        this.bidWrapper = bidWrapper;
        this.latency = latency;
        this.setStandardProperties(type);
    }

    private DTBMetricReport(String type, BidWrapper bidWrapper) {
        this.bidWrapper = bidWrapper;
        this.setStandardProperties(type);
    }

    private DTBMetricReport(String type, Map<String, Object> extraProps) {
        this.setStandardProperties(type);
        this.addExtraProperties(extraProps);
    }

    private DTBMetricReport(String type, Map<String, Object> extraProps, BidWrapper bidWrapper) {
        this(type, extraProps);
        this.bidWrapper = bidWrapper;
    }

    String getBidId() {
        if (this.bidWrapper == null) {
            return null;
        }
        return this.bidWrapper.bidId;
    }

    String getHostname() {
        if (this.bidWrapper == null) {
            return null;
        }
        return this.bidWrapper.hostname;
    }

    static BidWrapper addBid(String bidId, String hostname) {
        return new BidWrapper(bidId, hostname);
    }

    private void addExtraProperties(Map<String, Object> extraProps) {
        try {
            for (String key : extraProps.keySet()) {
                Object obj = extraProps.get(key);
                if (obj instanceof String) {
                    this.propertiesMap.put(key, obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    this.propertiesMap.put(key, obj);
                    continue;
                }
                if (obj instanceof Long) {
                    this.propertiesMap.put(key, obj);
                    continue;
                }
                if (!(obj instanceof Boolean)) continue;
                this.propertiesMap.put(key, obj);
            }
        }
        catch (JSONException jsx) {
            DtbLog.error(LOG_TAG, "Invalid JSON conversion:" + jsx.getMessage());
        }
    }

    static DTBMetricReport reportWithBidTypeLatency(BidWrapper bidWrapper, String type, int millis) {
        return new DTBMetricReport(type, bidWrapper, millis);
    }

    static DTBMetricReport reportWithBidIdAndType(BidWrapper bidWrapper, String type) {
        return new DTBMetricReport(type, bidWrapper);
    }

    static DTBMetricReport reportWithTypeAndExtraProperties(String type, Map<String, Object> extraProps) {
        return new DTBMetricReport(type, extraProps);
    }

    static DTBMetricReport reportWithTypeAndExtraProperties(String type, Map<String, Object> extraProps, BidWrapper bidWrapper) {
        return new DTBMetricReport(type, extraProps, bidWrapper);
    }

    private void setStandardProperties(String type) {
        this.type = type;
        this.propertiesMap = new JSONObject();
        try {
            this.propertiesMap.put(TYPE, (Object)type);
            this.propertiesMap.put(SDK, (Object)"9.8.6");
            this.propertiesMap.put(APP_NAME, (Object)AdRegistration.getAppKey());
            this.propertiesMap.put(PROJECT, (Object)PROJECT_NAME);
            if (this.latency > 0) {
                this.propertiesMap.put(LATENCY, this.latency);
            }
            String adServer = null;
            String adapterVersion = null;
            Class[] classes = new Class[]{};
            try {
                Class<?> clz = Class.forName("com.amazon.admob_adapter.APSAdMobAdapter");
                adServer = "admob";
                Method method = clz.getMethod("getVersion", classes);
                Object o = method.invoke(null, (Object[])null);
                if (o instanceof String) {
                    adapterVersion = (String)o;
                }
            }
            catch (Exception e) {
                try {
                    Class<?> clz = Class.forName("com.amazon.mopub_adapter.APSMopubAdapter");
                    adServer = "mopub";
                    Method method = clz.getMethod("getVersion", classes);
                    Object o = method.invoke(null, (Object[])null);
                    if (o instanceof String) {
                        adapterVersion = (String)o;
                    }
                }
                catch (Exception clz) {
                    // empty catch block
                }
            }
            if (adServer != null) {
                this.propertiesMap.put(ADSERVER, (Object)adServer);
            }
            DtbDeviceData.getDeviceDataInstance();
            String connectionType = DtbDeviceData.getConnectionType();
            String reportedType = connectionType.equals("Wifi") ? "wifi" : (connectionType.equals("0") ? "unknown" : "cellular");
            this.propertiesMap.put(CONNECTION, (Object)reportedType);
            if (adapterVersion != null) {
                this.propertiesMap.put(ADAPTER_VERSION, (Object)adapterVersion);
            }
            this.propertiesMap.put(TIME, new Date().getTime() / 1000L);
        }
        catch (JSONException jse) {
            DtbLog.warn(LOG_TAG, "JSON conversion error:" + jse.getMessage());
        }
    }

    String getType() {
        return this.type;
    }

    String toEncodedString() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.propertiesMap.toString(), "UTF-8");
    }

    public String toString() {
        return this.propertiesMap.toString();
    }

    protected static class BidWrapper {
        String bidId;
        String hostname;

        BidWrapper(String bid, String hostname) {
            this.bidId = bid;
            this.hostname = hostname;
        }
    }
}

