/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import java.util.Date;

public class DTBCacheData {
    private DTBAdRequest cachingLoader;
    private DTBAdResponse cachingResponse;
    private String requestId;
    private long responseTimeStamp;
    private boolean isBidRequestFailed;
    private static long ADMOB_AUTO_REFRESH_TIME_LIMIT_MS = 30000L;

    public DTBCacheData(String requestId, DTBAdRequest dtbAdRequest) {
        this.requestId = requestId;
        this.cachingLoader = dtbAdRequest;
        this.isBidRequestFailed = false;
        this.responseTimeStamp = new Date().getTime();
    }

    public void addResponse(DTBAdResponse dtbAdResponse) {
        this.cachingResponse = dtbAdResponse;
        this.responseTimeStamp = new Date().getTime();
    }

    public void updateResponse(DTBAdResponse dtbAdResponse) {
        this.cachingResponse = dtbAdResponse;
    }

    public DTBAdResponse getAdResponse() {
        long now = new Date().getTime();
        if (now - this.responseTimeStamp <= ADMOB_AUTO_REFRESH_TIME_LIMIT_MS) {
            return this.cachingResponse;
        }
        this.cachingResponse = null;
        return null;
    }

    public long getResponseTimeStamp() {
        return this.responseTimeStamp;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setBidRequestFailed(boolean bidRequestFailed) {
        this.isBidRequestFailed = bidRequestFailed;
    }

    public boolean isBidRequestFailed() {
        return this.isBidRequestFailed;
    }
}

