/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.ActivityMonitor;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBAdViewDisplayListener;
import com.amazon.device.ads.DTBInterstitialActivity;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.MraidStateType;
import java.util.Map;
import org.json.JSONException;

public class DTBAdMRAIDInterstitialController
extends DTBAdMRAIDController
implements DTBAdViewDisplayListener {
    DTBAdInterstitialListener interstitialListener;
    boolean pageLoaded = false;
    boolean pageDisplayed = false;

    DTBAdMRAIDInterstitialController(DTBAdView adView, DTBAdInterstitialListener listener) {
        super(adView);
        this.interstitialListener = listener;
    }

    DTBAdInterstitialListener getInterstitialListener() {
        return this.interstitialListener;
    }

    void setInterstitialListener(DTBAdInterstitialListener listener) {
        this.interstitialListener = listener;
    }

    @Override
    public void onPageLoad() {
        this.pageLoaded = true;
        try {
            this.initializeOnLoadAndDisplay();
            if (this.interstitialListener != null) {
                this.interstitialListener.onAdLoaded((View)this.adView);
            }
            if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("additional_webview_metric")) {
                StringBuilder debugInfo = new StringBuilder("Creative Rendering finish");
                if (!DtbCommonUtils.isNullOrEmpty(this.getAdView().getBidId())) {
                    debugInfo = debugInfo.append(String.format(" interstitialCreativeBidId = %s", this.getAdView().getBidId()));
                }
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, debugInfo.toString());
            }
        }
        catch (JSONException ex) {
            DtbLog.error("Error:" + ex.getMessage());
        }
    }

    void initializeOnLoadAndDisplay() throws JSONException {
        if (this.pageLoaded && this.pageDisplayed) {
            this.prepareMraid();
        } else {
            this.createLoadReport();
        }
    }

    @Override
    protected String getPlacementType() {
        return "interstitial";
    }

    @Override
    public void onInitialDisplay() {
        this.pageDisplayed = true;
        try {
            this.initializeOnLoadAndDisplay();
        }
        catch (JSONException jsx) {
            DtbLog.error("JSON exception:" + jsx.getMessage());
        }
    }

    @Override
    protected void onMRAIDClose() {
        this.executeClose("close");
    }

    private void executeClose(String command) {
        if (this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().stopOmAdSession();
        }
        this.commandCompleted(command);
        this.setState(MraidStateType.HIDDEN);
        this.fireViewableChange(false);
        new Handler(Looper.getMainLooper()).post(() -> this.cleanOnCloseHandler());
    }

    private void cleanOnCloseHandler() {
        try {
            if (this.adView != null) {
                this.adView.setWebViewClient(null);
                this.adView.removeAllViews();
                this.adView.cleanup();
                if (this.interstitialListener != null) {
                    this.interstitialListener.onAdClosed((View)this.adView);
                }
            }
            Activity currentActivity = ActivityMonitor.getInstance().getCurrentActivity();
            if (this.useCustomClose && !currentActivity.isFinishing() && currentActivity instanceof DTBInterstitialActivity) {
                DTBInterstitialActivity interstitialActivity = (DTBInterstitialActivity)currentActivity;
                interstitialActivity.cleanup();
                interstitialActivity.finish();
            }
        }
        catch (RuntimeException e) {
            DtbLog.error(LOG_TAG, "Failed to execute cleanOnCloseHandler method");
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "Failed to execute cleanOnCloseHandler method", e);
        }
    }

    @Override
    protected void onMRAIDUnload() {
        this.executeClose("unload");
    }

    @Override
    protected void onResize(Map<String, Object> parameters) {
        this.fireErrorEvent("resize", "invalid placement type");
        this.commandCompleted("resize");
    }

    @Override
    protected void expand(Map<String, Object> args) {
        this.fireErrorEvent("expand", "invalid placement type for interstitial ");
        this.commandCompleted("expand");
    }

    @Override
    public void onAdOpened() {
        if (this.interstitialListener != null) {
            this.interstitialListener.onAdOpen((View)this.adView);
        }
    }

    @Override
    public void onAdClicked() {
        if (this.interstitialListener != null) {
            new Handler(Looper.getMainLooper()).post(() -> this.interstitialListener.onAdClicked((View)this.adView));
        }
    }

    @Override
    void passLoadError() {
        this.interstitialListener.onAdFailed((View)this.adView);
    }

    @Override
    public void onAdLeftApplication() {
        new Handler(Looper.getMainLooper()).post(() -> this.interstitialListener.onAdLeftApplication((View)this.adView));
        ActivityMonitor.getInstance().setActivityListener(this);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        ActivityMonitor.getInstance().setActivityListener(null);
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        if (this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().stopOmAdSession();
        }
        ActivityMonitor.getInstance().setActivityListener(null);
    }

    @Override
    public void impressionFired() {
        this.interstitialListener.onImpressionFired((View)this.adView);
        super.impressionFired();
    }

    @Override
    public void onVideoCompleted() {
        this.interstitialListener.onVideoCompleted((View)this.adView);
    }
}

