/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.shared.util;

import android.content.Context;
import android.util.Log;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEvent;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class APSNetworkManager {
    private static final String TAG = APSNetworkManager.class.getSimpleName();
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String API_HEADER = "x-api-key";
    private static final String HTTP_POST_METHOD = "POST";
    private static final int SOCK_TIMEOUT = 10000;
    private static final int BUFFER_SIZE = 1024;
    private static APSNetworkManager apsNetworkManager;
    private static long SCHEDULE_INTERVAL;
    private Context context;
    private boolean shutdownInProgress;
    private final ExecutorService executor = Executors.newFixedThreadPool(2);

    private APSNetworkManager(Context context) {
        this.context = context;
        this.shutdownInProgress = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    APSNetworkManager.this.shutdownInProgress = true;
                    Log.d((String)TAG, (String)"App is shutting down, terminating the thread executor");
                    APSNetworkManager.this.executor.shutdown();
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Error in stopping the executor", (Throwable)e);
                }
            }
        });
    }

    public static APSNetworkManager getInstance(Context context) {
        if (apsNetworkManager == null) {
            apsNetworkManager = new APSNetworkManager(context);
        }
        return apsNetworkManager;
    }

    public void sendRemoteLog(APSEvent event) {
        if (event.getEventSeverity() == APSEventSeverity.FATAL) {
            this.sendData(APSAnalytics.getHttpUrl(), APSAnalytics.getApiKey(), event.toJsonPayload());
        }
    }

    public void sendMetrics(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.sendData(ApsMetrics.Companion.getEndpointUrl(), ApsMetrics.Companion.getApiKey(), jsonObject.toString());
        }
    }

    private synchronized void execute(Runnable runnable) {
        try {
            if (!this.shutdownInProgress) {
                this.executor.execute(runnable);
            }
        }
        catch (InternalError error) {
            Log.e((String)TAG, (String)"Internal error in executing the thread", (Throwable)error);
            this.handleError(error);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error running the thread", (Throwable)e);
        }
    }

    private void handleError(InternalError error) {
        if (error.getLocalizedMessage().contains("shutdown")) {
            Log.e((String)TAG, (String)"Got the shutdown signal", (Throwable)error);
        }
    }

    private boolean setConfigsInConnection(HttpsURLConnection urlConnection, String apiKey) {
        try {
            urlConnection.setReadTimeout(10000);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setChunkedStreamingMode(0);
            urlConnection.setRequestMethod(HTTP_POST_METHOD);
            urlConnection.setRequestProperty(CONTENT_TYPE_HEADER, CONTENT_TYPE_VALUE);
            urlConnection.setRequestProperty(API_HEADER, apiKey);
            urlConnection.connect();
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error in setting the connection parameter:", (Throwable)e);
            return false;
        }
    }

    private void closeStreamsAndConnection(InputStream inputStream, OutputStream outStream, HttpsURLConnection urlConnection) {
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException | RuntimeException ex) {
            Log.e((String)TAG, (String)"Unable to close the out stream", (Throwable)ex);
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException | RuntimeException ex) {
            Log.e((String)TAG, (String)"Unable to close the in stream", (Throwable)ex);
        }
        try {
            urlConnection.disconnect();
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)"Unable to close the url connection", (Throwable)ex);
        }
    }

    private void sendData(String httpsUrl, String apiKey, String strToSend) {
        this.execute(() -> this.sendDataAsync(httpsUrl, apiKey, strToSend));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDataAsync(String httpsUrl, String apiKey, String strToSend) {
        boolean bl;
        BufferedOutputStream out;
        BufferedInputStream in;
        HttpsURLConnection urlConnection;
        block5: {
            urlConnection = null;
            InputStream inputStream = null;
            in = null;
            OutputStream outStream = null;
            out = null;
            URL url = new URL(httpsUrl);
            urlConnection = (HttpsURLConnection)url.openConnection();
            if (!this.setConfigsInConnection(urlConnection, apiKey)) break block5;
            outStream = urlConnection.getOutputStream();
            out = new BufferedOutputStream(outStream);
            ((OutputStream)out).write(strToSend.getBytes());
            ((OutputStream)out).flush();
            Log.d((String)TAG, (String)("Sending the event data: " + strToSend));
            int code = urlConnection.getResponseCode();
            Log.d((String)TAG, (String)("Response code received : " + code));
            if (code != 200) break block5;
            byte[] responseBytes = new byte[1024];
            inputStream = urlConnection.getInputStream();
            in = new BufferedInputStream(inputStream);
            ((InputStream)in).read(responseBytes);
            Log.d((String)TAG, (String)("Response received: " + new String(responseBytes)));
            boolean bl2 = true;
            this.closeStreamsAndConnection(in, out, urlConnection);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (IOException | RuntimeException e) {
            try {
                Log.e((String)TAG, (String)"Error in sendData: ", (Throwable)e);
                bl = false;
                this.closeStreamsAndConnection(in, out, urlConnection);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeStreamsAndConnection(in, out, urlConnection);
                throw throwable;
            }
        }
        this.closeStreamsAndConnection(in, out, urlConnection);
        return bl;
    }

    static {
        SCHEDULE_INTERVAL = 10L;
    }
}

