/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.shared;

import android.content.Context;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.ads.model.ApsLogLevel;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsCustomEventModelBuilder;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsDeviceInfo;
import com.amazon.aps.shared.metrics.model.ApsMetricsPerfAaxBidEvent;
import com.amazon.aps.shared.metrics.model.ApsMetricsSdkInfo;
import com.amazon.aps.shared.util.APSNetworkManager;
import com.amazon.aps.shared.util.APSSharedUtil;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/aps/shared/ApsMetrics;", "", "()V", "Companion", "DTBAndroidSDK_release"})
public class ApsMetrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int METRICS_API_SCHEMA_VERSION = 1;
    private static final int SAMPLING_ALLOWED_FROM = 0;
    @NotNull
    private static final String CUSTOM_FAILURE_ERROR_DETAIL = "Error in sending the custom event";
    public static final double METRICS_DEFAULT_SAMPLING_RATE = 0.01;
    @NotNull
    private static ApsMetricsDeviceInfo apsMetricsDeviceInfo = new ApsMetricsDeviceInfo(null, null, null, null, null, 31, null);
    @NotNull
    private static ApsMetricsSdkInfo apsMetricsSdkInfo = new ApsMetricsSdkInfo(null, 1, null);
    @NotNull
    public static final String METRICS_DEFAULT_ENDPOINT_URL = "https://prod.tahoe-analytics.publishers.advertising.a2z.com/logevent/putRecord";
    @NotNull
    public static final String METRICS_DEFAULT_METRICS_API_KEY = "a5c71f6aff54eb34c826d952c285eaf0650b4259c83ae598962681a6429b63f6";
    private static double samplingPercentage = 0.01;
    @Nullable
    private static String endpointUrl = "https://prod.tahoe-analytics.publishers.advertising.a2z.com/logevent/putRecord";
    @Nullable
    private static String apiKey = "a5c71f6aff54eb34c826d952c285eaf0650b4259c83ae598962681a6429b63f6";
    @Nullable
    private static String adapterVersion;
    private static boolean isSamplingAllowed;
    @Nullable
    private static Context context;

    private ApsMetrics() {
    }

    @JvmStatic
    public static final void crashEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra) {
        Companion.crashEvent(eventName, eventValue, extra);
    }

    @JvmStatic
    public static final void customEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra) {
        Companion.customEvent(eventName, eventValue, extra);
    }

    @JvmStatic
    public static final void customEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra, @Nullable String eventCategory) {
        Companion.customEvent(eventName, eventValue, extra, eventCategory);
    }

    @JvmStatic
    public static final void bidEvent(@Nullable String bidId, @Nullable String mediationName, @NotNull ApsMetricsPerfAaxBidEvent aaxBid) {
        Companion.bidEvent(bidId, mediationName, aaxBid);
    }

    @JvmStatic
    public static final void adEvent(@Nullable String bidId, @NotNull ApsMetricsPerfEventModelBuilder builder) {
        Companion.adEvent(bidId, builder);
    }

    @JvmStatic
    public static final void adapterEvent(@Nullable String bidId, @NotNull ApsMetricsPerfEventModelBuilder builder) {
        Companion.adapterEvent(bidId, builder);
    }

    @JvmStatic
    public static final void init(@NotNull Context context, @Nullable ApsMetricsDeviceInfo deviceInfo, @Nullable ApsMetricsSdkInfo sdkInfo) {
        Companion.init(context, deviceInfo, sdkInfo);
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    @JvmStatic
    private static final boolean isOkToSendData() {
        return ApsMetrics.Companion.isOkToSendData();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0007J\u001a\u0010/\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0007J$\u00100\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u000203H\u0007J\b\u00104\u001a\u00020+H\u0002J(\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020\u00042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0007J(\u0010:\u001a\u00020+2\u0006\u00106\u001a\u00020\u00042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0007J4\u0010:\u001a\u00020+2\u0006\u00106\u001a\u00020\u00042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u0001092\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u0004H\u0007J(\u0010<\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u001aH\u0007J\b\u0010?\u001a\u00020$H\u0007J\b\u0010@\u001a\u00020$H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006A"}, d2={"Lcom/amazon/aps/shared/ApsMetrics$Companion;", "", "()V", "CUSTOM_FAILURE_ERROR_DETAIL", "", "METRICS_API_SCHEMA_VERSION", "", "METRICS_DEFAULT_ENDPOINT_URL", "METRICS_DEFAULT_METRICS_API_KEY", "METRICS_DEFAULT_SAMPLING_RATE", "", "SAMPLING_ALLOWED_FROM", "value", "adapterVersion", "getAdapterVersion", "()Ljava/lang/String;", "setAdapterVersion", "(Ljava/lang/String;)V", "apiKey", "getApiKey", "setApiKey", "<set-?>", "Lcom/amazon/aps/shared/metrics/model/ApsMetricsDeviceInfo;", "apsMetricsDeviceInfo", "getApsMetricsDeviceInfo", "()Lcom/amazon/aps/shared/metrics/model/ApsMetricsDeviceInfo;", "Lcom/amazon/aps/shared/metrics/model/ApsMetricsSdkInfo;", "apsMetricsSdkInfo", "getApsMetricsSdkInfo", "()Lcom/amazon/aps/shared/metrics/model/ApsMetricsSdkInfo;", "context", "Landroid/content/Context;", "endpointUrl", "getEndpointUrl", "setEndpointUrl", "isSamplingAllowed", "", "samplingPercentage", "getSamplingPercentage", "()D", "setSamplingPercentage", "(D)V", "adEvent", "", "bidId", "builder", "Lcom/amazon/aps/shared/metrics/ApsMetricsPerfEventModelBuilder;", "adapterEvent", "bidEvent", "mediationName", "aaxBid", "Lcom/amazon/aps/shared/metrics/model/ApsMetricsPerfAaxBidEvent;", "calculateSamplingAllowed", "crashEvent", "eventName", "eventValue", "extra", "Lorg/json/JSONObject;", "customEvent", "eventCategory", "init", "deviceInfo", "sdkInfo", "isInitialized", "isOkToSendData", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApsMetricsDeviceInfo getApsMetricsDeviceInfo() {
            return apsMetricsDeviceInfo;
        }

        @NotNull
        public final ApsMetricsSdkInfo getApsMetricsSdkInfo() {
            return apsMetricsSdkInfo;
        }

        public final double getSamplingPercentage() {
            return samplingPercentage;
        }

        public final void setSamplingPercentage(double value) {
            boolean bl = 0.0 <= value ? value <= 100.0 : false;
            if (bl) {
                samplingPercentage = value;
                this.calculateSamplingAllowed();
            }
        }

        @Nullable
        public final String getEndpointUrl() {
            return endpointUrl;
        }

        public final void setEndpointUrl(@Nullable String value) {
            if (!APSSharedUtil.isNullOrEmpty(value)) {
                endpointUrl = value;
            }
        }

        @Nullable
        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(@Nullable String value) {
            if (!APSSharedUtil.isNullOrEmpty(value)) {
                apiKey = value;
            }
        }

        @Nullable
        public final String getAdapterVersion() {
            return adapterVersion;
        }

        public final void setAdapterVersion(@Nullable String value) {
            String string = value;
            if (string != null) {
                String it = string;
                boolean bl = false;
                adapterVersion = it;
            }
        }

        @JvmStatic
        public final void crashEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!Intrinsics.areEqual((Object)ApsMetrics.CUSTOM_FAILURE_ERROR_DETAIL, (Object)eventValue)) {
                this.customEvent(eventName, eventValue, extra, "crash");
            }
        }

        public static /* synthetic */ void crashEvent$default(Companion companion, String string, String string2, JSONObject jSONObject, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                jSONObject = null;
            }
            companion.crashEvent(string, string2, jSONObject);
        }

        @JvmStatic
        public final void customEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            this.customEvent(eventName, eventValue, extra, null);
        }

        public static /* synthetic */ void customEvent$default(Companion companion, String string, String string2, JSONObject jSONObject, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                jSONObject = null;
            }
            companion.customEvent(string, string2, jSONObject);
        }

        @JvmStatic
        public final void customEvent(@NotNull String eventName, @Nullable String eventValue, @Nullable JSONObject extra, @Nullable String eventCategory) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            ApsLog.d("Logging custom event");
            try {
                String it;
                ApsMetricsCustomEventModelBuilder apsMetricsCustomEventModelBuilder;
                if (!this.isOkToSendData()) {
                    return;
                }
                ApsMetricsCustomEventModelBuilder $this$customEvent_u24lambda_u2d4 = apsMetricsCustomEventModelBuilder = new ApsMetricsCustomEventModelBuilder();
                boolean bl = false;
                $this$customEvent_u24lambda_u2d4.withEventName(eventName);
                String string = eventValue;
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    $this$customEvent_u24lambda_u2d4.withEventValue(eventValue);
                }
                JSONObject jSONObject = extra;
                if (jSONObject != null) {
                    it = jSONObject;
                    boolean bl3 = false;
                    $this$customEvent_u24lambda_u2d4.withEventDetail(extra);
                }
                String string2 = eventCategory;
                if (string2 != null) {
                    it = string2;
                    boolean bl4 = false;
                    $this$customEvent_u24lambda_u2d4.withEventCategory(eventCategory);
                }
                ApsMetricsCustomEventModelBuilder builder = apsMetricsCustomEventModelBuilder;
                JSONObject jSONObject2 = builder.build();
                if (jSONObject2 != null) {
                    JSONObject it2 = jSONObject2;
                    boolean bl5 = false;
                    APSNetworkManager.getInstance(context).sendMetrics(it2);
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, ApsMetrics.CUSTOM_FAILURE_ERROR_DETAIL, e);
            }
        }

        public static /* synthetic */ void customEvent$default(Companion companion, String string, String string2, JSONObject jSONObject, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                jSONObject = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            companion.customEvent(string, string2, jSONObject, string3);
        }

        @JvmStatic
        public final void bidEvent(@Nullable String bidId, @Nullable String mediationName, @NotNull ApsMetricsPerfAaxBidEvent aaxBid) {
            Intrinsics.checkNotNullParameter((Object)aaxBid, (String)"aaxBid");
            ApsLog.d("Logging bid event");
            try {
                if (!this.isOkToSendData()) {
                    return;
                }
                APSNetworkManager.getInstance(context).sendMetrics(new ApsMetricsPerfEventModelBuilder().withMediationName(mediationName).withBidId(bidId).withEvent(aaxBid).build());
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error sending the bid event", e);
            }
        }

        @JvmStatic
        public final void adEvent(@Nullable String bidId, @NotNull ApsMetricsPerfEventModelBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            ApsLog.d("Logging perf metrics event");
            try {
                if (!this.isOkToSendData()) {
                    return;
                }
                APSNetworkManager.getInstance(context).sendMetrics(builder.withBidId(bidId).build());
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error sending the ad event", e);
            }
        }

        @JvmStatic
        public final void adapterEvent(@Nullable String bidId, @NotNull ApsMetricsPerfEventModelBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            ApsLog.d("Logging adapter event");
            this.adEvent(bidId, builder);
        }

        @JvmStatic
        public final void init(@NotNull Context context, @Nullable ApsMetricsDeviceInfo deviceInfo, @Nullable ApsMetricsSdkInfo sdkInfo) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ApsLog.setLogLevel(ApsLogLevel.All);
            try {
                Object it;
                ApsMetricsDeviceInfo apsMetricsDeviceInfo = deviceInfo;
                if (apsMetricsDeviceInfo != null) {
                    it = apsMetricsDeviceInfo;
                    boolean bl = false;
                    ApsMetrics.apsMetricsDeviceInfo = ApsMetricsDeviceInfo.copy$default((ApsMetricsDeviceInfo)it, null, null, null, null, null, 31, null);
                }
                ApsMetricsSdkInfo apsMetricsSdkInfo = sdkInfo;
                if (apsMetricsSdkInfo != null) {
                    it = apsMetricsSdkInfo;
                    boolean bl = false;
                    ApsMetrics.apsMetricsSdkInfo = ApsMetricsSdkInfo.copy$default((ApsMetricsSdkInfo)it, null, 1, null);
                }
                ApsMetrics.context = context;
                this.calculateSamplingAllowed();
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in initializing the ApsMetrics", e);
            }
        }

        public static /* synthetic */ void init$default(Companion companion, Context context, ApsMetricsDeviceInfo apsMetricsDeviceInfo, ApsMetricsSdkInfo apsMetricsSdkInfo, int n, Object object) {
            if ((n & 2) != 0) {
                apsMetricsDeviceInfo = null;
            }
            if ((n & 4) != 0) {
                apsMetricsSdkInfo = null;
            }
            companion.init(context, apsMetricsDeviceInfo, apsMetricsSdkInfo);
        }

        @JvmStatic
        public final boolean isInitialized() {
            return context != null;
        }

        @JvmStatic
        private final boolean isOkToSendData() {
            return this.isInitialized() && isSamplingAllowed && !APSSharedUtil.isNullOrEmpty(this.getApiKey()) && !APSSharedUtil.isNullOrEmpty(this.getEndpointUrl());
        }

        private final void calculateSamplingAllowed() {
            try {
                int samplingRateConv = MathKt.roundToInt((double)(this.getSamplingPercentage() * (double)100000));
                int rate = new Random().nextInt(10000000) + 1;
                isSamplingAllowed = rate <= samplingRateConv;
            }
            catch (RuntimeException e) {
                ApsLog.e(Intrinsics.stringPlus((String)"Unable to set the sampling rate ", (Object)e));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

