/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.net.Uri;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.RequiresApi;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.adview.ApsAdWebViewClientListener;
import com.amazon.aps.ads.util.adview.ApsAdWebViewSchemeHandler;
import com.amazon.aps.ads.util.adview.ApsAdWebViewSupportClientBase;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdView;
import java.io.InputStream;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J&\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u001d\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClient;", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClientBase;", "webviewClientListener", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewClientListener;", "(Lcom/amazon/aps/ads/util/adview/ApsAdWebViewClientListener;)V", "AMAZON_APP_STORE_LINK", "", "AMAZON_APP_STORE_LINK$1", "schemeHandler", "Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSchemeHandler;", "createImageInjectionResponse", "Landroid/webkit/WebResourceResponse;", "jsScript", "matchesLocalInjectionUrl", "", "url", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "onRenderProcessGone", "detail", "Landroid/webkit/RenderProcessGoneDetail;", "shouldInterceptRequest", "shouldOverrideUrlLoading", "Companion", "DTBAndroidSDK_release"})
public class ApsAdWebViewSupportClient
extends ApsAdWebViewSupportClientBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApsAdWebViewClientListener webviewClientListener;
    @NotNull
    private final String AMAZON_APP_STORE_LINK$1;
    @NotNull
    private final ApsAdWebViewSchemeHandler schemeHandler;
    @NotNull
    public static final String MOBILE_SHOPPING_WEB_SCHEME = "com.amazon.mobile.shopping.web";
    @NotNull
    public static final String MOBILE_SHOPPING_SCHEME = "com.amazon.mobile.shopping";
    @NotNull
    public static final String MARKET_SCHEME = "market";
    @NotNull
    public static final String AMAZON_SCHEME = "amzn";
    @NotNull
    public static final String GOOGLE_PLAY_STORE_LINK = "https://play.google.com/store/apps/";
    @NotNull
    public static final String AMAZON_APP_STORE_LINK = "https://www.amazon.com/gp/mas/dl/android?";

    public ApsAdWebViewSupportClient(@NotNull ApsAdWebViewClientListener webviewClientListener) {
        Intrinsics.checkNotNullParameter((Object)webviewClientListener, (String)"webviewClientListener");
        this.webviewClientListener = webviewClientListener;
        this.AMAZON_APP_STORE_LINK$1 = AMAZON_APP_STORE_LINK;
        this.schemeHandler = new ApsAdWebViewSchemeHandler(this.webviewClientListener);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable String url) {
        try {
            ApsAdExtensionsKt.d((Object)this, Intrinsics.stringPlus((String)"Should intercept Resource url: ", (Object)url));
            String string = url;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (this.matchesLocalInjectionUrl(url)) {
                    int last = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null);
                    String string2 = url.substring(last + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    return this.createImageInjectionResponse(string2);
                }
            }
            return super.shouldInterceptRequest(view, url);
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent((Object)this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute shouldInterceptRequest method", e);
            return null;
        }
    }

    public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
        try {
            String string = url;
            if (string != null) {
                String it = string;
                boolean bl = false;
                return this.webviewClientListener.isTwoPartExpand() ? false : this.schemeHandler.openUrl(url);
            }
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent((Object)this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute shouldOverrideUrlLoading method", e);
        }
        return false;
    }

    public void onPageFinished(@Nullable WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ApsAdExtensionsKt.d((Object)this, Intrinsics.stringPlus((String)"Page load completed: ", (Object)url));
        this.webviewClientListener.onPageFinished(url, view);
    }

    @RequiresApi(api=26)
    public boolean onRenderProcessGone(@Nullable WebView view, @NotNull RenderProcessGoneDetail detail) {
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        super.onRenderProcessGone(view, detail);
        this.setCrashed(true);
        ApsAdExtensionsKt.e((Object)this, "WebView client crashed");
        StringBuilder errorInfo = null;
        errorInfo = new StringBuilder("Fail to render ad due to webView crash.");
        String webViewErrorDetail = null;
        webViewErrorDetail = "";
        WebView webView = view;
        if (webView != null) {
            WebView it = webView;
            boolean bl = false;
            if (view instanceof DTBAdView) {
                webViewErrorDetail = detail.toString();
            }
            this.webviewClientListener.onCrash(view, errorInfo, webViewErrorDetail);
        }
        return true;
    }

    public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
        super.onReceivedError(view, request, error);
        ApsAdExtensionsKt.e((Object)this, "WebView client received OnReceivedError");
        try {
            this.webviewClientListener.onLoadError();
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent((Object)this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute onReceivedError method", e);
        }
    }

    private final boolean matchesLocalInjectionUrl(String url) {
        try {
            Uri uri;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = url.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            Uri uri2 = uri = Uri.parse((String)string);
            if (uri2 != null) {
                Uri it = uri2;
                boolean bl = false;
                return Intrinsics.areEqual((Object)"local", (Object)uri.getScheme());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    private final WebResourceResponse createImageInjectionResponse(String jsScript) {
        WebResourceResponse webResourceResponse;
        try {
            InputStream inputStream = this.webviewClientListener.getAdViewContext().getAssets().open(jsScript);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"webviewClientListener.ad\u2026ext.assets.open(jsScript)");
            InputStream data = inputStream;
            webResourceResponse = new WebResourceResponse("image/png", "UTF-8", data);
        }
        catch (Exception e) {
            ApsAdExtensionsKt.logEvent((Object)this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, Intrinsics.stringPlus((String)"Failed to get injection response: ", (Object)jsScript), e);
            webResourceResponse = null;
        }
        return webResourceResponse;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdWebViewSupportClient$Companion;", "", "()V", "AMAZON_APP_STORE_LINK", "", "AMAZON_SCHEME", "GOOGLE_PLAY_STORE_LINK", "MARKET_SCHEME", "MOBILE_SHOPPING_SCHEME", "MOBILE_SHOPPING_WEB_SCHEME", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

