/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.amazon.aps.ads.ApsAd;
import com.amazon.aps.ads.ApsAdFormatUtils;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.util.APSSharedUtil;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.SDKUtilities;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class ApsAdUtils {
    private static final String BID_INFO = "bidInfo";
    private static final String PRICEPOINT_ENCODED = "pricePointEncoded";
    private static final String UUID = "uuid";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static boolean isDebugBuild;

    private ApsAdUtils() {
        isDebugBuild = false;
    }

    public static boolean checkNullAndLogInvalidArg(Object ... params) {
        try {
            APSSharedUtil.checkNullAndThrowException(params);
        }
        catch (IllegalArgumentException e) {
            if (isDebugBuild) {
                throw e;
            }
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Invalid argument for calling the method", e);
            return true;
        }
        return false;
    }

    public static JSONObject getUnityLevelPlayDataForBanner(@NonNull String isBannerKey, @NonNull ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(isBannerKey, apsAd);
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject innerJsonObject = new JSONObject();
            innerJsonObject.put(BID_INFO, (Object)apsAd.getBidInfo());
            innerJsonObject.put(PRICEPOINT_ENCODED, (Object)apsAd.getPricePoint());
            innerJsonObject.put(UUID, (Object)apsAd.getSlotUuid());
            innerJsonObject.put(WIDTH, apsAd.getWidthFromAax());
            innerJsonObject.put(HEIGHT, apsAd.getHeightFromAax());
            jsonObject.put(isBannerKey, (Object)innerJsonObject);
        }
        catch (RuntimeException | JSONException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error constructing the iron source banner object", (Exception)e);
        }
        return jsonObject;
    }

    public static JSONObject getUnityLevelPlayDataForInterstitial(String isInterstitialKey, @NonNull ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(isInterstitialKey, apsAd);
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject innerJsonObject = new JSONObject();
            innerJsonObject.put(BID_INFO, (Object)apsAd.getBidInfo());
            innerJsonObject.put(PRICEPOINT_ENCODED, (Object)apsAd.getPricePoint());
            innerJsonObject.put(UUID, (Object)apsAd.getSlotUuid());
            jsonObject.put(isInterstitialKey, (Object)innerJsonObject);
        }
        catch (RuntimeException | JSONException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error constructing the iron source interstitial object", (Exception)e);
        }
        return jsonObject;
    }

    public static AdManagerAdRequest.Builder createAdManagerAdRequestBuilder(@NonNull ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(apsAd);
        try {
            return DTBAdUtil.INSTANCE.createAdManagerAdRequestBuilder(apsAd);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error constructing the AdManagerAdRequest.Builder object in createAdManagerAdRequestBuilder", e);
            return null;
        }
    }

    public static void addApsAdInAdManagerAdRequest(@NonNull AdManagerAdRequest adRequest, @NonNull ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(adRequest, apsAd);
        try {
            DTBAdUtil.INSTANCE.loadDTBParams(adRequest, (DTBAdResponse)apsAd);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error loading the Aps params in the AdManagerAdRequest.Builder object in loadApsParamsInAdManagerAdRequest", e);
        }
    }

    public static void addApsAdInAdManagerAdRequestBuilder(@NonNull AdManagerAdRequest.Builder adRequestBuilder, @NonNull ApsAd apsAd) {
        ApsAdUtils.checkNullAndLogInvalidArg(adRequestBuilder, apsAd);
        try {
            DTBAdUtil.INSTANCE.loadDTBParams(adRequestBuilder, (DTBAdResponse)apsAd);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error loading the Aps params in the AdManagerAdRequest.Builder object in loadApsParamsInAdManagerAdRequest", e);
        }
    }

    public static Bundle createAdMobInterstitialRequestBundle(@NonNull String slotUuid) {
        ApsAdUtils.checkNullAndLogInvalidArg(slotUuid);
        return DTBAdUtil.createAdMobInterstitialRequestBundle(slotUuid);
    }

    public static boolean isDebugBuild() {
        return isDebugBuild;
    }

    public static Bundle createAdMobInterstitialVideoRequestBundle(@NonNull String slotUuid) {
        ApsAdUtils.checkNullAndLogInvalidArg(slotUuid);
        return DTBAdUtil.createAdMobInterstitialVideoRequestBundle(slotUuid);
    }

    public static Bundle createAdMobBannerRequestBundle(@NonNull String slotUuid, @NonNull ApsAdFormat apsAdFormat) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{slotUuid, apsAdFormat});
        return DTBAdUtil.createAdMobBannerRequestBundle(slotUuid, ApsAdFormatUtils.getWidth(apsAdFormat), ApsAdFormatUtils.getHeight(apsAdFormat));
    }

    public static boolean isTelSupported() {
        return SDKUtilities.isTelSupported();
    }

    static void throwExceptionOrRemoteLog(String message) {
        if (ApsAdUtils.isDebugBuild()) {
            throw new IllegalStateException(message);
        }
        APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, message);
    }

    static {
        new ApsAdUtils();
    }
}

